/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.kiulian.downloader.Config;
import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.cipher.Cipher;
import com.github.kiulian.downloader.cipher.CipherFactory;
import com.github.kiulian.downloader.downloader.Downloader;
import com.github.kiulian.downloader.downloader.YoutubeCallback;
import com.github.kiulian.downloader.downloader.request.RequestChannelUploads;
import com.github.kiulian.downloader.downloader.request.RequestPlaylistInfo;
import com.github.kiulian.downloader.downloader.request.RequestSubtitlesInfo;
import com.github.kiulian.downloader.downloader.request.RequestVideoInfo;
import com.github.kiulian.downloader.downloader.request.RequestWebpage;
import com.github.kiulian.downloader.downloader.response.Response;
import com.github.kiulian.downloader.downloader.response.ResponseImpl;
import com.github.kiulian.downloader.extractor.Extractor;
import com.github.kiulian.downloader.model.playlist.PlaylistDetails;
import com.github.kiulian.downloader.model.playlist.PlaylistInfo;
import com.github.kiulian.downloader.model.playlist.PlaylistVideoDetails;
import com.github.kiulian.downloader.model.subtitles.SubtitlesInfo;
import com.github.kiulian.downloader.model.videos.VideoDetails;
import com.github.kiulian.downloader.model.videos.VideoInfo;
import com.github.kiulian.downloader.model.videos.formats.AudioFormat;
import com.github.kiulian.downloader.model.videos.formats.Format;
import com.github.kiulian.downloader.model.videos.formats.Itag;
import com.github.kiulian.downloader.model.videos.formats.VideoFormat;
import com.github.kiulian.downloader.model.videos.formats.VideoWithAudioFormat;
import com.github.kiulian.downloader.parser.Parser;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;

public class ParserImpl
implements Parser {
    private final Config config;
    private final Downloader downloader;
    private final Extractor extractor;
    private final CipherFactory cipherFactory;

    public ParserImpl(Config config, Downloader downloader, Extractor extractor, CipherFactory cipherFactory) {
        this.config = config;
        this.downloader = downloader;
        this.extractor = extractor;
        this.cipherFactory = cipherFactory;
    }

    @Override
    public Response<VideoInfo> parseVideo(RequestVideoInfo request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<VideoInfo> result = executorService.submit(() -> this.parseVideo(request.getVideoId(), request.getCallback()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            VideoInfo result = this.parseVideo(request.getVideoId(), request.getCallback());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    public VideoInfo parseVideo(String videoId, YoutubeCallback<VideoInfo> callback) throws YoutubeException {
        JSONObject playerConfig;
        String htmlUrl = "https://www.youtube.com/watch?v=" + videoId;
        Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(htmlUrl));
        if (!response.ok()) {
            YoutubeException.DownloadException e = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", htmlUrl, response.error().getMessage()));
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        String html = response.data();
        try {
            playerConfig = this.extractor.extractPlayerConfigFromHtml(html);
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        JSONObject args = playerConfig.getJSONObject("args");
        JSONObject playerResponse = args.getJSONObject("player_response");
        if (!playerResponse.containsKey((Object)"streamingData") && !playerResponse.containsKey((Object)"videoDetails")) {
            throw new YoutubeException.BadPageException("streamingData and videoDetails not found");
        }
        VideoDetails videoDetails = this.parseVideoDetails(videoId, playerResponse);
        if (videoDetails.isDownloadable()) {
            String jsUrl;
            try {
                jsUrl = this.extractor.extractJsUrlFromConfig(playerConfig, videoId);
            }
            catch (YoutubeException e) {
                if (callback != null) {
                    callback.onError(e);
                }
                throw e;
            }
            JSONObject context = playerConfig.getJSONObject("args").getJSONObject("player_response").getJSONObject("responseContext");
            String clientVersion = this.extractor.extractClientVersionFromContext(context);
            List<Format> formats = this.parseFormats(playerResponse, jsUrl, clientVersion);
            List<SubtitlesInfo> subtitlesInfo = this.parseCaptions(playerResponse);
            return new VideoInfo(videoDetails, formats, subtitlesInfo);
        }
        return new VideoInfo(videoDetails, Collections.emptyList(), Collections.emptyList());
    }

    private VideoDetails parseVideoDetails(String videoId, JSONObject playerResponse) {
        if (!playerResponse.containsKey((Object)"videoDetails")) {
            return new VideoDetails(videoId);
        }
        JSONObject videoDetails = playerResponse.getJSONObject("videoDetails");
        String liveHLSUrl = null;
        if (videoDetails.getBooleanValue("isLive") && playerResponse.containsKey((Object)"streamingData")) {
            liveHLSUrl = playerResponse.getJSONObject("streamingData").getString("hlsManifestUrl");
        }
        return new VideoDetails(videoDetails, liveHLSUrl);
    }

    private List<Format> parseFormats(JSONObject playerResponse, String jsUrl, String clientVersion) throws YoutubeException {
        if (!playerResponse.containsKey((Object)"streamingData")) {
            throw new YoutubeException.BadPageException("streamingData not found");
        }
        JSONObject streamingData = playerResponse.getJSONObject("streamingData");
        JSONArray jsonFormats = new JSONArray();
        if (streamingData.containsKey((Object)"formats")) {
            jsonFormats.addAll((Collection)streamingData.getJSONArray("formats"));
        }
        JSONArray jsonAdaptiveFormats = new JSONArray();
        if (streamingData.containsKey((Object)"adaptiveFormats")) {
            jsonAdaptiveFormats.addAll((Collection)streamingData.getJSONArray("adaptiveFormats"));
        }
        ArrayList<Format> formats = new ArrayList<Format>(jsonFormats.size() + jsonAdaptiveFormats.size());
        this.populateFormats(formats, jsonFormats, jsUrl, false, clientVersion);
        this.populateFormats(formats, jsonAdaptiveFormats, jsUrl, true, clientVersion);
        return formats;
    }

    private void populateFormats(List<Format> formats, JSONArray jsonFormats, String jsUrl, boolean isAdaptive, String clientVersion) throws YoutubeException.CipherException {
        for (int i = 0; i < jsonFormats.size(); ++i) {
            Itag itag;
            JSONObject json = jsonFormats.getJSONObject(i);
            if ("FORMAT_STREAM_TYPE_OTF".equals(json.getString("type"))) continue;
            int itagValue = json.getIntValue("itag");
            try {
                itag = Itag.valueOf("i" + itagValue);
            }
            catch (IllegalArgumentException e) {
                System.err.println("Error parsing format: unknown itag " + itagValue);
                continue;
            }
            try {
                Format format = this.parseFormat(json, jsUrl, itag, isAdaptive, clientVersion);
                formats.add(format);
                continue;
            }
            catch (YoutubeException.CipherException e) {
                throw e;
            }
            catch (YoutubeException e) {
                System.err.println("Error " + e.getMessage() + " parsing format: " + json);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Format parseFormat(JSONObject json, String jsUrl, Itag itag, boolean isAdaptive, String clientVersion) throws YoutubeException {
        boolean hasAudio;
        if (json.containsKey((Object)"signatureCipher")) {
            String[] cipherData;
            JSONObject jsonCipher = new JSONObject();
            for (String s : cipherData = json.getString("signatureCipher").replace("\\u0026", "&").split("&")) {
                String[] keyValue = s.split("=");
                jsonCipher.put(keyValue[0], (Object)keyValue[1]);
            }
            if (!jsonCipher.containsKey((Object)"url")) {
                throw new YoutubeException.BadPageException("Could not found url in cipher data");
            }
            String urlWithSig = jsonCipher.getString("url");
            try {
                urlWithSig = URLDecoder.decode(urlWithSig, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (!urlWithSig.contains("signature") && (jsonCipher.containsKey((Object)"s") || !urlWithSig.contains("&sig=") && !urlWithSig.contains("&lsig="))) {
                String s = jsonCipher.getString("s");
                try {
                    s = URLDecoder.decode(s, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                Cipher cipher = this.cipherFactory.createCipher(jsUrl);
                String signature = cipher.getSignature(s);
                String decipheredUrl = urlWithSig + "&sig=" + signature;
                json.put("url", (Object)decipheredUrl);
            }
        }
        boolean hasVideo = itag.isVideo() || json.containsKey((Object)"size") || json.containsKey((Object)"width");
        boolean bl = hasAudio = itag.isAudio() || json.containsKey((Object)"audioQuality");
        if (hasVideo && hasAudio) {
            return new VideoWithAudioFormat(json, isAdaptive, clientVersion);
        }
        if (hasVideo) {
            return new VideoFormat(json, isAdaptive, clientVersion);
        }
        return new AudioFormat(json, isAdaptive, clientVersion);
    }

    private List<SubtitlesInfo> parseCaptions(JSONObject playerResponse) {
        if (!playerResponse.containsKey((Object)"captions")) {
            return Collections.emptyList();
        }
        JSONObject captions = playerResponse.getJSONObject("captions");
        JSONObject playerCaptionsTracklistRenderer = captions.getJSONObject("playerCaptionsTracklistRenderer");
        if (playerCaptionsTracklistRenderer == null || playerCaptionsTracklistRenderer.isEmpty()) {
            return Collections.emptyList();
        }
        JSONArray captionsArray = playerCaptionsTracklistRenderer.getJSONArray("captionTracks");
        if (captionsArray == null || captionsArray.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubtitlesInfo> subtitlesInfo = new ArrayList<SubtitlesInfo>();
        for (int i = 0; i < captionsArray.size(); ++i) {
            JSONObject subtitleInfo = captionsArray.getJSONObject(i);
            String language = subtitleInfo.getString("languageCode");
            String url = subtitleInfo.getString("baseUrl");
            String vssId = subtitleInfo.getString("vssId");
            if (language == null || url == null || vssId == null) continue;
            boolean isAutoGenerated = vssId.startsWith("a.");
            subtitlesInfo.add(new SubtitlesInfo(url, language, isAutoGenerated, true));
        }
        return subtitlesInfo;
    }

    @Override
    public Response<PlaylistInfo> parsePlaylist(RequestPlaylistInfo request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<PlaylistInfo> result = executorService.submit(() -> this.parsePlaylist(request.getPlaylistId(), request.getCallback()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            PlaylistInfo result = this.parsePlaylist(request.getPlaylistId(), request.getCallback());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    private PlaylistInfo parsePlaylist(String playlistId, YoutubeCallback<PlaylistInfo> callback) throws YoutubeException {
        List<PlaylistVideoDetails> videos;
        JSONObject initialData;
        String htmlUrl = "https://www.youtube.com/playlist?list=" + playlistId;
        Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(htmlUrl));
        if (!response.ok()) {
            YoutubeException.DownloadException e = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", htmlUrl, response.error().getMessage()));
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        String html = response.data();
        try {
            initialData = this.extractor.extractInitialDataFromHtml(html);
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        if (!initialData.containsKey((Object)"metadata")) {
            throw new YoutubeException.BadPageException("Invalid initial data json");
        }
        PlaylistDetails playlistDetails = this.parsePlaylistDetails(playlistId, initialData);
        try {
            videos = this.parsePlaylistVideos(initialData, playlistDetails.videoCount());
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        return new PlaylistInfo(playlistDetails, videos);
    }

    private PlaylistDetails parsePlaylistDetails(String playlistId, JSONObject initialData) {
        String title = initialData.getJSONObject("metadata").getJSONObject("playlistMetadataRenderer").getString("title");
        JSONArray sideBarItems = initialData.getJSONObject("sidebar").getJSONObject("playlistSidebarRenderer").getJSONArray("items");
        String author = null;
        try {
            author = sideBarItems.getJSONObject(1).getJSONObject("playlistSidebarSecondaryInfoRenderer").getJSONObject("videoOwner").getJSONObject("videoOwnerRenderer").getJSONObject("title").getJSONArray("runs").getJSONObject(0).getString("text");
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONArray stats = sideBarItems.getJSONObject(0).getJSONObject("playlistSidebarPrimaryInfoRenderer").getJSONArray("stats");
        int videoCount = this.extractor.extractIntegerFromText(stats.getJSONObject(0).getJSONArray("runs").getJSONObject(0).getString("text"));
        int viewCount = this.extractor.extractIntegerFromText(stats.getJSONObject(1).getString("simpleText"));
        return new PlaylistDetails(playlistId, title, author, videoCount, viewCount);
    }

    private List<PlaylistVideoDetails> parsePlaylistVideos(JSONObject initialData, int videoCount) throws YoutubeException {
        JSONObject content;
        try {
            content = initialData.getJSONObject("contents").getJSONObject("twoColumnBrowseResultsRenderer").getJSONArray("tabs").getJSONObject(0).getJSONObject("tabRenderer").getJSONObject("content").getJSONObject("sectionListRenderer").getJSONArray("contents").getJSONObject(0).getJSONObject("itemSectionRenderer").getJSONArray("contents").getJSONObject(0).getJSONObject("playlistVideoListRenderer");
        }
        catch (NullPointerException e) {
            throw new YoutubeException.BadPageException("Playlist initial data not found");
        }
        AbstractList videos = videoCount > 0 ? new ArrayList(videoCount) : new LinkedList();
        JSONObject context = initialData.getJSONObject("responseContext");
        String clientVersion = this.extractor.extractClientVersionFromContext(context);
        this.populatePlaylist(content, videos, clientVersion);
        return videos;
    }

    private void populatePlaylist(JSONObject content, List<PlaylistVideoDetails> videos, String clientVersion) throws YoutubeException {
        JSONArray contents;
        if (content.containsKey((Object)"contents")) {
            contents = content.getJSONArray("contents");
        } else if (content.containsKey((Object)"continuationItems")) {
            contents = content.getJSONArray("continuationItems");
        } else {
            if (content.containsKey((Object)"continuations")) {
                JSONObject nextContinuationData = content.getJSONArray("continuations").getJSONObject(0).getJSONObject("nextContinuationData");
                String continuation = nextContinuationData.getString("continuation");
                String ctp = nextContinuationData.getString("clickTrackingParams");
                this.loadPlaylistContinuation(continuation, ctp, videos, clientVersion);
                return;
            }
            return;
        }
        for (int i = 0; i < contents.size(); ++i) {
            JSONObject contentsItem = contents.getJSONObject(i);
            if (contentsItem.containsKey((Object)"playlistVideoRenderer")) {
                videos.add(new PlaylistVideoDetails(contentsItem.getJSONObject("playlistVideoRenderer")));
                continue;
            }
            if (!contentsItem.containsKey((Object)"continuationItemRenderer")) continue;
            JSONObject continuationEndpoint = contentsItem.getJSONObject("continuationItemRenderer").getJSONObject("continuationEndpoint");
            String continuation = continuationEndpoint.getJSONObject("continuationCommand").getString("token");
            String ctp = continuationEndpoint.getString("clickTrackingParams");
            this.loadPlaylistContinuation(continuation, ctp, videos, clientVersion);
        }
    }

    private void loadPlaylistContinuation(String continuation, String ctp, List<PlaylistVideoDetails> videos, String clientVersion) throws YoutubeException {
        String url = "https://www.youtube.com/youtubei/v1/browse?key=AIzaSyAO_FJ2SlqU8Q4STEHLGCilw_Y9_11qcW8";
        JSONObject body = new JSONObject().fluentPut("context", (Object)new JSONObject().fluentPut("client", (Object)new JSONObject().fluentPut("clientName", (Object)"WEB").fluentPut("clientVersion", (Object)"2.20201021.03.00"))).fluentPut("continuation", (Object)continuation).fluentPut("clickTracking", (Object)new JSONObject().fluentPut("clickTrackingParams", (Object)ctp));
        RequestWebpage request = (RequestWebpage)((RequestWebpage)((RequestWebpage)new RequestWebpage(url, "POST", body.toJSONString()).header("X-YouTube-Client-Name", "1")).header("X-YouTube-Client-Version", clientVersion)).header("Content-Type", "application/json");
        Response<String> response = this.downloader.downloadWebpage(request);
        if (!response.ok()) {
            throw new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", url, response.error().getMessage()));
        }
        String html = response.data();
        try {
            JSONObject jsonResponse = JSON.parseObject((String)html);
            JSONObject content = jsonResponse.containsKey((Object)"continuationContents") ? jsonResponse.getJSONObject("continuationContents").getJSONObject("playlistVideoListContinuation") : jsonResponse.getJSONArray("onResponseReceivedActions").getJSONObject(0).getJSONObject("appendContinuationItemsAction");
            this.populatePlaylist(content, videos, clientVersion);
        }
        catch (YoutubeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new YoutubeException.BadPageException("Could not parse playlist continuation json");
        }
    }

    @Override
    public Response<PlaylistInfo> parseChannelsUploads(RequestChannelUploads request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<PlaylistInfo> result = executorService.submit(() -> this.parseChannelsUploads(request.getChannelId(), request.getCallback()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            PlaylistInfo result = this.parseChannelsUploads(request.getChannelId(), request.getCallback());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    private PlaylistInfo parseChannelsUploads(String channelId, YoutubeCallback<PlaylistInfo> callback) throws YoutubeException {
        String playlistId = null;
        if (channelId.length() == 24 && channelId.startsWith("UC")) {
            playlistId = "UU" + channelId.substring(2);
        } else {
            String channelLink = "https://www.youtube.com/c/" + channelId + "/videos?view=57";
            Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(channelLink));
            if (!response.ok()) {
                YoutubeException.DownloadException e = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", channelLink, response.error().getMessage()));
                if (callback != null) {
                    callback.onError(e);
                }
                throw e;
            }
            String html = response.data();
            Scanner scan = new Scanner(html);
            scan.useDelimiter("list=");
            while (scan.hasNext()) {
                String pId = scan.next();
                if (!pId.startsWith("UU")) continue;
                playlistId = pId.substring(0, 24);
                break;
            }
        }
        if (playlistId == null) {
            YoutubeException.BadPageException e = new YoutubeException.BadPageException("Upload Playlist not found");
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        return this.parsePlaylist(playlistId, callback);
    }

    @Override
    public Response<List<SubtitlesInfo>> parseSubtitlesInfo(RequestSubtitlesInfo request) {
        if (request.isAsync()) {
            ExecutorService executorService = this.config.getExecutorService();
            Future<List> result = executorService.submit(() -> this.parseSubtitlesInfo(request.getVideoId(), request.getCallback()));
            return ResponseImpl.fromFuture(result);
        }
        try {
            List<SubtitlesInfo> result = this.parseSubtitlesInfo(request.getVideoId(), request.getCallback());
            return ResponseImpl.from(result);
        }
        catch (YoutubeException e) {
            return ResponseImpl.error(e);
        }
    }

    private List<SubtitlesInfo> parseSubtitlesInfo(String videoId, YoutubeCallback<List<SubtitlesInfo>> callback) throws YoutubeException {
        List<String> languages;
        String xmlUrl = "https://video.google.com/timedtext?hl=en&type=list&v=" + videoId;
        Response<String> response = this.downloader.downloadWebpage(new RequestWebpage(xmlUrl));
        if (!response.ok()) {
            YoutubeException.DownloadException e = new YoutubeException.DownloadException(String.format("Could not load url: %s, exception: %s", xmlUrl, response.error().getMessage()));
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        String xml = response.data();
        try {
            languages = this.extractor.extractSubtitlesLanguagesFromXml(xml);
        }
        catch (YoutubeException e) {
            if (callback != null) {
                callback.onError(e);
            }
            throw e;
        }
        ArrayList<SubtitlesInfo> subtitlesInfo = new ArrayList<SubtitlesInfo>();
        for (String language : languages) {
            String url = String.format("https://www.youtube.com/api/timedtext?lang=%s&v=%s", language, videoId);
            subtitlesInfo.add(new SubtitlesInfo(url, language, false));
        }
        return subtitlesInfo;
    }
}

