/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.cipher.CachedCipherFactory;
import com.github.kiulian.downloader.cipher.Cipher;
import com.github.kiulian.downloader.cipher.CipherFactory;
import com.github.kiulian.downloader.extractor.DefaultExtractor;
import com.github.kiulian.downloader.extractor.Extractor;
import com.github.kiulian.downloader.model.Itag;
import com.github.kiulian.downloader.model.VideoDetails;
import com.github.kiulian.downloader.model.formats.AudioFormat;
import com.github.kiulian.downloader.model.formats.AudioVideoFormat;
import com.github.kiulian.downloader.model.formats.Format;
import com.github.kiulian.downloader.model.formats.VideoFormat;
import com.github.kiulian.downloader.model.subtitles.SubtitlesInfo;
import com.github.kiulian.downloader.parser.Parser;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DefaultParser
implements Parser {
    private static final Pattern subtitleLangCodeRegex = Pattern.compile("lang_code=\"(.{2,3})\"");
    private Extractor extractor = new DefaultExtractor();
    private CipherFactory cipherFactory = new CachedCipherFactory(this.extractor);

    @Override
    public Extractor getExtractor() {
        return this.extractor;
    }

    @Override
    public CipherFactory getCipherFactory() {
        return this.cipherFactory;
    }

    @Override
    public JSONObject getPlayerConfig(String htmlUrl) throws YoutubeException {
        String html = this.extractor.loadUrl(htmlUrl);
        String ytPlayerConfig = this.extractor.extractYtPlayerConfig(html);
        try {
            return JSON.parseObject((String)ytPlayerConfig);
        }
        catch (Exception e) {
            throw new YoutubeException.BadPageException("Could not parse player config json");
        }
    }

    @Override
    public String getJsUrl(JSONObject config) throws YoutubeException {
        if (!config.containsKey((Object)"assets")) {
            throw new YoutubeException.BadPageException("Could not extract js url: assets not found");
        }
        return "https://youtube.com" + config.getJSONObject("assets").getString("js");
    }

    @Override
    public VideoDetails getVideoDetails(JSONObject config) {
        JSONObject args = config.getJSONObject("args");
        JSONObject playerResponse = args.getJSONObject("player_response");
        if (playerResponse.containsKey((Object)"videoDetails")) {
            JSONObject videoDetails = playerResponse.getJSONObject("videoDetails");
            String liveHLSUrl = null;
            if (videoDetails.getBooleanValue("isLive") && playerResponse.containsKey((Object)"streamingData")) {
                liveHLSUrl = playerResponse.getJSONObject("streamingData").getString("hlsManifestUrl");
            }
            return new VideoDetails(videoDetails, liveHLSUrl);
        }
        return new VideoDetails();
    }

    @Override
    public List<SubtitlesInfo> getSubtitlesInfoFromCaptions(JSONObject config) {
        JSONObject args = config.getJSONObject("args");
        JSONObject playerResponse = args.getJSONObject("player_response");
        if (!playerResponse.containsKey((Object)"captions")) {
            return Collections.emptyList();
        }
        JSONObject captions = playerResponse.getJSONObject("captions");
        JSONObject playerCaptionsTracklistRenderer = captions.getJSONObject("playerCaptionsTracklistRenderer");
        if (playerCaptionsTracklistRenderer == null || playerCaptionsTracklistRenderer.isEmpty()) {
            return Collections.emptyList();
        }
        JSONArray captionsArray = playerCaptionsTracklistRenderer.getJSONArray("captionTracks");
        if (captionsArray == null || captionsArray.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SubtitlesInfo> subtitlesInfo = new ArrayList<SubtitlesInfo>();
        for (int i = 0; i < captionsArray.size(); ++i) {
            JSONObject subtitleInfo = captionsArray.getJSONObject(i);
            String language = subtitleInfo.getString("languageCode");
            String url = subtitleInfo.getString("baseUrl");
            String vssId = subtitleInfo.getString("vssId");
            if (language == null || url == null || vssId == null) continue;
            boolean isAutoGenerated = vssId.startsWith("a.");
            subtitlesInfo.add(new SubtitlesInfo(url, language, isAutoGenerated));
        }
        return subtitlesInfo;
    }

    @Override
    public List<SubtitlesInfo> getSubtitlesInfo(String videoId) throws YoutubeException {
        String xmlUrl = "https://video.google.com/timedtext?hl=en&type=list&v=" + videoId;
        String subtitlesXml = this.extractor.loadUrl(xmlUrl);
        Matcher matcher = subtitleLangCodeRegex.matcher(subtitlesXml);
        if (!matcher.find()) {
            return Collections.emptyList();
        }
        ArrayList<SubtitlesInfo> subtitlesInfo = new ArrayList<SubtitlesInfo>();
        do {
            String language = matcher.group(1);
            String url = String.format("https://www.youtube.com/api/timedtext?lang=%s&v=%s", language, videoId);
            subtitlesInfo.add(new SubtitlesInfo(url, language, false));
        } while (matcher.find());
        return subtitlesInfo;
    }

    @Override
    public List<Format> parseFormats(JSONObject config) throws YoutubeException {
        JSONObject args = config.getJSONObject("args");
        JSONObject playerResponse = args.getJSONObject("player_response");
        if (!playerResponse.containsKey((Object)"streamingData")) {
            throw new YoutubeException.BadPageException("Streaming data not found");
        }
        JSONObject streamingData = playerResponse.getJSONObject("streamingData");
        JSONArray jsonFormats = new JSONArray();
        if (streamingData.containsKey((Object)"formats")) {
            jsonFormats.addAll((Collection)streamingData.getJSONArray("formats"));
        }
        if (streamingData.containsKey((Object)"adaptiveFormats")) {
            jsonFormats.addAll((Collection)streamingData.getJSONArray("adaptiveFormats"));
        }
        ArrayList<Format> formats = new ArrayList<Format>(jsonFormats.size());
        for (int i = 0; i < jsonFormats.size(); ++i) {
            JSONObject json = jsonFormats.getJSONObject(i);
            if ("FORMAT_STREAM_TYPE_OTF".equals(json.getString("type"))) continue;
            try {
                Format format = this.parseFormat(json, config);
                formats.add(format);
                continue;
            }
            catch (YoutubeException.CipherException e) {
                throw e;
            }
            catch (YoutubeException e) {
                System.err.println("Error parsing format: " + json);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return formats;
    }

    private Format parseFormat(JSONObject json, JSONObject config) throws YoutubeException {
        boolean hasAudio;
        Itag itag;
        if (json.containsKey((Object)"signatureCipher")) {
            String[] cipherData;
            JSONObject jsonCipher = new JSONObject();
            for (String s : cipherData = json.getString("signatureCipher").replace("\\u0026", "&").split("&")) {
                String[] keyValue = s.split("=");
                jsonCipher.put(keyValue[0], (Object)keyValue[1]);
            }
            if (!jsonCipher.containsKey((Object)"url")) {
                throw new YoutubeException.BadPageException("Could not found url in cipher data");
            }
            String urlWithSig = jsonCipher.getString("url");
            try {
                urlWithSig = URLDecoder.decode(urlWithSig, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            if (!urlWithSig.contains("signature") && (jsonCipher.containsKey((Object)"s") || !urlWithSig.contains("&sig=") && !urlWithSig.contains("&lsig="))) {
                String s = jsonCipher.getString("s");
                try {
                    s = URLDecoder.decode(s, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
                String jsUrl = this.getJsUrl(config);
                Cipher cipher = this.cipherFactory.createCipher(jsUrl);
                String signature = cipher.getSignature(s);
                String decipheredUrl = urlWithSig + "&sig=" + signature;
                json.put("url", (Object)decipheredUrl);
            }
        }
        try {
            itag = Itag.valueOf("i" + json.getInteger("itag"));
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            itag = Itag.unknown;
            itag.setId(json.getIntValue("itag"));
        }
        boolean hasVideo = itag.isVideo() || json.containsKey((Object)"quality");
        boolean bl = hasAudio = itag.isAudio() || json.containsKey((Object)"audioQuality");
        if (hasVideo && hasAudio) {
            return new AudioVideoFormat(json);
        }
        if (hasVideo) {
            return new VideoFormat(json);
        }
        if (hasAudio) {
            return new AudioFormat(json);
        }
        throw new YoutubeException.UnknownFormatException("unknown format with itag " + itag.id());
    }
}

