/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader.model.formats;

import com.alibaba.fastjson.JSONObject;
import com.github.kiulian.downloader.model.formats.Format;
import com.github.kiulian.downloader.model.quality.AudioQuality;
import com.github.kiulian.downloader.model.quality.VideoQuality;

public class AudioVideoFormat
extends Format {
    private final Integer averageBitrate;
    private final Integer audioSampleRate;
    private final AudioQuality audioQuality;
    private final String qualityLabel;
    private final Integer width;
    private final Integer height;
    private final VideoQuality videoQuality;

    public AudioVideoFormat(JSONObject json) {
        super(json);
        this.audioSampleRate = json.getInteger("audioSampleRate");
        this.averageBitrate = json.getInteger("averageBitrate");
        this.qualityLabel = json.getString("qualityLabel");
        this.width = json.getInteger("width");
        this.height = json.getInteger("height");
        VideoQuality videoQuality = null;
        if (json.containsKey((Object)"quality")) {
            try {
                videoQuality = VideoQuality.valueOf(json.getString("quality"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.videoQuality = videoQuality;
        AudioQuality audioQuality = null;
        if (json.containsKey((Object)"audioQuality")) {
            String[] split = json.getString("audioQuality").split("_");
            String quality = split[split.length - 1].toLowerCase();
            try {
                audioQuality = AudioQuality.valueOf(quality);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.audioQuality = audioQuality;
    }

    @Override
    public String type() {
        return "audio/video";
    }

    public VideoQuality videoQuality() {
        return this.videoQuality != null ? this.videoQuality : this.itag.videoQuality();
    }

    public String qualityLabel() {
        return this.qualityLabel;
    }

    public Integer width() {
        return this.width;
    }

    public Integer height() {
        return this.height;
    }

    public Integer averageBitrate() {
        return this.averageBitrate;
    }

    public AudioQuality audioQuality() {
        return this.audioQuality != null ? this.audioQuality : this.itag.audioQuality();
    }

    public Integer audioSampleRate() {
        return this.audioSampleRate;
    }
}

