/*
 * Decompiled with CFR 0.152.
 */
package com.github.kiulian.downloader;

import com.alibaba.fastjson.JSONObject;
import com.github.kiulian.downloader.YoutubeException;
import com.github.kiulian.downloader.cipher.CipherFunction;
import com.github.kiulian.downloader.model.VideoDetails;
import com.github.kiulian.downloader.model.YoutubeVideo;
import com.github.kiulian.downloader.model.formats.Format;
import com.github.kiulian.downloader.model.subtitles.SubtitlesInfo;
import com.github.kiulian.downloader.parser.DefaultParser;
import com.github.kiulian.downloader.parser.Parser;
import java.util.List;

public class YoutubeDownloader {
    private Parser parser;

    public YoutubeDownloader() {
        this.parser = new DefaultParser();
    }

    public YoutubeDownloader(Parser parser) {
        this.parser = parser;
    }

    public void setParserRequestProperty(String key, String value) {
        this.parser.getExtractor().setRequestProperty(key, value);
    }

    public void setParserRetryOnFailure(int retryOnFailure) {
        this.parser.getExtractor().setRetryOnFailure(retryOnFailure);
    }

    public void addCipherFunctionPattern(int priority, String regex) {
        this.parser.getCipherFactory().addInitialFunctionPattern(priority, regex);
    }

    public void addCipherFunctionEquivalent(String regex, CipherFunction function) {
        this.parser.getCipherFactory().addFunctionEquivalent(regex, function);
    }

    public YoutubeVideo getVideo(String videoId) throws YoutubeException {
        String htmlUrl = "https://www.youtube.com/watch?v=" + videoId;
        JSONObject ytPlayerConfig = this.parser.getPlayerConfig(htmlUrl);
        VideoDetails videoDetails = this.parser.getVideoDetails(ytPlayerConfig);
        List<Format> formats = this.parser.parseFormats(ytPlayerConfig);
        List<SubtitlesInfo> subtitlesInfo = this.parser.getSubtitlesInfoFromCaptions(ytPlayerConfig);
        return new YoutubeVideo(videoDetails, formats, subtitlesInfo);
    }

    public List<SubtitlesInfo> getVideoSubtitles(String videoId) throws YoutubeException {
        return this.parser.getSubtitlesInfo(videoId);
    }
}

