/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.wagon;

import com.amazonaws.internal.ResettableInputStream;
import java.io.File;
import java.io.IOException;
import org.kuali.maven.wagon.TransferProgress;

public class TransferProgressFileInputStream
extends ResettableInputStream {
    private TransferProgress progress;

    public TransferProgressFileInputStream(File file, TransferProgress progress) throws IOException {
        super(file);
        this.progress = progress;
    }

    public int read() throws IOException {
        int b = super.read();
        if (b != -1) {
            this.progress.notify(new byte[]{(byte)b}, 1);
        }
        return b;
    }

    public int read(byte[] b) throws IOException {
        int length = super.read(b);
        if (length != -1) {
            this.progress.notify(b, length);
        }
        return length;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int count = super.read(b, off, len);
        if (count == -1) {
            return count;
        }
        if (off == 0) {
            this.progress.notify(b, count);
        } else {
            byte[] bytes = new byte[len];
            System.arraycopy(b, off, bytes, 0, count);
            this.progress.notify(bytes, count);
        }
        return count;
    }
}

