/*
 * Decompiled with CFR 0.152.
 */
package com.rosa.library.SpeechRecognition;

import android.app.Activity;
import android.content.Intent;
import android.support.v7.app.AppCompatActivity;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Locale;

public class SpeechRecognition {
    private Activity mActivity;
    private int mReqCode;
    private String mPrompt;

    public SpeechRecognition(Activity activity, int reqCode) {
        this.setReqCode(reqCode);
        this.setActivity(activity);
    }

    public static SpeechRecognition newInstance(AppCompatActivity activity, int reqCode) {
        return new SpeechRecognition((Activity)activity, reqCode);
    }

    public void speechInput() {
        Intent intent = new Intent("android.speech.action.RECOGNIZE_SPEECH");
        intent.putExtra("android.speech.extra.LANGUAGE_MODEL", "free_form");
        intent.putExtra("android.speech.extra.LANGUAGE", (Serializable)Locale.getDefault());
        if (this.getPrompt() != null && !this.getPrompt().equals("")) {
            intent.putExtra("android.speech.extra.PROMPT", this.getPrompt());
        }
        if (this.getActivity() != null) {
            this.getActivity().startActivityForResult(intent, this.getReqCode());
        }
    }

    public String getResultedText(int requestCode, int resultCode, Intent data) {
        String resultedText = "";
        if (requestCode == this.getReqCode() && resultCode == -1 && null != data) {
            ArrayList result = data.getStringArrayListExtra("android.speech.extra.RESULTS");
            resultedText = (String)result.get(0);
        }
        return resultedText;
    }

    private Activity getActivity() {
        return this.mActivity;
    }

    private void setActivity(Activity activity) {
        this.mActivity = activity;
    }

    private int getReqCode() {
        return this.mReqCode;
    }

    private void setReqCode(int reqCode) {
        this.mReqCode = reqCode;
    }

    private String getPrompt() {
        return this.mPrompt;
    }

    public SpeechRecognition setPrompt(String prompt) {
        this.mPrompt = prompt;
        return this;
    }
}

