/*
 * Decompiled with CFR 0.152.
 */
package com.scwang.smart.refresh.layout;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.NestedScrollingChildHelper;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.NestedScrollingParentHelper;
import android.support.v4.view.ViewCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AnimationUtils;
import android.view.animation.Interpolator;
import android.widget.AbsListView;
import android.widget.Scroller;
import android.widget.TextView;
import android.widget.Toast;
import com.scwang.smart.refresh.layout.api.RefreshComponent;
import com.scwang.smart.refresh.layout.api.RefreshContent;
import com.scwang.smart.refresh.layout.api.RefreshFooter;
import com.scwang.smart.refresh.layout.api.RefreshHeader;
import com.scwang.smart.refresh.layout.api.RefreshKernel;
import com.scwang.smart.refresh.layout.api.RefreshLayout;
import com.scwang.smart.refresh.layout.constant.DimensionStatus;
import com.scwang.smart.refresh.layout.constant.RefreshState;
import com.scwang.smart.refresh.layout.constant.SpinnerStyle;
import com.scwang.smart.refresh.layout.kernel.R;
import com.scwang.smart.refresh.layout.listener.DefaultRefreshFooterCreator;
import com.scwang.smart.refresh.layout.listener.DefaultRefreshHeaderCreator;
import com.scwang.smart.refresh.layout.listener.DefaultRefreshInitializer;
import com.scwang.smart.refresh.layout.listener.OnLoadMoreListener;
import com.scwang.smart.refresh.layout.listener.OnMultiListener;
import com.scwang.smart.refresh.layout.listener.OnRefreshListener;
import com.scwang.smart.refresh.layout.listener.OnRefreshLoadMoreListener;
import com.scwang.smart.refresh.layout.listener.ScrollBoundaryDecider;
import com.scwang.smart.refresh.layout.util.SmartUtil;
import com.scwang.smart.refresh.layout.wrapper.RefreshContentWrapper;
import com.scwang.smart.refresh.layout.wrapper.RefreshFooterWrapper;
import com.scwang.smart.refresh.layout.wrapper.RefreshHeaderWrapper;

@SuppressLint(value={"RestrictedApi"})
public class SmartRefreshLayout
extends ViewGroup
implements RefreshLayout,
NestedScrollingParent {
    protected int mTouchSlop;
    protected int mSpinner;
    protected int mLastSpinner;
    protected int mTouchSpinner;
    protected int mFloorDuration = 300;
    protected int mReboundDuration = 300;
    protected int mScreenHeightPixels;
    protected float mTouchX;
    protected float mTouchY;
    protected float mLastTouchX;
    protected float mLastTouchY;
    protected float mDragRate = 0.5f;
    protected char mDragDirection = (char)110;
    protected boolean mIsBeingDragged;
    protected boolean mSuperDispatchTouchEvent;
    protected boolean mEnableDisallowIntercept;
    protected int mFixedHeaderViewId = -1;
    protected int mFixedFooterViewId = -1;
    protected int mHeaderTranslationViewId = -1;
    protected int mFooterTranslationViewId = -1;
    protected int mMinimumVelocity;
    protected int mMaximumVelocity;
    protected int mCurrentVelocity;
    protected Scroller mScroller;
    protected VelocityTracker mVelocityTracker;
    protected Interpolator mReboundInterpolator;
    protected int[] mPrimaryColors;
    protected boolean mEnableRefresh = true;
    protected boolean mEnableLoadMore = false;
    protected boolean mEnableClipHeaderWhenFixedBehind = true;
    protected boolean mEnableClipFooterWhenFixedBehind = true;
    protected boolean mEnableHeaderTranslationContent = true;
    protected boolean mEnableFooterTranslationContent = true;
    protected boolean mEnableFooterFollowWhenNoMoreData = false;
    protected boolean mEnablePreviewInEditMode = true;
    protected boolean mEnableOverScrollBounce = true;
    protected boolean mEnableOverScrollDrag = false;
    protected boolean mEnableAutoLoadMore = true;
    protected boolean mEnablePureScrollMode = false;
    protected boolean mEnableScrollContentWhenLoaded = true;
    protected boolean mEnableScrollContentWhenRefreshed = true;
    protected boolean mEnableLoadMoreWhenContentNotFull = true;
    protected boolean mEnableNestedScrolling = true;
    protected boolean mDisableContentWhenRefresh = false;
    protected boolean mDisableContentWhenLoading = false;
    protected boolean mFooterNoMoreData = false;
    protected boolean mFooterNoMoreDataEffective = false;
    protected boolean mManualLoadMore = false;
    protected boolean mManualHeaderTranslationContent = false;
    protected boolean mManualFooterTranslationContent = false;
    protected OnRefreshListener mRefreshListener;
    protected OnLoadMoreListener mLoadMoreListener;
    protected OnMultiListener mOnMultiListener;
    protected ScrollBoundaryDecider mScrollBoundaryDecider;
    protected int mTotalUnconsumed;
    protected boolean mNestedInProgress;
    protected int[] mParentOffsetInWindow = new int[2];
    protected NestedScrollingChildHelper mNestedChild = new NestedScrollingChildHelper((View)this);
    protected NestedScrollingParentHelper mNestedParent = new NestedScrollingParentHelper((ViewGroup)this);
    protected int mHeaderHeight;
    protected DimensionStatus mHeaderHeightStatus = DimensionStatus.DefaultUnNotify;
    protected int mFooterHeight;
    protected DimensionStatus mFooterHeightStatus = DimensionStatus.DefaultUnNotify;
    protected int mHeaderInsetStart;
    protected int mFooterInsetStart;
    protected float mHeaderMaxDragRate = 2.5f;
    protected float mFooterMaxDragRate = 2.5f;
    protected float mHeaderTriggerRate = 1.0f;
    protected float mFooterTriggerRate = 1.0f;
    protected float mTwoLevelBottomPullUpToCloseRate = 0.16666667f;
    protected RefreshComponent mRefreshHeader;
    protected RefreshComponent mRefreshFooter;
    protected RefreshContent mRefreshContent;
    protected Paint mPaint;
    protected Handler mHandler;
    protected RefreshKernel mKernel = new RefreshKernelImpl();
    protected RefreshState mState = RefreshState.None;
    protected RefreshState mViceState = RefreshState.None;
    protected long mLastOpenTime = 0L;
    protected int mHeaderBackgroundColor = 0;
    protected int mFooterBackgroundColor = 0;
    protected boolean mHeaderNeedTouchEventWhenRefreshing;
    protected boolean mFooterNeedTouchEventWhenLoading;
    protected boolean mAttachedToWindow;
    protected boolean mFooterLocked = false;
    protected long mLastTimeOnActionDown = 0L;
    protected float mLastTouchXOnActionDown = 0.0f;
    protected float mLastTouchYOnActionDown = 0.0f;
    protected static DefaultRefreshFooterCreator sFooterCreator = null;
    protected static DefaultRefreshHeaderCreator sHeaderCreator = null;
    protected static DefaultRefreshInitializer sRefreshInitializer = null;
    protected static ViewGroup.MarginLayoutParams sDefaultMarginLP = new ViewGroup.MarginLayoutParams(-1, -1);
    protected boolean mVerticalPermit = false;
    protected MotionEvent mFalsifyEvent = null;
    protected Runnable animationRunnable;
    protected ValueAnimator reboundAnimator;

    public SmartRefreshLayout(Context context) {
        this(context, null);
    }

    public SmartRefreshLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        ViewConfiguration configuration = ViewConfiguration.get((Context)context);
        this.mHandler = new Handler(Looper.getMainLooper());
        this.mScroller = new Scroller(context);
        this.mVelocityTracker = VelocityTracker.obtain();
        this.mScreenHeightPixels = context.getResources().getDisplayMetrics().heightPixels;
        this.mReboundInterpolator = new SmartUtil(SmartUtil.INTERPOLATOR_VISCOUS_FLUID);
        this.mTouchSlop = configuration.getScaledTouchSlop();
        this.mMinimumVelocity = configuration.getScaledMinimumFlingVelocity();
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mFooterHeight = SmartUtil.dp2px(60.0f);
        this.mHeaderHeight = SmartUtil.dp2px(100.0f);
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SmartRefreshLayout);
        if (!ta.hasValue(R.styleable.SmartRefreshLayout_android_clipToPadding)) {
            super.setClipToPadding(false);
        }
        if (!ta.hasValue(R.styleable.SmartRefreshLayout_android_clipChildren)) {
            super.setClipChildren(false);
        }
        if (sRefreshInitializer != null) {
            sRefreshInitializer.initialize(context, this);
        }
        this.mDragRate = ta.getFloat(R.styleable.SmartRefreshLayout_srlDragRate, this.mDragRate);
        this.mHeaderMaxDragRate = ta.getFloat(R.styleable.SmartRefreshLayout_srlHeaderMaxDragRate, this.mHeaderMaxDragRate);
        this.mFooterMaxDragRate = ta.getFloat(R.styleable.SmartRefreshLayout_srlFooterMaxDragRate, this.mFooterMaxDragRate);
        this.mHeaderTriggerRate = ta.getFloat(R.styleable.SmartRefreshLayout_srlHeaderTriggerRate, this.mHeaderTriggerRate);
        this.mFooterTriggerRate = ta.getFloat(R.styleable.SmartRefreshLayout_srlFooterTriggerRate, this.mFooterTriggerRate);
        this.mEnableRefresh = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableRefresh, this.mEnableRefresh);
        this.mReboundDuration = ta.getInt(R.styleable.SmartRefreshLayout_srlReboundDuration, this.mReboundDuration);
        this.mEnableLoadMore = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableLoadMore, this.mEnableLoadMore);
        this.mHeaderHeight = ta.getDimensionPixelOffset(R.styleable.SmartRefreshLayout_srlHeaderHeight, this.mHeaderHeight);
        this.mFooterHeight = ta.getDimensionPixelOffset(R.styleable.SmartRefreshLayout_srlFooterHeight, this.mFooterHeight);
        this.mHeaderInsetStart = ta.getDimensionPixelOffset(R.styleable.SmartRefreshLayout_srlHeaderInsetStart, this.mHeaderInsetStart);
        this.mFooterInsetStart = ta.getDimensionPixelOffset(R.styleable.SmartRefreshLayout_srlFooterInsetStart, this.mFooterInsetStart);
        this.mDisableContentWhenRefresh = ta.getBoolean(R.styleable.SmartRefreshLayout_srlDisableContentWhenRefresh, this.mDisableContentWhenRefresh);
        this.mDisableContentWhenLoading = ta.getBoolean(R.styleable.SmartRefreshLayout_srlDisableContentWhenLoading, this.mDisableContentWhenLoading);
        this.mEnableHeaderTranslationContent = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableHeaderTranslationContent, this.mEnableHeaderTranslationContent);
        this.mEnableFooterTranslationContent = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableFooterTranslationContent, this.mEnableFooterTranslationContent);
        this.mEnablePreviewInEditMode = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnablePreviewInEditMode, this.mEnablePreviewInEditMode);
        this.mEnableAutoLoadMore = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableAutoLoadMore, this.mEnableAutoLoadMore);
        this.mEnableOverScrollBounce = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableOverScrollBounce, this.mEnableOverScrollBounce);
        this.mEnablePureScrollMode = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnablePureScrollMode, this.mEnablePureScrollMode);
        this.mEnableScrollContentWhenLoaded = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableScrollContentWhenLoaded, this.mEnableScrollContentWhenLoaded);
        this.mEnableScrollContentWhenRefreshed = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableScrollContentWhenRefreshed, this.mEnableScrollContentWhenRefreshed);
        this.mEnableLoadMoreWhenContentNotFull = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableLoadMoreWhenContentNotFull, this.mEnableLoadMoreWhenContentNotFull);
        this.mEnableFooterFollowWhenNoMoreData = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableFooterFollowWhenLoadFinished, this.mEnableFooterFollowWhenNoMoreData);
        this.mEnableFooterFollowWhenNoMoreData = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableFooterFollowWhenNoMoreData, this.mEnableFooterFollowWhenNoMoreData);
        this.mEnableClipHeaderWhenFixedBehind = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableClipHeaderWhenFixedBehind, this.mEnableClipHeaderWhenFixedBehind);
        this.mEnableClipFooterWhenFixedBehind = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableClipFooterWhenFixedBehind, this.mEnableClipFooterWhenFixedBehind);
        this.mEnableOverScrollDrag = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableOverScrollDrag, this.mEnableOverScrollDrag);
        this.mFixedHeaderViewId = ta.getResourceId(R.styleable.SmartRefreshLayout_srlFixedHeaderViewId, this.mFixedHeaderViewId);
        this.mFixedFooterViewId = ta.getResourceId(R.styleable.SmartRefreshLayout_srlFixedFooterViewId, this.mFixedFooterViewId);
        this.mHeaderTranslationViewId = ta.getResourceId(R.styleable.SmartRefreshLayout_srlHeaderTranslationViewId, this.mHeaderTranslationViewId);
        this.mFooterTranslationViewId = ta.getResourceId(R.styleable.SmartRefreshLayout_srlFooterTranslationViewId, this.mFooterTranslationViewId);
        this.mEnableNestedScrolling = ta.getBoolean(R.styleable.SmartRefreshLayout_srlEnableNestedScrolling, this.mEnableNestedScrolling);
        this.mNestedChild.setNestedScrollingEnabled(this.mEnableNestedScrolling);
        this.mManualLoadMore = this.mManualLoadMore || ta.hasValue(R.styleable.SmartRefreshLayout_srlEnableLoadMore);
        this.mManualHeaderTranslationContent = this.mManualHeaderTranslationContent || ta.hasValue(R.styleable.SmartRefreshLayout_srlEnableHeaderTranslationContent);
        this.mManualFooterTranslationContent = this.mManualFooterTranslationContent || ta.hasValue(R.styleable.SmartRefreshLayout_srlEnableFooterTranslationContent);
        this.mHeaderHeightStatus = ta.hasValue(R.styleable.SmartRefreshLayout_srlHeaderHeight) ? DimensionStatus.XmlLayoutUnNotify : this.mHeaderHeightStatus;
        this.mFooterHeightStatus = ta.hasValue(R.styleable.SmartRefreshLayout_srlFooterHeight) ? DimensionStatus.XmlLayoutUnNotify : this.mFooterHeightStatus;
        int accentColor = ta.getColor(R.styleable.SmartRefreshLayout_srlAccentColor, 0);
        int primaryColor = ta.getColor(R.styleable.SmartRefreshLayout_srlPrimaryColor, 0);
        if (primaryColor != 0) {
            this.mPrimaryColors = accentColor != 0 ? new int[]{primaryColor, accentColor} : new int[]{primaryColor};
        } else if (accentColor != 0) {
            this.mPrimaryColors = new int[]{0, accentColor};
        }
        if (this.mEnablePureScrollMode && !this.mManualLoadMore && !this.mEnableLoadMore) {
            this.mEnableLoadMore = true;
        }
        ta.recycle();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        int count = super.getChildCount();
        if (count > 3) {
            throw new RuntimeException("\u6700\u591a\u53ea\u652f\u63013\u4e2a\u5b50View\uff0cMost only support three sub view");
        }
        int contentLevel = 0;
        int indexContent = -1;
        for (int i = 0; i < count; ++i) {
            View view = super.getChildAt(i);
            if (SmartUtil.isContentView(view) && (contentLevel < 2 || i == 1)) {
                indexContent = i;
                contentLevel = 2;
                continue;
            }
            if (view instanceof RefreshComponent || contentLevel >= 1) continue;
            indexContent = i;
            contentLevel = i > 0 ? 1 : 0;
        }
        int indexHeader = -1;
        int indexFooter = -1;
        if (indexContent >= 0) {
            this.mRefreshContent = new RefreshContentWrapper(super.getChildAt(indexContent));
            if (indexContent == 1) {
                indexHeader = 0;
                if (count == 3) {
                    indexFooter = 2;
                }
            } else if (count == 2) {
                indexFooter = 1;
            }
        }
        for (int i = 0; i < count; ++i) {
            View view = super.getChildAt(i);
            if (i == indexHeader || i != indexFooter && indexHeader == -1 && this.mRefreshHeader == null && view instanceof RefreshHeader) {
                this.mRefreshHeader = view instanceof RefreshHeader ? (RefreshHeader)view : new RefreshHeaderWrapper(view);
                continue;
            }
            if (i != indexFooter && (indexFooter != -1 || !(view instanceof RefreshFooter))) continue;
            this.mEnableLoadMore = this.mEnableLoadMore || !this.mManualLoadMore;
            this.mRefreshFooter = view instanceof RefreshFooter ? (RefreshFooter)view : new RefreshFooterWrapper(view);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        SmartRefreshLayout thisView = this;
        if (!thisView.isInEditMode()) {
            if (this.mRefreshHeader == null && sHeaderCreator != null) {
                RefreshHeader header = sHeaderCreator.createRefreshHeader(thisView.getContext(), this);
                if (header == null) {
                    throw new RuntimeException("DefaultRefreshHeaderCreator can not return null");
                }
                this.setRefreshHeader(header);
            }
            if (this.mRefreshFooter == null) {
                if (sFooterCreator != null) {
                    RefreshFooter footer = sFooterCreator.createRefreshFooter(thisView.getContext(), this);
                    if (footer == null) {
                        throw new RuntimeException("DefaultRefreshFooterCreator can not return null");
                    }
                    this.setRefreshFooter(footer);
                }
            } else {
                boolean bl = this.mEnableLoadMore = this.mEnableLoadMore || !this.mManualLoadMore;
            }
            if (this.mRefreshContent == null) {
                int len = this.getChildCount();
                for (int i = 0; i < len; ++i) {
                    View view = this.getChildAt(i);
                    if (this.mRefreshHeader != null && view == this.mRefreshHeader.getView() || this.mRefreshFooter != null && view == this.mRefreshFooter.getView()) continue;
                    this.mRefreshContent = new RefreshContentWrapper(view);
                }
            }
            if (this.mRefreshContent == null) {
                int padding = SmartUtil.dp2px(20.0f);
                TextView errorView = new TextView(thisView.getContext());
                errorView.setTextColor(-39424);
                errorView.setGravity(17);
                errorView.setTextSize(20.0f);
                errorView.setText(R.string.srl_content_empty);
                super.addView((View)errorView, 0, (ViewGroup.LayoutParams)new LayoutParams(-1, -1));
                this.mRefreshContent = new RefreshContentWrapper((View)errorView);
                this.mRefreshContent.getView().setPadding(padding, padding, padding, padding);
            }
            View fixedHeaderView = thisView.findViewById(this.mFixedHeaderViewId);
            View fixedFooterView = thisView.findViewById(this.mFixedFooterViewId);
            this.mRefreshContent.setScrollBoundaryDecider(this.mScrollBoundaryDecider);
            this.mRefreshContent.setEnableLoadMoreWhenContentNotFull(this.mEnableLoadMoreWhenContentNotFull);
            this.mRefreshContent.setUpComponent(this.mKernel, fixedHeaderView, fixedFooterView);
            if (this.mSpinner != 0) {
                this.notifyStateChanged(RefreshState.None);
                this.mSpinner = 0;
                this.mRefreshContent.moveSpinner(0, this.mHeaderTranslationViewId, this.mFooterTranslationViewId);
            }
        }
        if (this.mPrimaryColors != null) {
            if (this.mRefreshHeader != null) {
                this.mRefreshHeader.setPrimaryColors(this.mPrimaryColors);
            }
            if (this.mRefreshFooter != null) {
                this.mRefreshFooter.setPrimaryColors(this.mPrimaryColors);
            }
        }
        if (this.mRefreshContent != null) {
            super.bringChildToFront(this.mRefreshContent.getView());
        }
        if (this.mRefreshHeader != null && this.mRefreshHeader.getSpinnerStyle().front) {
            super.bringChildToFront(this.mRefreshHeader.getView());
        }
        if (this.mRefreshFooter != null && this.mRefreshFooter.getSpinnerStyle().front) {
            super.bringChildToFront(this.mRefreshFooter.getView());
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int minimumWidth = 0;
        int minimumHeight = 0;
        SmartRefreshLayout thisView = this;
        boolean needPreview = thisView.isInEditMode() && this.mEnablePreviewInEditMode;
        int len = super.getChildCount();
        for (int i = 0; i < len; ++i) {
            int measuredHeight;
            int maxHeight;
            int height;
            int widthSpec;
            ViewGroup.MarginLayoutParams mlp;
            ViewGroup.LayoutParams lp;
            View child = super.getChildAt(i);
            if (child.getVisibility() == 8 || "GONE".equals(child.getTag(R.id.srl_tag))) continue;
            if (this.mRefreshHeader != null && this.mRefreshHeader.getView() == child) {
                View headerView = this.mRefreshHeader.getView();
                lp = headerView.getLayoutParams();
                mlp = lp instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)lp : sDefaultMarginLP;
                widthSpec = ViewGroup.getChildMeasureSpec((int)widthMeasureSpec, (int)(mlp.leftMargin + mlp.rightMargin), (int)lp.width);
                height = this.mHeaderHeight;
                if (this.mHeaderHeightStatus.ordinal < DimensionStatus.XmlLayoutUnNotify.ordinal) {
                    if (lp.height > 0) {
                        height = lp.height + mlp.bottomMargin + mlp.topMargin;
                        if (this.mHeaderHeightStatus.canReplaceWith(DimensionStatus.XmlExactUnNotify)) {
                            this.mHeaderHeight = lp.height + mlp.bottomMargin + mlp.topMargin;
                            this.mHeaderHeightStatus = DimensionStatus.XmlExactUnNotify;
                        }
                    } else if (!(lp.height != -2 || this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.MatchLayout && this.mHeaderHeightStatus.notified)) {
                        maxHeight = Math.max(View.MeasureSpec.getSize((int)heightMeasureSpec) - mlp.bottomMargin - mlp.topMargin, 0);
                        headerView.measure(widthSpec, View.MeasureSpec.makeMeasureSpec((int)maxHeight, (int)Integer.MIN_VALUE));
                        measuredHeight = headerView.getMeasuredHeight();
                        if (measuredHeight > 0) {
                            height = -1;
                            if (measuredHeight != maxHeight && this.mHeaderHeightStatus.canReplaceWith(DimensionStatus.XmlWrapUnNotify)) {
                                this.mHeaderHeight = measuredHeight + mlp.bottomMargin + mlp.topMargin;
                                this.mHeaderHeightStatus = DimensionStatus.XmlWrapUnNotify;
                            }
                        }
                    }
                }
                if (this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.MatchLayout) {
                    height = View.MeasureSpec.getSize((int)heightMeasureSpec);
                } else if (this.mRefreshHeader.getSpinnerStyle().scale && !needPreview) {
                    height = Math.max(0, this.isEnableRefreshOrLoadMore(this.mEnableRefresh) ? this.mSpinner : 0);
                }
                if (height != -1) {
                    headerView.measure(widthSpec, View.MeasureSpec.makeMeasureSpec((int)Math.max(height - mlp.bottomMargin - mlp.topMargin, 0), (int)0x40000000));
                }
                if (!this.mHeaderHeightStatus.notified) {
                    float maxDragHeight = this.mHeaderMaxDragRate < 10.0f ? (float)this.mHeaderHeight * this.mHeaderMaxDragRate : this.mHeaderMaxDragRate;
                    this.mHeaderHeightStatus = this.mHeaderHeightStatus.notified();
                    this.mRefreshHeader.onInitialized(this.mKernel, this.mHeaderHeight, (int)maxDragHeight);
                }
                if (needPreview && this.isEnableRefreshOrLoadMore(this.mEnableRefresh)) {
                    minimumWidth += headerView.getMeasuredWidth();
                    minimumHeight += headerView.getMeasuredHeight();
                }
            }
            if (this.mRefreshFooter != null && this.mRefreshFooter.getView() == child) {
                View footerView = this.mRefreshFooter.getView();
                lp = footerView.getLayoutParams();
                mlp = lp instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)lp : sDefaultMarginLP;
                widthSpec = ViewGroup.getChildMeasureSpec((int)widthMeasureSpec, (int)(mlp.leftMargin + mlp.rightMargin), (int)lp.width);
                height = this.mFooterHeight;
                if (this.mFooterHeightStatus.ordinal < DimensionStatus.XmlLayoutUnNotify.ordinal) {
                    if (lp.height > 0) {
                        height = lp.height + mlp.topMargin + mlp.bottomMargin;
                        if (this.mFooterHeightStatus.canReplaceWith(DimensionStatus.XmlExactUnNotify)) {
                            this.mFooterHeight = lp.height + mlp.topMargin + mlp.bottomMargin;
                            this.mFooterHeightStatus = DimensionStatus.XmlExactUnNotify;
                        }
                    } else if (!(lp.height != -2 || this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.MatchLayout && this.mFooterHeightStatus.notified)) {
                        maxHeight = Math.max(View.MeasureSpec.getSize((int)heightMeasureSpec) - mlp.bottomMargin - mlp.topMargin, 0);
                        footerView.measure(widthSpec, View.MeasureSpec.makeMeasureSpec((int)maxHeight, (int)Integer.MIN_VALUE));
                        measuredHeight = footerView.getMeasuredHeight();
                        if (measuredHeight > 0) {
                            height = -1;
                            if (measuredHeight != maxHeight && this.mFooterHeightStatus.canReplaceWith(DimensionStatus.XmlWrapUnNotify)) {
                                this.mFooterHeight = measuredHeight + mlp.topMargin + mlp.bottomMargin;
                                this.mFooterHeightStatus = DimensionStatus.XmlWrapUnNotify;
                            }
                        }
                    }
                }
                if (this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.MatchLayout) {
                    height = View.MeasureSpec.getSize((int)heightMeasureSpec);
                } else if (this.mRefreshFooter.getSpinnerStyle().scale && !needPreview) {
                    height = Math.max(0, this.isEnableRefreshOrLoadMore(this.mEnableLoadMore) ? -this.mSpinner : 0);
                }
                if (height != -1) {
                    footerView.measure(widthSpec, View.MeasureSpec.makeMeasureSpec((int)Math.max(height - mlp.bottomMargin - mlp.topMargin, 0), (int)0x40000000));
                }
                if (!this.mFooterHeightStatus.notified) {
                    float maxDragHeight = this.mFooterMaxDragRate < 10.0f ? (float)this.mFooterHeight * this.mFooterMaxDragRate : this.mFooterMaxDragRate;
                    this.mFooterHeightStatus = this.mFooterHeightStatus.notified();
                    this.mRefreshFooter.onInitialized(this.mKernel, this.mFooterHeight, (int)maxDragHeight);
                }
                if (needPreview && this.isEnableRefreshOrLoadMore(this.mEnableLoadMore)) {
                    minimumWidth += footerView.getMeasuredWidth();
                    minimumHeight += footerView.getMeasuredHeight();
                }
            }
            if (this.mRefreshContent == null || this.mRefreshContent.getView() != child) continue;
            View contentView = this.mRefreshContent.getView();
            lp = contentView.getLayoutParams();
            mlp = lp instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)lp : sDefaultMarginLP;
            boolean showHeader = this.mRefreshHeader != null && this.isEnableRefreshOrLoadMore(this.mEnableRefresh) && this.isEnableTranslationContent(this.mEnableHeaderTranslationContent, this.mRefreshHeader);
            boolean showFooter = this.mRefreshFooter != null && this.isEnableRefreshOrLoadMore(this.mEnableLoadMore) && this.isEnableTranslationContent(this.mEnableFooterTranslationContent, this.mRefreshFooter);
            int widthSpec2 = ViewGroup.getChildMeasureSpec((int)widthMeasureSpec, (int)(thisView.getPaddingLeft() + thisView.getPaddingRight() + mlp.leftMargin + mlp.rightMargin), (int)lp.width);
            int heightSpec = ViewGroup.getChildMeasureSpec((int)heightMeasureSpec, (int)(thisView.getPaddingTop() + thisView.getPaddingBottom() + mlp.topMargin + mlp.bottomMargin + (needPreview && showHeader ? this.mHeaderHeight : 0) + (needPreview && showFooter ? this.mFooterHeight : 0)), (int)lp.height);
            contentView.measure(widthSpec2, heightSpec);
            minimumWidth += contentView.getMeasuredWidth() + mlp.leftMargin + mlp.rightMargin;
            minimumHeight += contentView.getMeasuredHeight() + mlp.topMargin + mlp.bottomMargin;
        }
        super.setMeasuredDimension(View.resolveSize((int)Math.max(minimumWidth += thisView.getPaddingLeft() + thisView.getPaddingRight(), super.getSuggestedMinimumWidth()), (int)widthMeasureSpec), View.resolveSize((int)Math.max(minimumHeight += thisView.getPaddingTop() + thisView.getPaddingBottom(), super.getSuggestedMinimumHeight()), (int)heightMeasureSpec));
        this.mLastTouchX = (float)thisView.getMeasuredWidth() / 2.0f;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        SmartRefreshLayout thisView = this;
        int paddingLeft = thisView.getPaddingLeft();
        int paddingTop = thisView.getPaddingTop();
        int paddingBottom = thisView.getPaddingBottom();
        int len = super.getChildCount();
        for (int i = 0; i < len; ++i) {
            int bottom;
            int right;
            int top;
            int left;
            ViewGroup.MarginLayoutParams mlp;
            ViewGroup.LayoutParams lp;
            boolean isPreviewMode;
            View child = super.getChildAt(i);
            if (child.getVisibility() == 8 || "GONE".equals(child.getTag(R.id.srl_tag))) continue;
            if (this.mRefreshContent != null && this.mRefreshContent.getView() == child) {
                isPreviewMode = thisView.isInEditMode() && this.mEnablePreviewInEditMode && this.isEnableRefreshOrLoadMore(this.mEnableRefresh) && this.mRefreshHeader != null;
                View contentView = this.mRefreshContent.getView();
                lp = contentView.getLayoutParams();
                mlp = lp instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)lp : sDefaultMarginLP;
                left = paddingLeft + mlp.leftMargin;
                top = paddingTop + mlp.topMargin;
                right = left + contentView.getMeasuredWidth();
                bottom = top + contentView.getMeasuredHeight();
                if (isPreviewMode && this.isEnableTranslationContent(this.mEnableHeaderTranslationContent, this.mRefreshHeader)) {
                    top += this.mHeaderHeight;
                    bottom += this.mHeaderHeight;
                }
                contentView.layout(left, top, right, bottom);
            }
            if (this.mRefreshHeader != null && this.mRefreshHeader.getView() == child) {
                isPreviewMode = thisView.isInEditMode() && this.mEnablePreviewInEditMode && this.isEnableRefreshOrLoadMore(this.mEnableRefresh);
                View headerView = this.mRefreshHeader.getView();
                lp = headerView.getLayoutParams();
                mlp = lp instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)lp : sDefaultMarginLP;
                left = mlp.leftMargin;
                top = mlp.topMargin + this.mHeaderInsetStart;
                right = left + headerView.getMeasuredWidth();
                bottom = top + headerView.getMeasuredHeight();
                if (!isPreviewMode && this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Translate) {
                    top -= this.mHeaderHeight;
                    bottom -= this.mHeaderHeight;
                }
                headerView.layout(left, top, right, bottom);
            }
            if (this.mRefreshFooter == null || this.mRefreshFooter.getView() != child) continue;
            isPreviewMode = thisView.isInEditMode() && this.mEnablePreviewInEditMode && this.isEnableRefreshOrLoadMore(this.mEnableLoadMore);
            View footerView = this.mRefreshFooter.getView();
            lp = footerView.getLayoutParams();
            mlp = lp instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)lp : sDefaultMarginLP;
            SpinnerStyle style = this.mRefreshFooter.getSpinnerStyle();
            int left2 = mlp.leftMargin;
            int top2 = mlp.topMargin + thisView.getMeasuredHeight() - this.mFooterInsetStart;
            if (this.mFooterNoMoreData && this.mFooterNoMoreDataEffective && this.mEnableFooterFollowWhenNoMoreData && this.mRefreshContent != null && this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.Translate && this.isEnableRefreshOrLoadMore(this.mEnableLoadMore)) {
                View contentView = this.mRefreshContent.getView();
                ViewGroup.LayoutParams clp = contentView.getLayoutParams();
                int topMargin = clp instanceof ViewGroup.MarginLayoutParams ? ((ViewGroup.MarginLayoutParams)clp).topMargin : 0;
                top2 = paddingTop + paddingTop + topMargin + contentView.getMeasuredHeight();
            }
            if (style == SpinnerStyle.MatchLayout) {
                top2 = mlp.topMargin - this.mFooterInsetStart;
            } else if (isPreviewMode || style == SpinnerStyle.FixedFront || style == SpinnerStyle.FixedBehind) {
                top2 -= this.mFooterHeight;
            } else if (style.scale && this.mSpinner < 0) {
                top2 -= Math.max(this.isEnableRefreshOrLoadMore(this.mEnableLoadMore) ? -this.mSpinner : 0, 0);
            }
            int right2 = left2 + footerView.getMeasuredWidth();
            int bottom2 = top2 + footerView.getMeasuredHeight();
            footerView.layout(left2, top2, right2, bottom2);
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mAttachedToWindow = false;
        this.mManualLoadMore = true;
        this.animationRunnable = null;
        if (this.reboundAnimator != null) {
            ValueAnimator animator = this.reboundAnimator;
            animator.removeAllListeners();
            this.reboundAnimator.removeAllUpdateListeners();
            this.reboundAnimator.setDuration(0L);
            this.reboundAnimator.cancel();
            this.reboundAnimator = null;
        }
        if (this.mRefreshHeader != null && this.mState == RefreshState.Refreshing) {
            this.mRefreshHeader.onFinish(this, false);
        }
        if (this.mRefreshFooter != null && this.mState == RefreshState.Loading) {
            this.mRefreshFooter.onFinish(this, false);
        }
        if (this.mSpinner != 0) {
            this.mKernel.moveSpinner(0, true);
        }
        if (this.mState != RefreshState.None) {
            this.notifyStateChanged(RefreshState.None);
        }
        if (this.mHandler != null) {
            this.mHandler.removeCallbacksAndMessages(null);
        }
        this.mFooterLocked = false;
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        View contentView;
        SmartRefreshLayout thisView = this;
        View view = contentView = this.mRefreshContent != null ? this.mRefreshContent.getView() : null;
        if (this.mRefreshHeader != null && this.mRefreshHeader.getView() == child) {
            if (!this.isEnableRefreshOrLoadMore(this.mEnableRefresh) || !this.mEnablePreviewInEditMode && thisView.isInEditMode()) {
                return true;
            }
            if (contentView != null) {
                int bottom = Math.max(contentView.getTop() + contentView.getPaddingTop() + this.mSpinner, child.getTop());
                if (this.mHeaderBackgroundColor != 0 && this.mPaint != null) {
                    this.mPaint.setColor(this.mHeaderBackgroundColor);
                    if (this.mRefreshHeader.getSpinnerStyle().scale) {
                        bottom = child.getBottom();
                    } else if (this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Translate) {
                        bottom = child.getBottom() + this.mSpinner;
                    }
                    canvas.drawRect(0.0f, (float)child.getTop(), (float)thisView.getWidth(), (float)bottom, this.mPaint);
                }
                if (this.mEnableClipHeaderWhenFixedBehind && this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.FixedBehind || this.mRefreshHeader.getSpinnerStyle().scale) {
                    canvas.save();
                    canvas.clipRect(child.getLeft(), child.getTop(), child.getRight(), bottom);
                    boolean ret = super.drawChild(canvas, child, drawingTime);
                    canvas.restore();
                    return ret;
                }
            }
        }
        if (this.mRefreshFooter != null && this.mRefreshFooter.getView() == child) {
            if (!this.isEnableRefreshOrLoadMore(this.mEnableLoadMore) || !this.mEnablePreviewInEditMode && thisView.isInEditMode()) {
                return true;
            }
            if (contentView != null) {
                int top = Math.min(contentView.getBottom() - contentView.getPaddingBottom() + this.mSpinner, child.getBottom());
                if (this.mFooterBackgroundColor != 0 && this.mPaint != null) {
                    this.mPaint.setColor(this.mFooterBackgroundColor);
                    if (this.mRefreshFooter.getSpinnerStyle().scale) {
                        top = child.getTop();
                    } else if (this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.Translate) {
                        top = child.getTop() + this.mSpinner;
                    }
                    canvas.drawRect(0.0f, (float)top, (float)thisView.getWidth(), (float)child.getBottom(), this.mPaint);
                }
                if (this.mEnableClipFooterWhenFixedBehind && this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.FixedBehind || this.mRefreshFooter.getSpinnerStyle().scale) {
                    canvas.save();
                    canvas.clipRect(child.getLeft(), top, child.getRight(), child.getBottom());
                    boolean ret = super.drawChild(canvas, child, drawingTime);
                    canvas.restore();
                    return ret;
                }
            }
        }
        return super.drawChild(canvas, child, drawingTime);
    }

    public void computeScroll() {
        int lastCurY = this.mScroller.getCurrY();
        if (this.mScroller.computeScrollOffset()) {
            int finalY = this.mScroller.getFinalY();
            if (finalY < 0 && (this.mEnableRefresh || this.mEnableOverScrollDrag) && this.mRefreshContent.canRefresh() || finalY > 0 && (this.mEnableLoadMore || this.mEnableOverScrollDrag) && this.mRefreshContent.canLoadMore()) {
                if (this.mVerticalPermit) {
                    float velocity = finalY > 0 ? -this.mScroller.getCurrVelocity() : this.mScroller.getCurrVelocity();
                    this.animSpinnerBounce(velocity);
                }
                this.mScroller.forceFinished(true);
            } else {
                this.mVerticalPermit = true;
                SmartRefreshLayout thisView = this;
                thisView.invalidate();
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent e) {
        int action = e.getActionMasked();
        boolean pointerUp = action == 6;
        int skipIndex = pointerUp ? e.getActionIndex() : -1;
        float sumX = 0.0f;
        float sumY = 0.0f;
        int count = e.getPointerCount();
        for (int i = 0; i < count; ++i) {
            if (skipIndex == i) continue;
            sumX += e.getX(i);
            sumY += e.getY(i);
        }
        int div = pointerUp ? count - 1 : count;
        float touchX = sumX / (float)div;
        float touchY = sumY / (float)div;
        if ((action == 6 || action == 5) && this.mIsBeingDragged) {
            this.mTouchY += touchY - this.mLastTouchY;
        }
        this.mLastTouchX = touchX;
        this.mLastTouchY = touchY;
        if (action == 0) {
            this.mLastTouchXOnActionDown = touchX;
            this.mLastTouchYOnActionDown = touchY;
            this.mLastTimeOnActionDown = System.currentTimeMillis();
        }
        SmartRefreshLayout thisView = this;
        if (this.mNestedInProgress) {
            int totalUnconsumed = this.mTotalUnconsumed;
            boolean ret = super.dispatchTouchEvent(e);
            if (action == 2 && totalUnconsumed == this.mTotalUnconsumed) {
                int offsetX = (int)this.mLastTouchX;
                int offsetMax = thisView.getWidth();
                float percentX = this.mLastTouchX / (float)(offsetMax == 0 ? 1 : offsetMax);
                if (this.isEnableRefreshOrLoadMore(this.mEnableRefresh) && this.mSpinner > 0 && this.mRefreshHeader != null && this.mRefreshHeader.isSupportHorizontalDrag()) {
                    this.mRefreshHeader.onHorizontalDrag(percentX, offsetX, offsetMax);
                } else if (this.isEnableRefreshOrLoadMore(this.mEnableLoadMore) && this.mSpinner < 0 && this.mRefreshFooter != null && this.mRefreshFooter.isSupportHorizontalDrag()) {
                    this.mRefreshFooter.onHorizontalDrag(percentX, offsetX, offsetMax);
                }
            }
            return ret;
        }
        if (!thisView.isEnabled() || !this.mEnableRefresh && !this.mEnableLoadMore && !this.mEnableOverScrollDrag || this.mHeaderNeedTouchEventWhenRefreshing && (this.mState.isOpening || this.mState.isFinishing) && this.mState.isHeader || this.mFooterNeedTouchEventWhenLoading && (this.mState.isOpening || this.mState.isFinishing) && this.mState.isFooter) {
            return super.dispatchTouchEvent(e);
        }
        if (this.mState.isFinishing) {
            if (action == 1 && System.currentTimeMillis() - this.mLastTimeOnActionDown < 500L) {
                float dx = touchX - this.mLastTouchXOnActionDown;
                float dy = touchY - this.mLastTouchYOnActionDown;
                if (Math.abs(dx) < (float)this.mTouchSlop && Math.abs(dy) < (float)this.mTouchSlop) {
                    e.setAction(0);
                    super.dispatchTouchEvent(e);
                    e.setAction(1);
                    return super.dispatchTouchEvent(e);
                }
            }
            return true;
        }
        if (this.interceptAnimatorByAction(action) || this.mState == RefreshState.Loading && this.mDisableContentWhenLoading || this.mState == RefreshState.Refreshing && this.mDisableContentWhenRefresh) {
            return false;
        }
        switch (action) {
            case 0: {
                this.mCurrentVelocity = 0;
                this.mVelocityTracker.addMovement(e);
                this.mScroller.forceFinished(true);
                this.mTouchX = touchX;
                this.mTouchY = touchY;
                this.mLastSpinner = 0;
                this.mTouchSpinner = this.mSpinner;
                this.mIsBeingDragged = false;
                this.mEnableDisallowIntercept = false;
                this.mSuperDispatchTouchEvent = super.dispatchTouchEvent(e);
                if (this.mState == RefreshState.TwoLevel && this.mTouchY < (float)thisView.getMeasuredHeight() * (1.0f - this.mTwoLevelBottomPullUpToCloseRate)) {
                    this.mDragDirection = (char)104;
                    return this.mSuperDispatchTouchEvent;
                }
                if (this.mRefreshContent != null) {
                    this.mRefreshContent.onActionDown(e);
                }
                return true;
            }
            case 2: {
                float dx = touchX - this.mTouchX;
                float dy = touchY - this.mTouchY;
                this.mVelocityTracker.addMovement(e);
                if (!this.mIsBeingDragged && !this.mEnableDisallowIntercept && this.mDragDirection != 'h' && this.mRefreshContent != null) {
                    if (this.mDragDirection == 'v' || Math.abs(dy) >= (float)this.mTouchSlop && Math.abs(dx) < Math.abs(dy)) {
                        this.mDragDirection = (char)118;
                        if (dy > 0.0f && (this.mSpinner < 0 || (this.mEnableOverScrollDrag || this.mEnableRefresh) && this.mRefreshContent.canRefresh())) {
                            this.mIsBeingDragged = true;
                            this.mTouchY = touchY - (float)this.mTouchSlop;
                        } else if (dy < 0.0f && (this.mSpinner > 0 || (this.mEnableOverScrollDrag || this.mEnableLoadMore) && (this.mState == RefreshState.Loading && this.mFooterLocked || this.mRefreshContent.canLoadMore()))) {
                            this.mIsBeingDragged = true;
                            this.mTouchY = touchY + (float)this.mTouchSlop;
                        }
                        if (this.mIsBeingDragged) {
                            dy = touchY - this.mTouchY;
                            if (this.mSuperDispatchTouchEvent) {
                                e.setAction(3);
                                super.dispatchTouchEvent(e);
                            }
                            this.mKernel.setState(this.mSpinner > 0 || this.mSpinner == 0 && dy > 0.0f ? RefreshState.PullDownToRefresh : RefreshState.PullUpToLoad);
                            ViewParent parent = thisView.getParent();
                            if (parent instanceof ViewGroup) {
                                ((ViewGroup)parent).requestDisallowInterceptTouchEvent(true);
                            }
                        }
                    } else if (Math.abs(dx) >= (float)this.mTouchSlop && Math.abs(dx) > Math.abs(dy) && this.mDragDirection != 'v') {
                        this.mDragDirection = (char)104;
                    }
                }
                if (this.mIsBeingDragged) {
                    int spinner = (int)dy + this.mTouchSpinner;
                    if (this.mViceState.isHeader && (spinner < 0 || this.mLastSpinner < 0) || this.mViceState.isFooter && (spinner > 0 || this.mLastSpinner > 0)) {
                        this.mLastSpinner = spinner;
                        long time = e.getEventTime();
                        if (this.mFalsifyEvent == null) {
                            this.mFalsifyEvent = MotionEvent.obtain((long)time, (long)time, (int)0, (float)(this.mTouchX + dx), (float)this.mTouchY, (int)0);
                            super.dispatchTouchEvent(this.mFalsifyEvent);
                        }
                        MotionEvent em = MotionEvent.obtain((long)time, (long)time, (int)2, (float)(this.mTouchX + dx), (float)(this.mTouchY + (float)spinner), (int)0);
                        super.dispatchTouchEvent(em);
                        if (this.mFooterLocked && dy > (float)this.mTouchSlop && this.mSpinner < 0) {
                            this.mFooterLocked = false;
                        }
                        if (spinner > 0 && (this.mEnableOverScrollDrag || this.mEnableRefresh) && this.mRefreshContent.canRefresh()) {
                            this.mTouchY = this.mLastTouchY = touchY;
                            spinner = 0;
                            this.mTouchSpinner = 0;
                            this.mKernel.setState(RefreshState.PullDownToRefresh);
                        } else if (spinner < 0 && (this.mEnableOverScrollDrag || this.mEnableLoadMore) && this.mRefreshContent.canLoadMore()) {
                            this.mTouchY = this.mLastTouchY = touchY;
                            spinner = 0;
                            this.mTouchSpinner = 0;
                            this.mKernel.setState(RefreshState.PullUpToLoad);
                        }
                        if (this.mViceState.isHeader && spinner < 0 || this.mViceState.isFooter && spinner > 0) {
                            if (this.mSpinner != 0) {
                                this.moveSpinnerInfinitely(0.0f);
                            }
                            return true;
                        }
                        if (this.mFalsifyEvent != null) {
                            this.mFalsifyEvent = null;
                            em.setAction(3);
                            super.dispatchTouchEvent(em);
                        }
                        em.recycle();
                    }
                    this.moveSpinnerInfinitely(spinner);
                    return true;
                }
                if (!this.mFooterLocked || !(dy > (float)this.mTouchSlop) || this.mSpinner >= 0) break;
                this.mFooterLocked = false;
                break;
            }
            case 1: {
                this.mVelocityTracker.addMovement(e);
                this.mVelocityTracker.computeCurrentVelocity(1000, (float)this.mMaximumVelocity);
                this.mCurrentVelocity = (int)this.mVelocityTracker.getYVelocity();
                this.startFlingIfNeed(0.0f);
            }
            case 3: {
                this.mVelocityTracker.clear();
                this.mDragDirection = (char)110;
                if (this.mFalsifyEvent != null) {
                    this.mFalsifyEvent.recycle();
                    this.mFalsifyEvent = null;
                    long time = e.getEventTime();
                    MotionEvent ec = MotionEvent.obtain((long)time, (long)time, (int)action, (float)this.mTouchX, (float)touchY, (int)0);
                    super.dispatchTouchEvent(ec);
                    ec.recycle();
                }
                this.overSpinner();
                if (!this.mIsBeingDragged) break;
                this.mIsBeingDragged = false;
                return true;
            }
        }
        return super.dispatchTouchEvent(e);
    }

    public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        View target = this.mRefreshContent.getScrollableView();
        if ((Build.VERSION.SDK_INT >= 21 || !(target instanceof AbsListView)) && ViewCompat.isNestedScrollingEnabled((View)target)) {
            this.mEnableDisallowIntercept = disallowIntercept;
            super.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    protected boolean startFlingIfNeed(float flingVelocity) {
        float velocity;
        float f = velocity = flingVelocity == 0.0f ? (float)this.mCurrentVelocity : flingVelocity;
        if (Math.abs(velocity) > (float)this.mMinimumVelocity) {
            if (velocity * (float)this.mSpinner < 0.0f) {
                if (this.mState == RefreshState.Refreshing || this.mState == RefreshState.Loading || this.mSpinner < 0 && this.mFooterNoMoreData) {
                    this.animationRunnable = new FlingRunnable(velocity).start();
                    return true;
                }
                if (this.mState.isReleaseToOpening) {
                    return true;
                }
            }
            if (velocity < 0.0f && (this.mEnableOverScrollBounce && (this.mEnableLoadMore || this.mEnableOverScrollDrag) || this.mState == RefreshState.Loading && this.mSpinner >= 0 || this.mEnableAutoLoadMore && this.isEnableRefreshOrLoadMore(this.mEnableLoadMore)) || velocity > 0.0f && (this.mEnableOverScrollBounce && this.mEnableRefresh || this.mEnableOverScrollDrag || this.mState == RefreshState.Refreshing && this.mSpinner <= 0)) {
                this.mVerticalPermit = false;
                this.mScroller.fling(0, 0, 0, (int)(-velocity), 0, 0, -2147483647, Integer.MAX_VALUE);
                this.mScroller.computeScrollOffset();
                SmartRefreshLayout thisView = this;
                thisView.invalidate();
            }
        }
        return false;
    }

    protected boolean interceptAnimatorByAction(int action) {
        if (action == 0) {
            if (this.reboundAnimator != null) {
                if (this.mState.isFinishing || this.mState == RefreshState.TwoLevelReleased || this.mState == RefreshState.RefreshReleased || this.mState == RefreshState.LoadReleased) {
                    return true;
                }
                if (this.mState == RefreshState.PullDownCanceled) {
                    this.mKernel.setState(RefreshState.PullDownToRefresh);
                } else if (this.mState == RefreshState.PullUpCanceled) {
                    this.mKernel.setState(RefreshState.PullUpToLoad);
                }
                this.reboundAnimator.setDuration(0L);
                this.reboundAnimator.cancel();
                this.reboundAnimator = null;
            }
            this.animationRunnable = null;
        }
        return this.reboundAnimator != null;
    }

    protected void notifyStateChanged(RefreshState state) {
        RefreshState oldState = this.mState;
        if (oldState != state) {
            this.mState = state;
            this.mViceState = state;
            RefreshComponent refreshHeader = this.mRefreshHeader;
            RefreshComponent refreshFooter = this.mRefreshFooter;
            OnMultiListener refreshListener = this.mOnMultiListener;
            if (refreshHeader != null) {
                refreshHeader.onStateChanged(this, oldState, state);
            }
            if (refreshFooter != null) {
                refreshFooter.onStateChanged(this, oldState, state);
            }
            if (refreshListener != null) {
                refreshListener.onStateChanged(this, oldState, state);
            }
            if (state == RefreshState.LoadFinish) {
                this.mFooterLocked = false;
            }
        } else if (this.mViceState != this.mState) {
            this.mViceState = this.mState;
        }
    }

    protected void setStateDirectLoading(boolean triggerLoadMoreEvent) {
        if (this.mState != RefreshState.Loading) {
            this.mLastOpenTime = System.currentTimeMillis();
            this.mFooterLocked = true;
            this.notifyStateChanged(RefreshState.Loading);
            if (this.mLoadMoreListener != null) {
                if (triggerLoadMoreEvent) {
                    this.mLoadMoreListener.onLoadMore(this);
                }
            } else if (this.mOnMultiListener == null) {
                this.finishLoadMore(2000);
            }
            if (this.mRefreshFooter != null) {
                float maxDragHeight = this.mFooterMaxDragRate < 10.0f ? (float)this.mFooterHeight * this.mFooterMaxDragRate : this.mFooterMaxDragRate;
                this.mRefreshFooter.onStartAnimator(this, this.mFooterHeight, (int)maxDragHeight);
            }
            if (this.mOnMultiListener != null && this.mRefreshFooter instanceof RefreshFooter) {
                OnMultiListener listener = this.mOnMultiListener;
                if (triggerLoadMoreEvent) {
                    listener.onLoadMore(this);
                }
                float maxDragHeight = this.mFooterMaxDragRate < 10.0f ? (float)this.mFooterHeight * this.mFooterMaxDragRate : this.mFooterMaxDragRate;
                this.mOnMultiListener.onFooterStartAnimator((RefreshFooter)this.mRefreshFooter, this.mFooterHeight, (int)maxDragHeight);
            }
        }
    }

    protected void setStateLoading(final boolean notify) {
        float maxDragHeight;
        AnimatorListenerAdapter listener = new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                if (animation != null && animation.getDuration() == 0L) {
                    return;
                }
                SmartRefreshLayout.this.setStateDirectLoading(notify);
            }
        };
        this.notifyStateChanged(RefreshState.LoadReleased);
        ValueAnimator animator = this.mKernel.animSpinner(-this.mFooterHeight);
        if (animator != null) {
            animator.addListener((Animator.AnimatorListener)listener);
        }
        if (this.mRefreshFooter != null) {
            maxDragHeight = this.mFooterMaxDragRate < 10.0f ? (float)this.mFooterHeight * this.mFooterMaxDragRate : this.mFooterMaxDragRate;
            this.mRefreshFooter.onReleased(this, this.mFooterHeight, (int)maxDragHeight);
        }
        if (this.mOnMultiListener != null && this.mRefreshFooter instanceof RefreshFooter) {
            maxDragHeight = this.mFooterMaxDragRate < 10.0f ? (float)this.mFooterHeight * this.mFooterMaxDragRate : this.mFooterMaxDragRate;
            this.mOnMultiListener.onFooterReleased((RefreshFooter)this.mRefreshFooter, this.mFooterHeight, (int)maxDragHeight);
        }
        if (animator == null) {
            listener.onAnimationEnd(null);
        }
    }

    protected void setStateRefreshing(final boolean notify) {
        int maxDragHeight;
        AnimatorListenerAdapter listener = new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                int maxDragHeight;
                if (animation != null && animation.getDuration() == 0L) {
                    return;
                }
                SmartRefreshLayout.this.mLastOpenTime = System.currentTimeMillis();
                SmartRefreshLayout.this.notifyStateChanged(RefreshState.Refreshing);
                if (SmartRefreshLayout.this.mRefreshListener != null) {
                    if (notify) {
                        SmartRefreshLayout.this.mRefreshListener.onRefresh(SmartRefreshLayout.this);
                    }
                } else if (SmartRefreshLayout.this.mOnMultiListener == null) {
                    SmartRefreshLayout.this.finishRefresh(3000);
                }
                if (SmartRefreshLayout.this.mRefreshHeader != null) {
                    maxDragHeight = (int)(SmartRefreshLayout.this.mHeaderMaxDragRate < 10.0f ? (float)SmartRefreshLayout.this.mHeaderHeight * SmartRefreshLayout.this.mHeaderMaxDragRate : SmartRefreshLayout.this.mHeaderMaxDragRate);
                    SmartRefreshLayout.this.mRefreshHeader.onStartAnimator(SmartRefreshLayout.this, SmartRefreshLayout.this.mHeaderHeight, maxDragHeight);
                }
                if (SmartRefreshLayout.this.mOnMultiListener != null && SmartRefreshLayout.this.mRefreshHeader instanceof RefreshHeader) {
                    if (notify) {
                        SmartRefreshLayout.this.mOnMultiListener.onRefresh(SmartRefreshLayout.this);
                    }
                    maxDragHeight = (int)(SmartRefreshLayout.this.mHeaderMaxDragRate < 10.0f ? (float)SmartRefreshLayout.this.mHeaderHeight * SmartRefreshLayout.this.mHeaderMaxDragRate : SmartRefreshLayout.this.mHeaderMaxDragRate);
                    SmartRefreshLayout.this.mOnMultiListener.onHeaderStartAnimator((RefreshHeader)SmartRefreshLayout.this.mRefreshHeader, SmartRefreshLayout.this.mHeaderHeight, maxDragHeight);
                }
            }
        };
        this.notifyStateChanged(RefreshState.RefreshReleased);
        ValueAnimator animator = this.mKernel.animSpinner(this.mHeaderHeight);
        if (animator != null) {
            animator.addListener((Animator.AnimatorListener)listener);
        }
        if (this.mRefreshHeader != null) {
            maxDragHeight = (int)(this.mHeaderMaxDragRate < 10.0f ? (float)this.mHeaderHeight * this.mHeaderMaxDragRate : this.mHeaderMaxDragRate);
            this.mRefreshHeader.onReleased(this, this.mHeaderHeight, maxDragHeight);
        }
        if (this.mOnMultiListener != null && this.mRefreshHeader instanceof RefreshHeader) {
            maxDragHeight = (int)(this.mHeaderMaxDragRate < 10.0f ? (float)this.mHeaderHeight * this.mHeaderMaxDragRate : this.mHeaderMaxDragRate);
            this.mOnMultiListener.onHeaderReleased((RefreshHeader)this.mRefreshHeader, this.mHeaderHeight, maxDragHeight);
        }
        if (animator == null) {
            listener.onAnimationEnd(null);
        }
    }

    protected void setViceState(RefreshState state) {
        if (this.mState.isDragging && this.mState.isHeader != state.isHeader) {
            this.notifyStateChanged(RefreshState.None);
        }
        if (this.mViceState != state) {
            this.mViceState = state;
        }
    }

    protected boolean isEnableTranslationContent(boolean enable, @Nullable RefreshComponent internal) {
        return enable || this.mEnablePureScrollMode || internal == null || internal.getSpinnerStyle() == SpinnerStyle.FixedBehind;
    }

    protected boolean isEnableRefreshOrLoadMore(boolean enable) {
        return enable && !this.mEnablePureScrollMode;
    }

    protected ValueAnimator animSpinner(int endSpinner, int startDelay, Interpolator interpolator, int duration) {
        if (this.mSpinner != endSpinner) {
            if (this.reboundAnimator != null) {
                this.reboundAnimator.setDuration(0L);
                this.reboundAnimator.cancel();
                this.reboundAnimator = null;
            }
            this.animationRunnable = null;
            this.reboundAnimator = ValueAnimator.ofInt((int[])new int[]{this.mSpinner, endSpinner});
            this.reboundAnimator.setDuration((long)duration);
            this.reboundAnimator.setInterpolator((TimeInterpolator)interpolator);
            this.reboundAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    if (animation != null && animation.getDuration() == 0L) {
                        return;
                    }
                    SmartRefreshLayout.this.reboundAnimator = null;
                    if (SmartRefreshLayout.this.mSpinner == 0 && SmartRefreshLayout.this.mState != RefreshState.None && !SmartRefreshLayout.this.mState.isOpening && !SmartRefreshLayout.this.mState.isDragging) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.None);
                    } else if (SmartRefreshLayout.this.mState != SmartRefreshLayout.this.mViceState) {
                        SmartRefreshLayout.this.setViceState(SmartRefreshLayout.this.mState);
                    }
                }
            });
            this.reboundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(ValueAnimator animation) {
                    SmartRefreshLayout.this.mKernel.moveSpinner((Integer)animation.getAnimatedValue(), false);
                }
            });
            this.reboundAnimator.setStartDelay((long)startDelay);
            this.reboundAnimator.start();
            return this.reboundAnimator;
        }
        return null;
    }

    protected void animSpinnerBounce(float velocity) {
        if (this.reboundAnimator == null) {
            if (velocity > 0.0f && (this.mState == RefreshState.Refreshing || this.mState == RefreshState.TwoLevel)) {
                this.animationRunnable = new BounceRunnable(velocity, this.mHeaderHeight);
            } else if (velocity < 0.0f && (this.mState == RefreshState.Loading || this.mEnableFooterFollowWhenNoMoreData && this.mFooterNoMoreData && this.mFooterNoMoreDataEffective && this.isEnableRefreshOrLoadMore(this.mEnableLoadMore) || this.mEnableAutoLoadMore && !this.mFooterNoMoreData && this.isEnableRefreshOrLoadMore(this.mEnableLoadMore) && this.mState != RefreshState.Refreshing)) {
                this.animationRunnable = new BounceRunnable(velocity, -this.mFooterHeight);
            } else if (this.mSpinner == 0 && this.mEnableOverScrollBounce) {
                this.animationRunnable = new BounceRunnable(velocity, 0);
            }
        }
    }

    protected void overSpinner() {
        if (this.mState == RefreshState.TwoLevel) {
            SmartRefreshLayout thisView = this;
            if (this.mCurrentVelocity > -1000 && this.mSpinner > thisView.getHeight() / 2) {
                ValueAnimator animator = this.mKernel.animSpinner(thisView.getHeight());
                if (animator != null) {
                    animator.setDuration((long)this.mFloorDuration);
                }
            } else if (this.mIsBeingDragged) {
                this.mKernel.finishTwoLevel();
            }
        } else if (this.mState == RefreshState.Loading || this.mEnableFooterFollowWhenNoMoreData && this.mFooterNoMoreData && this.mFooterNoMoreDataEffective && this.mSpinner < 0 && this.isEnableRefreshOrLoadMore(this.mEnableLoadMore)) {
            if (this.mSpinner < -this.mFooterHeight) {
                this.mKernel.animSpinner(-this.mFooterHeight);
            } else if (this.mSpinner > 0) {
                this.mKernel.animSpinner(0);
            }
        } else if (this.mState == RefreshState.Refreshing) {
            if (this.mSpinner > this.mHeaderHeight) {
                this.mKernel.animSpinner(this.mHeaderHeight);
            } else if (this.mSpinner < 0) {
                this.mKernel.animSpinner(0);
            }
        } else if (this.mState == RefreshState.PullDownToRefresh) {
            this.mKernel.setState(RefreshState.PullDownCanceled);
        } else if (this.mState == RefreshState.PullUpToLoad) {
            this.mKernel.setState(RefreshState.PullUpCanceled);
        } else if (this.mState == RefreshState.ReleaseToRefresh) {
            this.mKernel.setState(RefreshState.Refreshing);
        } else if (this.mState == RefreshState.ReleaseToLoad) {
            this.mKernel.setState(RefreshState.Loading);
        } else if (this.mState == RefreshState.ReleaseToTwoLevel) {
            this.mKernel.setState(RefreshState.TwoLevelReleased);
        } else if (this.mState == RefreshState.RefreshReleased) {
            if (this.reboundAnimator == null) {
                this.mKernel.animSpinner(this.mHeaderHeight);
            }
        } else if (this.mState == RefreshState.LoadReleased) {
            if (this.reboundAnimator == null) {
                this.mKernel.animSpinner(-this.mFooterHeight);
            }
        } else if (this.mState != RefreshState.LoadFinish && this.mSpinner != 0) {
            this.mKernel.animSpinner(0);
        }
    }

    protected void moveSpinnerInfinitely(float spinner) {
        SmartRefreshLayout thisView = this;
        if (this.mNestedInProgress && !this.mEnableLoadMoreWhenContentNotFull && spinner < 0.0f && !this.mRefreshContent.canLoadMore()) {
            spinner = 0.0f;
        }
        if (spinner > (float)(this.mScreenHeightPixels * 5) && thisView.getTag() == null && thisView.getTag(R.id.srl_tag) == null && this.mLastTouchY < (float)this.mScreenHeightPixels / 6.0f && this.mLastTouchX < (float)this.mScreenHeightPixels / 16.0f) {
            String egg = "\u4e0d\u8981\u518d\u62c9\u4e86\uff0c\u81e3\u59be\u505a\u4e0d\u5230\u554a\uff01";
            Toast.makeText((Context)thisView.getContext(), (CharSequence)egg, (int)0).show();
            thisView.setTag(R.id.srl_tag, egg);
        }
        if (this.mState == RefreshState.TwoLevel && spinner > 0.0f) {
            this.mKernel.moveSpinner(Math.min((int)spinner, thisView.getMeasuredHeight()), true);
        } else if (this.mState == RefreshState.Refreshing && spinner >= 0.0f) {
            if (spinner < (float)this.mHeaderHeight) {
                this.mKernel.moveSpinner((int)spinner, true);
            } else {
                float maxDragHeight = this.mHeaderMaxDragRate < 10.0f ? (float)this.mHeaderHeight * this.mHeaderMaxDragRate : this.mHeaderMaxDragRate;
                double M = maxDragHeight - (float)this.mHeaderHeight;
                double H = Math.max(this.mScreenHeightPixels * 4 / 3, thisView.getHeight()) - this.mHeaderHeight;
                double x = Math.max(0.0f, (spinner - (float)this.mHeaderHeight) * this.mDragRate);
                double y = Math.min(M * (1.0 - Math.pow(100.0, -x / (H == 0.0 ? 1.0 : H))), x);
                this.mKernel.moveSpinner((int)y + this.mHeaderHeight, true);
            }
        } else if (spinner < 0.0f && (this.mState == RefreshState.Loading || this.mEnableFooterFollowWhenNoMoreData && this.mFooterNoMoreData && this.mFooterNoMoreDataEffective && this.isEnableRefreshOrLoadMore(this.mEnableLoadMore) || this.mEnableAutoLoadMore && !this.mFooterNoMoreData && this.isEnableRefreshOrLoadMore(this.mEnableLoadMore))) {
            if (spinner > (float)(-this.mFooterHeight)) {
                this.mKernel.moveSpinner((int)spinner, true);
            } else {
                float maxDragHeight = this.mFooterMaxDragRate < 10.0f ? (float)this.mFooterHeight * this.mFooterMaxDragRate : this.mFooterMaxDragRate;
                double M = maxDragHeight - (float)this.mFooterHeight;
                double H = Math.max(this.mScreenHeightPixels * 4 / 3, thisView.getHeight()) - this.mFooterHeight;
                double x = -Math.min(0.0f, (spinner + (float)this.mFooterHeight) * this.mDragRate);
                double y = -Math.min(M * (1.0 - Math.pow(100.0, -x / (H == 0.0 ? 1.0 : H))), x);
                this.mKernel.moveSpinner((int)y - this.mFooterHeight, true);
            }
        } else if (spinner >= 0.0f) {
            double M = this.mHeaderMaxDragRate < 10.0f ? (double)((float)this.mHeaderHeight * this.mHeaderMaxDragRate) : (double)this.mHeaderMaxDragRate;
            double H = Math.max(this.mScreenHeightPixels / 2, thisView.getHeight());
            double x = Math.max(0.0f, spinner * this.mDragRate);
            double y = Math.min(M * (1.0 - Math.pow(100.0, -x / (H == 0.0 ? 1.0 : H))), x);
            this.mKernel.moveSpinner((int)y, true);
        } else {
            double M = this.mFooterMaxDragRate < 10.0f ? (double)((float)this.mFooterHeight * this.mFooterMaxDragRate) : (double)this.mFooterMaxDragRate;
            double H = Math.max(this.mScreenHeightPixels / 2, thisView.getHeight());
            double x = -Math.min(0.0f, spinner * this.mDragRate);
            double y = -Math.min(M * (1.0 - Math.pow(100.0, -x / (H == 0.0 ? 1.0 : H))), x);
            this.mKernel.moveSpinner((int)y, true);
        }
        if (this.mEnableAutoLoadMore && !this.mFooterNoMoreData && this.isEnableRefreshOrLoadMore(this.mEnableLoadMore) && spinner < 0.0f && this.mState != RefreshState.Refreshing && this.mState != RefreshState.Loading && this.mState != RefreshState.LoadFinish) {
            if (this.mDisableContentWhenLoading) {
                this.animationRunnable = null;
                this.mKernel.animSpinner(-this.mFooterHeight);
            }
            this.setStateDirectLoading(false);
            this.mHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    if (SmartRefreshLayout.this.mLoadMoreListener != null) {
                        SmartRefreshLayout.this.mLoadMoreListener.onLoadMore(SmartRefreshLayout.this);
                    } else if (SmartRefreshLayout.this.mOnMultiListener == null) {
                        SmartRefreshLayout.this.finishLoadMore(2000);
                    }
                    OnMultiListener listener = SmartRefreshLayout.this.mOnMultiListener;
                    if (listener != null) {
                        listener.onLoadMore(SmartRefreshLayout.this);
                    }
                }
            }, (long)this.mReboundDuration);
        }
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        SmartRefreshLayout thisView = this;
        return new LayoutParams(thisView.getContext(), attrs);
    }

    public int getNestedScrollAxes() {
        return this.mNestedParent.getNestedScrollAxes();
    }

    public boolean onStartNestedScroll(@NonNull View child, @NonNull View target, int nestedScrollAxes) {
        SmartRefreshLayout thisView = this;
        boolean accepted = thisView.isEnabled() && this.isNestedScrollingEnabled() && (nestedScrollAxes & 2) != 0;
        accepted = accepted && (this.mEnableOverScrollDrag || this.mEnableRefresh || this.mEnableLoadMore);
        return accepted;
    }

    public void onNestedScrollAccepted(@NonNull View child, @NonNull View target, int axes) {
        this.mNestedParent.onNestedScrollAccepted(child, target, axes);
        this.mNestedChild.startNestedScroll(axes & 2);
        this.mTotalUnconsumed = this.mSpinner;
        this.mNestedInProgress = true;
        this.interceptAnimatorByAction(0);
    }

    public void onNestedPreScroll(@NonNull View target, int dx, int dy, @NonNull int[] consumed) {
        int consumedY = 0;
        if (dy * this.mTotalUnconsumed > 0) {
            if (Math.abs(dy) > Math.abs(this.mTotalUnconsumed)) {
                consumedY = this.mTotalUnconsumed;
                this.mTotalUnconsumed = 0;
            } else {
                consumedY = dy;
                this.mTotalUnconsumed -= dy;
            }
            this.moveSpinnerInfinitely(this.mTotalUnconsumed);
        } else if (dy > 0 && this.mFooterLocked) {
            consumedY = dy;
            this.mTotalUnconsumed -= dy;
            this.moveSpinnerInfinitely(this.mTotalUnconsumed);
        }
        this.mNestedChild.dispatchNestedPreScroll(dx, dy - consumedY, consumed, null);
        consumed[1] = consumed[1] + consumedY;
    }

    public void onNestedScroll(@NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        boolean scrolled = this.mNestedChild.dispatchNestedScroll(dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, this.mParentOffsetInWindow);
        int dy = dyUnconsumed + this.mParentOffsetInWindow[1];
        if (dy < 0 && (this.mEnableRefresh || this.mEnableOverScrollDrag) && (this.mTotalUnconsumed != 0 || this.mScrollBoundaryDecider == null || this.mScrollBoundaryDecider.canRefresh(this.mRefreshContent.getView())) || dy > 0 && (this.mEnableLoadMore || this.mEnableOverScrollDrag) && (this.mTotalUnconsumed != 0 || this.mScrollBoundaryDecider == null || this.mScrollBoundaryDecider.canLoadMore(this.mRefreshContent.getView()))) {
            if (this.mViceState == RefreshState.None || this.mViceState.isOpening) {
                SmartRefreshLayout thisView;
                ViewParent parent;
                this.mKernel.setState(dy > 0 ? RefreshState.PullUpToLoad : RefreshState.PullDownToRefresh);
                if (!scrolled && (parent = (thisView = this).getParent()) != null) {
                    parent.requestDisallowInterceptTouchEvent(true);
                }
            }
            this.moveSpinnerInfinitely(this.mTotalUnconsumed -= dy);
        }
        if (this.mFooterLocked && dyConsumed < 0) {
            this.mFooterLocked = false;
        }
    }

    public boolean onNestedPreFling(@NonNull View target, float velocityX, float velocityY) {
        return this.mFooterLocked && velocityY > 0.0f || this.startFlingIfNeed(-velocityY) || this.mNestedChild.dispatchNestedPreFling(velocityX, velocityY);
    }

    public boolean onNestedFling(@NonNull View target, float velocityX, float velocityY, boolean consumed) {
        return this.mNestedChild.dispatchNestedFling(velocityX, velocityY, consumed);
    }

    public void onStopNestedScroll(@NonNull View target) {
        this.mNestedParent.onStopNestedScroll(target);
        this.mNestedInProgress = false;
        this.mTotalUnconsumed = 0;
        this.overSpinner();
        this.mNestedChild.stopNestedScroll();
    }

    public void setNestedScrollingEnabled(boolean enabled) {
        this.mEnableNestedScrolling = enabled;
        this.mNestedChild.setNestedScrollingEnabled(enabled);
    }

    public boolean isNestedScrollingEnabled() {
        return this.mEnableNestedScrolling && (this.mEnableOverScrollDrag || this.mEnableRefresh || this.mEnableLoadMore);
    }

    @Override
    public RefreshLayout setHeaderHeight(float heightDp) {
        return this.setHeaderHeightPx(SmartUtil.dp2px(heightDp));
    }

    @Override
    public RefreshLayout setHeaderHeightPx(int height) {
        if (height == this.mHeaderHeight) {
            return this;
        }
        if (this.mHeaderHeightStatus.canReplaceWith(DimensionStatus.CodeExact)) {
            this.mHeaderHeight = height;
            if (this.mRefreshHeader != null && this.mAttachedToWindow && this.mHeaderHeightStatus.notified) {
                SpinnerStyle style = this.mRefreshHeader.getSpinnerStyle();
                if (style != SpinnerStyle.MatchLayout && !style.scale) {
                    View headerView = this.mRefreshHeader.getView();
                    ViewGroup.LayoutParams lp = headerView.getLayoutParams();
                    ViewGroup.MarginLayoutParams mlp = lp instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)lp : sDefaultMarginLP;
                    int widthSpec = View.MeasureSpec.makeMeasureSpec((int)headerView.getMeasuredWidth(), (int)0x40000000);
                    headerView.measure(widthSpec, View.MeasureSpec.makeMeasureSpec((int)Math.max(this.mHeaderHeight - mlp.bottomMargin - mlp.topMargin, 0), (int)0x40000000));
                    int left = mlp.leftMargin;
                    int top = mlp.topMargin + this.mHeaderInsetStart - (style == SpinnerStyle.Translate ? this.mHeaderHeight : 0);
                    headerView.layout(left, top, left + headerView.getMeasuredWidth(), top + headerView.getMeasuredHeight());
                }
                int maxDragHeight = (int)(this.mHeaderMaxDragRate < 10.0f ? (float)this.mHeaderHeight * this.mHeaderMaxDragRate : this.mHeaderMaxDragRate);
                this.mHeaderHeightStatus = DimensionStatus.CodeExact;
                this.mRefreshHeader.onInitialized(this.mKernel, this.mHeaderHeight, maxDragHeight);
            } else {
                this.mHeaderHeightStatus = DimensionStatus.CodeExactUnNotify;
            }
        }
        return this;
    }

    @Override
    public RefreshLayout setFooterHeight(float heightDp) {
        return this.setFooterHeightPx(SmartUtil.dp2px(heightDp));
    }

    @Override
    public RefreshLayout setFooterHeightPx(int height) {
        if (height == this.mFooterHeight) {
            return this;
        }
        if (this.mFooterHeightStatus.canReplaceWith(DimensionStatus.CodeExact)) {
            this.mFooterHeight = height;
            if (this.mRefreshFooter != null && this.mAttachedToWindow && this.mFooterHeightStatus.notified) {
                SpinnerStyle style = this.mRefreshFooter.getSpinnerStyle();
                if (style != SpinnerStyle.MatchLayout && !style.scale) {
                    SmartRefreshLayout thisView = this;
                    View footerView = this.mRefreshFooter.getView();
                    ViewGroup.LayoutParams lp = footerView.getLayoutParams();
                    ViewGroup.MarginLayoutParams mlp = lp instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)lp : sDefaultMarginLP;
                    int widthSpec = View.MeasureSpec.makeMeasureSpec((int)footerView.getMeasuredWidth(), (int)0x40000000);
                    footerView.measure(widthSpec, View.MeasureSpec.makeMeasureSpec((int)Math.max(this.mFooterHeight - mlp.bottomMargin - mlp.topMargin, 0), (int)0x40000000));
                    int left = mlp.leftMargin;
                    int top = mlp.topMargin + thisView.getMeasuredHeight() - this.mFooterInsetStart - (style != SpinnerStyle.Translate ? this.mFooterHeight : 0);
                    footerView.layout(left, top, left + footerView.getMeasuredWidth(), top + footerView.getMeasuredHeight());
                }
                float maxDragHeight = this.mFooterMaxDragRate < 10.0f ? (float)this.mFooterHeight * this.mFooterMaxDragRate : this.mFooterMaxDragRate;
                this.mFooterHeightStatus = DimensionStatus.CodeExact;
                this.mRefreshFooter.onInitialized(this.mKernel, this.mFooterHeight, (int)maxDragHeight);
            } else {
                this.mFooterHeightStatus = DimensionStatus.CodeExactUnNotify;
            }
        }
        return this;
    }

    @Override
    public RefreshLayout setHeaderInsetStart(float insetDp) {
        this.mHeaderInsetStart = SmartUtil.dp2px(insetDp);
        return this;
    }

    @Override
    public RefreshLayout setHeaderInsetStartPx(int insetPx) {
        this.mHeaderInsetStart = insetPx;
        return this;
    }

    @Override
    public RefreshLayout setFooterInsetStart(float insetDp) {
        this.mFooterInsetStart = SmartUtil.dp2px(insetDp);
        return this;
    }

    @Override
    public RefreshLayout setFooterInsetStartPx(int insetPx) {
        this.mFooterInsetStart = insetPx;
        return this;
    }

    @Override
    public RefreshLayout setDragRate(float rate) {
        this.mDragRate = rate;
        return this;
    }

    @Override
    public RefreshLayout setHeaderMaxDragRate(float rate) {
        this.mHeaderMaxDragRate = rate;
        if (this.mRefreshHeader != null && this.mAttachedToWindow) {
            int maxDragHeight = (int)(this.mHeaderMaxDragRate < 10.0f ? (float)this.mHeaderHeight * this.mHeaderMaxDragRate : this.mHeaderMaxDragRate);
            this.mRefreshHeader.onInitialized(this.mKernel, this.mHeaderHeight, maxDragHeight);
        } else {
            this.mHeaderHeightStatus = this.mHeaderHeightStatus.unNotify();
        }
        return this;
    }

    @Override
    public RefreshLayout setFooterMaxDragRate(float rate) {
        this.mFooterMaxDragRate = rate;
        if (this.mRefreshFooter != null && this.mAttachedToWindow) {
            float maxDragHeight = this.mFooterMaxDragRate < 10.0f ? (float)this.mFooterHeight * this.mFooterMaxDragRate : this.mFooterMaxDragRate;
            this.mRefreshFooter.onInitialized(this.mKernel, this.mFooterHeight, (int)maxDragHeight);
        } else {
            this.mFooterHeightStatus = this.mFooterHeightStatus.unNotify();
        }
        return this;
    }

    @Override
    public RefreshLayout setHeaderTriggerRate(float rate) {
        this.mHeaderTriggerRate = rate;
        return this;
    }

    @Override
    public RefreshLayout setFooterTriggerRate(float rate) {
        this.mFooterTriggerRate = rate;
        return this;
    }

    @Override
    public RefreshLayout setReboundInterpolator(@NonNull Interpolator interpolator) {
        this.mReboundInterpolator = interpolator;
        return this;
    }

    @Override
    public RefreshLayout setReboundDuration(int duration) {
        this.mReboundDuration = duration;
        return this;
    }

    @Override
    public RefreshLayout setEnableLoadMore(boolean enabled) {
        this.mManualLoadMore = true;
        this.mEnableLoadMore = enabled;
        return this;
    }

    @Override
    public RefreshLayout setEnableRefresh(boolean enabled) {
        this.mEnableRefresh = enabled;
        return this;
    }

    @Override
    public RefreshLayout setEnableHeaderTranslationContent(boolean enabled) {
        this.mEnableHeaderTranslationContent = enabled;
        this.mManualHeaderTranslationContent = true;
        return this;
    }

    @Override
    public RefreshLayout setEnableFooterTranslationContent(boolean enabled) {
        this.mEnableFooterTranslationContent = enabled;
        this.mManualFooterTranslationContent = true;
        return this;
    }

    @Override
    public RefreshLayout setEnableAutoLoadMore(boolean enabled) {
        this.mEnableAutoLoadMore = enabled;
        return this;
    }

    @Override
    public RefreshLayout setEnableOverScrollBounce(boolean enabled) {
        this.mEnableOverScrollBounce = enabled;
        return this;
    }

    @Override
    public RefreshLayout setEnablePureScrollMode(boolean enabled) {
        this.mEnablePureScrollMode = enabled;
        return this;
    }

    @Override
    public RefreshLayout setEnableScrollContentWhenLoaded(boolean enabled) {
        this.mEnableScrollContentWhenLoaded = enabled;
        return this;
    }

    @Override
    public RefreshLayout setEnableScrollContentWhenRefreshed(boolean enabled) {
        this.mEnableScrollContentWhenRefreshed = enabled;
        return this;
    }

    @Override
    public RefreshLayout setEnableLoadMoreWhenContentNotFull(boolean enabled) {
        this.mEnableLoadMoreWhenContentNotFull = enabled;
        if (this.mRefreshContent != null) {
            this.mRefreshContent.setEnableLoadMoreWhenContentNotFull(enabled);
        }
        return this;
    }

    @Override
    public RefreshLayout setEnableOverScrollDrag(boolean enabled) {
        this.mEnableOverScrollDrag = enabled;
        return this;
    }

    @Override
    public RefreshLayout setEnableFooterFollowWhenNoMoreData(boolean enabled) {
        this.mEnableFooterFollowWhenNoMoreData = enabled;
        return this;
    }

    @Override
    public RefreshLayout setEnableClipHeaderWhenFixedBehind(boolean enabled) {
        this.mEnableClipHeaderWhenFixedBehind = enabled;
        return this;
    }

    @Override
    public RefreshLayout setEnableClipFooterWhenFixedBehind(boolean enabled) {
        this.mEnableClipFooterWhenFixedBehind = enabled;
        return this;
    }

    @Override
    public RefreshLayout setEnableNestedScroll(boolean enabled) {
        this.setNestedScrollingEnabled(enabled);
        return this;
    }

    @Override
    public RefreshLayout setFixedHeaderViewId(int id2) {
        this.mFixedHeaderViewId = id2;
        return this;
    }

    @Override
    public RefreshLayout setFixedFooterViewId(int id2) {
        this.mFixedFooterViewId = id2;
        return this;
    }

    @Override
    public RefreshLayout setHeaderTranslationViewId(int id2) {
        this.mHeaderTranslationViewId = id2;
        return this;
    }

    @Override
    public RefreshLayout setFooterTranslationViewId(int id2) {
        this.mFooterTranslationViewId = id2;
        return this;
    }

    @Override
    public RefreshLayout setDisableContentWhenRefresh(boolean disable) {
        this.mDisableContentWhenRefresh = disable;
        return this;
    }

    @Override
    public RefreshLayout setDisableContentWhenLoading(boolean disable) {
        this.mDisableContentWhenLoading = disable;
        return this;
    }

    @Override
    public RefreshLayout setRefreshHeader(@NonNull RefreshHeader header) {
        return this.setRefreshHeader(header, 0, 0);
    }

    @Override
    public RefreshLayout setRefreshHeader(@NonNull RefreshHeader header, int width, int height) {
        if (this.mRefreshHeader != null) {
            super.removeView(this.mRefreshHeader.getView());
        }
        this.mRefreshHeader = header;
        this.mHeaderBackgroundColor = 0;
        this.mHeaderNeedTouchEventWhenRefreshing = false;
        this.mHeaderHeightStatus = DimensionStatus.DefaultUnNotify;
        width = width == 0 ? -1 : width;
        height = height == 0 ? -2 : height;
        LayoutParams lp = new LayoutParams(width, height);
        ViewGroup.LayoutParams olp = header.getView().getLayoutParams();
        if (olp instanceof LayoutParams) {
            lp = (LayoutParams)olp;
        }
        if (this.mRefreshHeader.getSpinnerStyle().front) {
            SmartRefreshLayout thisGroup = this;
            super.addView(this.mRefreshHeader.getView(), thisGroup.getChildCount(), (ViewGroup.LayoutParams)lp);
        } else {
            super.addView(this.mRefreshHeader.getView(), 0, (ViewGroup.LayoutParams)lp);
        }
        if (this.mPrimaryColors != null && this.mRefreshHeader != null) {
            this.mRefreshHeader.setPrimaryColors(this.mPrimaryColors);
        }
        return this;
    }

    @Override
    public RefreshLayout setRefreshFooter(@NonNull RefreshFooter footer) {
        return this.setRefreshFooter(footer, 0, 0);
    }

    @Override
    public RefreshLayout setRefreshFooter(@NonNull RefreshFooter footer, int width, int height) {
        if (this.mRefreshFooter != null) {
            super.removeView(this.mRefreshFooter.getView());
        }
        this.mRefreshFooter = footer;
        this.mFooterLocked = false;
        this.mFooterBackgroundColor = 0;
        this.mFooterNoMoreDataEffective = false;
        this.mFooterNeedTouchEventWhenLoading = false;
        this.mFooterHeightStatus = DimensionStatus.DefaultUnNotify;
        this.mEnableLoadMore = !this.mManualLoadMore || this.mEnableLoadMore;
        width = width == 0 ? -1 : width;
        height = height == 0 ? -2 : height;
        LayoutParams lp = new LayoutParams(width, height);
        ViewGroup.LayoutParams olp = footer.getView().getLayoutParams();
        if (olp instanceof LayoutParams) {
            lp = (LayoutParams)olp;
        }
        if (this.mRefreshFooter.getSpinnerStyle().front) {
            SmartRefreshLayout thisGroup = this;
            super.addView(this.mRefreshFooter.getView(), thisGroup.getChildCount(), (ViewGroup.LayoutParams)lp);
        } else {
            super.addView(this.mRefreshFooter.getView(), 0, (ViewGroup.LayoutParams)lp);
        }
        if (this.mPrimaryColors != null && this.mRefreshFooter != null) {
            this.mRefreshFooter.setPrimaryColors(this.mPrimaryColors);
        }
        return this;
    }

    @Override
    public RefreshLayout setRefreshContent(@NonNull View content) {
        return this.setRefreshContent(content, 0, 0);
    }

    @Override
    public RefreshLayout setRefreshContent(@NonNull View content, int width, int height) {
        SmartRefreshLayout thisView = this;
        if (this.mRefreshContent != null) {
            super.removeView(this.mRefreshContent.getView());
        }
        SmartRefreshLayout thisGroup = this;
        width = width == 0 ? -1 : width;
        height = height == 0 ? -1 : height;
        LayoutParams lp = new LayoutParams(width, height);
        ViewGroup.LayoutParams olp = content.getLayoutParams();
        if (olp instanceof LayoutParams) {
            lp = (LayoutParams)olp;
        }
        super.addView(content, thisGroup.getChildCount(), (ViewGroup.LayoutParams)lp);
        this.mRefreshContent = new RefreshContentWrapper(content);
        if (this.mAttachedToWindow) {
            View fixedHeaderView = thisView.findViewById(this.mFixedHeaderViewId);
            View fixedFooterView = thisView.findViewById(this.mFixedFooterViewId);
            this.mRefreshContent.setScrollBoundaryDecider(this.mScrollBoundaryDecider);
            this.mRefreshContent.setEnableLoadMoreWhenContentNotFull(this.mEnableLoadMoreWhenContentNotFull);
            this.mRefreshContent.setUpComponent(this.mKernel, fixedHeaderView, fixedFooterView);
        }
        if (this.mRefreshHeader != null && this.mRefreshHeader.getSpinnerStyle().front) {
            super.bringChildToFront(this.mRefreshHeader.getView());
        }
        if (this.mRefreshFooter != null && this.mRefreshFooter.getSpinnerStyle().front) {
            super.bringChildToFront(this.mRefreshFooter.getView());
        }
        return this;
    }

    @Override
    @Nullable
    public RefreshFooter getRefreshFooter() {
        return this.mRefreshFooter instanceof RefreshFooter ? (RefreshFooter)this.mRefreshFooter : null;
    }

    @Override
    @Nullable
    public RefreshHeader getRefreshHeader() {
        return this.mRefreshHeader instanceof RefreshHeader ? (RefreshHeader)this.mRefreshHeader : null;
    }

    @Override
    @NonNull
    public RefreshState getState() {
        return this.mState;
    }

    @Override
    @NonNull
    public ViewGroup getLayout() {
        return this;
    }

    @Override
    public RefreshLayout setOnRefreshListener(OnRefreshListener listener) {
        this.mRefreshListener = listener;
        return this;
    }

    @Override
    public RefreshLayout setOnLoadMoreListener(OnLoadMoreListener listener) {
        this.mLoadMoreListener = listener;
        this.mEnableLoadMore = this.mEnableLoadMore || !this.mManualLoadMore && listener != null;
        return this;
    }

    @Override
    public RefreshLayout setOnRefreshLoadMoreListener(OnRefreshLoadMoreListener listener) {
        this.mRefreshListener = listener;
        this.mLoadMoreListener = listener;
        this.mEnableLoadMore = this.mEnableLoadMore || !this.mManualLoadMore && listener != null;
        return this;
    }

    @Override
    public RefreshLayout setOnMultiListener(OnMultiListener listener) {
        this.mOnMultiListener = listener;
        return this;
    }

    @Override
    public RefreshLayout setPrimaryColors(int ... primaryColors) {
        if (this.mRefreshHeader != null) {
            this.mRefreshHeader.setPrimaryColors(primaryColors);
        }
        if (this.mRefreshFooter != null) {
            this.mRefreshFooter.setPrimaryColors(primaryColors);
        }
        this.mPrimaryColors = primaryColors;
        return this;
    }

    @Override
    public RefreshLayout setPrimaryColorsId(int ... primaryColorId) {
        SmartRefreshLayout thisView = this;
        int[] colors = new int[primaryColorId.length];
        for (int i = 0; i < primaryColorId.length; ++i) {
            colors[i] = ContextCompat.getColor((Context)thisView.getContext(), (int)primaryColorId[i]);
        }
        this.setPrimaryColors(colors);
        return this;
    }

    @Override
    public RefreshLayout setScrollBoundaryDecider(ScrollBoundaryDecider boundary) {
        this.mScrollBoundaryDecider = boundary;
        if (this.mRefreshContent != null) {
            this.mRefreshContent.setScrollBoundaryDecider(boundary);
        }
        return this;
    }

    @Override
    public RefreshLayout setNoMoreData(boolean noMoreData) {
        if (this.mState == RefreshState.Refreshing && noMoreData) {
            this.finishRefreshWithNoMoreData();
        } else if (this.mState == RefreshState.Loading && noMoreData) {
            this.finishLoadMoreWithNoMoreData();
        } else if (this.mFooterNoMoreData != noMoreData) {
            this.mFooterNoMoreData = noMoreData;
            if (this.mRefreshFooter instanceof RefreshFooter) {
                if (((RefreshFooter)this.mRefreshFooter).setNoMoreData(noMoreData)) {
                    this.mFooterNoMoreDataEffective = true;
                    if (this.mFooterNoMoreData && this.mEnableFooterFollowWhenNoMoreData && this.mSpinner > 0 && this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.Translate && this.isEnableRefreshOrLoadMore(this.mEnableLoadMore) && this.isEnableTranslationContent(this.mEnableRefresh, this.mRefreshHeader)) {
                        this.mRefreshFooter.getView().setTranslationY((float)this.mSpinner);
                    }
                } else {
                    this.mFooterNoMoreDataEffective = false;
                    String msg = "Footer:" + this.mRefreshFooter + " NoMoreData is not supported.(\u4e0d\u652f\u6301NoMoreData\uff0c\u8bf7\u4f7f\u7528[ClassicsFooter]\u6216\u8005[\u81ea\u5b9a\u4e49Footer\u5e76\u5b9e\u73b0setNoMoreData\u65b9\u6cd5\u4e14\u8fd4\u56detrue])";
                    RuntimeException e = new RuntimeException(msg);
                    e.printStackTrace();
                }
            }
        }
        return this;
    }

    @Override
    public RefreshLayout resetNoMoreData() {
        return this.setNoMoreData(false);
    }

    @Override
    public RefreshLayout finishRefresh() {
        return this.finishRefresh(true);
    }

    @Override
    public RefreshLayout finishLoadMore() {
        return this.finishLoadMore(true);
    }

    @Override
    public RefreshLayout finishRefresh(int delayed) {
        return this.finishRefresh(delayed, true, Boolean.FALSE);
    }

    @Override
    public RefreshLayout finishRefresh(boolean success) {
        if (success) {
            long passTime = System.currentTimeMillis() - this.mLastOpenTime;
            int delayed = Math.min(Math.max(0, 300 - (int)passTime), 300) << 16;
            return this.finishRefresh(delayed, true, Boolean.FALSE);
        }
        return this.finishRefresh(0, false, null);
    }

    @Override
    public RefreshLayout finishRefresh(int delayed, final boolean success, final Boolean noMoreData) {
        final int more = delayed >> 16;
        int delay = delayed << 16 >> 16;
        Runnable runnable = new Runnable(){
            int count = 0;

            @Override
            public void run() {
                if (this.count == 0) {
                    if (SmartRefreshLayout.this.mState == RefreshState.None && SmartRefreshLayout.this.mViceState == RefreshState.Refreshing) {
                        SmartRefreshLayout.this.mViceState = RefreshState.None;
                    } else if (SmartRefreshLayout.this.reboundAnimator != null && SmartRefreshLayout.this.mState.isHeader && (SmartRefreshLayout.this.mState.isDragging || SmartRefreshLayout.this.mState == RefreshState.RefreshReleased)) {
                        SmartRefreshLayout.this.reboundAnimator.setDuration(0L);
                        SmartRefreshLayout.this.reboundAnimator.cancel();
                        SmartRefreshLayout.this.reboundAnimator = null;
                        if (SmartRefreshLayout.this.mKernel.animSpinner(0) == null) {
                            SmartRefreshLayout.this.notifyStateChanged(RefreshState.None);
                        } else {
                            SmartRefreshLayout.this.notifyStateChanged(RefreshState.PullDownCanceled);
                        }
                    } else if (SmartRefreshLayout.this.mState == RefreshState.Refreshing) {
                        ++this.count;
                        SmartRefreshLayout.this.mHandler.postDelayed((Runnable)this, (long)more);
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.RefreshFinish);
                        if (noMoreData == Boolean.FALSE) {
                            SmartRefreshLayout.this.setNoMoreData(false);
                        }
                    }
                    if (noMoreData == Boolean.TRUE) {
                        SmartRefreshLayout.this.setNoMoreData(true);
                    }
                } else {
                    int startDelay = 0;
                    if (SmartRefreshLayout.this.mRefreshHeader != null) {
                        startDelay = SmartRefreshLayout.this.mRefreshHeader.onFinish(SmartRefreshLayout.this, success);
                        if (SmartRefreshLayout.this.mOnMultiListener != null && SmartRefreshLayout.this.mRefreshHeader instanceof RefreshHeader) {
                            SmartRefreshLayout.this.mOnMultiListener.onHeaderFinish((RefreshHeader)SmartRefreshLayout.this.mRefreshHeader, success);
                        }
                    }
                    if (startDelay < Integer.MAX_VALUE) {
                        if (SmartRefreshLayout.this.mIsBeingDragged || SmartRefreshLayout.this.mNestedInProgress) {
                            long time = System.currentTimeMillis();
                            if (SmartRefreshLayout.this.mIsBeingDragged) {
                                SmartRefreshLayout.this.mTouchY = SmartRefreshLayout.this.mLastTouchY;
                                SmartRefreshLayout.this.mTouchSpinner = 0;
                                SmartRefreshLayout.this.mIsBeingDragged = false;
                                SmartRefreshLayout.super.dispatchTouchEvent(MotionEvent.obtain((long)time, (long)time, (int)0, (float)SmartRefreshLayout.this.mLastTouchX, (float)(SmartRefreshLayout.this.mLastTouchY + (float)SmartRefreshLayout.this.mSpinner - (float)(SmartRefreshLayout.this.mTouchSlop * 2)), (int)0));
                                SmartRefreshLayout.super.dispatchTouchEvent(MotionEvent.obtain((long)time, (long)time, (int)2, (float)SmartRefreshLayout.this.mLastTouchX, (float)(SmartRefreshLayout.this.mLastTouchY + (float)SmartRefreshLayout.this.mSpinner), (int)0));
                            }
                            if (SmartRefreshLayout.this.mNestedInProgress) {
                                SmartRefreshLayout.this.mTotalUnconsumed = 0;
                                SmartRefreshLayout.super.dispatchTouchEvent(MotionEvent.obtain((long)time, (long)time, (int)1, (float)SmartRefreshLayout.this.mLastTouchX, (float)SmartRefreshLayout.this.mLastTouchY, (int)0));
                                SmartRefreshLayout.this.mNestedInProgress = false;
                                SmartRefreshLayout.this.mTouchSpinner = 0;
                            }
                        }
                        if (SmartRefreshLayout.this.mSpinner > 0) {
                            ValueAnimator.AnimatorUpdateListener updateListener = null;
                            ValueAnimator valueAnimator = SmartRefreshLayout.this.animSpinner(0, startDelay, SmartRefreshLayout.this.mReboundInterpolator, SmartRefreshLayout.this.mReboundDuration);
                            if (SmartRefreshLayout.this.mEnableScrollContentWhenRefreshed) {
                                updateListener = SmartRefreshLayout.this.mRefreshContent.scrollContentWhenFinished(SmartRefreshLayout.this.mSpinner);
                            }
                            if (valueAnimator != null && updateListener != null) {
                                valueAnimator.addUpdateListener(updateListener);
                            }
                        } else if (SmartRefreshLayout.this.mSpinner < 0) {
                            SmartRefreshLayout.this.animSpinner(0, startDelay, SmartRefreshLayout.this.mReboundInterpolator, SmartRefreshLayout.this.mReboundDuration);
                        } else {
                            SmartRefreshLayout.this.mKernel.moveSpinner(0, false);
                            SmartRefreshLayout.this.mKernel.setState(RefreshState.None);
                        }
                    }
                }
            }
        };
        if (delay > 0) {
            this.mHandler.postDelayed(runnable, (long)delay);
        } else {
            runnable.run();
        }
        return this;
    }

    @Override
    public RefreshLayout finishRefreshWithNoMoreData() {
        long passTime = System.currentTimeMillis() - this.mLastOpenTime;
        return this.finishRefresh(Math.min(Math.max(0, 300 - (int)passTime), 300) << 16, true, Boolean.TRUE);
    }

    @Override
    public RefreshLayout finishLoadMore(int delayed) {
        return this.finishLoadMore(delayed, true, false);
    }

    @Override
    public RefreshLayout finishLoadMore(boolean success) {
        long passTime = System.currentTimeMillis() - this.mLastOpenTime;
        return this.finishLoadMore(success ? Math.min(Math.max(0, 300 - (int)passTime), 300) << 16 : 0, success, false);
    }

    @Override
    public RefreshLayout finishLoadMore(int delayed, final boolean success, final boolean noMoreData) {
        final int more = delayed >> 16;
        int delay = delayed << 16 >> 16;
        Runnable runnable = new Runnable(){
            int count = 0;

            @Override
            public void run() {
                if (this.count == 0) {
                    if (SmartRefreshLayout.this.mState == RefreshState.None && SmartRefreshLayout.this.mViceState == RefreshState.Loading) {
                        SmartRefreshLayout.this.mViceState = RefreshState.None;
                    } else if (SmartRefreshLayout.this.reboundAnimator != null && (SmartRefreshLayout.this.mState.isDragging || SmartRefreshLayout.this.mState == RefreshState.LoadReleased) && SmartRefreshLayout.this.mState.isFooter) {
                        SmartRefreshLayout.this.reboundAnimator.setDuration(0L);
                        SmartRefreshLayout.this.reboundAnimator.cancel();
                        SmartRefreshLayout.this.reboundAnimator = null;
                        if (SmartRefreshLayout.this.mKernel.animSpinner(0) == null) {
                            SmartRefreshLayout.this.notifyStateChanged(RefreshState.None);
                        } else {
                            SmartRefreshLayout.this.notifyStateChanged(RefreshState.PullUpCanceled);
                        }
                    } else if (SmartRefreshLayout.this.mState == RefreshState.Loading && SmartRefreshLayout.this.mRefreshFooter != null && SmartRefreshLayout.this.mRefreshContent != null) {
                        ++this.count;
                        SmartRefreshLayout.this.mHandler.postDelayed((Runnable)this, (long)more);
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.LoadFinish);
                        return;
                    }
                    if (noMoreData) {
                        SmartRefreshLayout.this.setNoMoreData(true);
                    }
                } else {
                    int startDelay = SmartRefreshLayout.this.mRefreshFooter.onFinish(SmartRefreshLayout.this, success);
                    if (SmartRefreshLayout.this.mOnMultiListener != null && SmartRefreshLayout.this.mRefreshFooter instanceof RefreshFooter) {
                        SmartRefreshLayout.this.mOnMultiListener.onFooterFinish((RefreshFooter)SmartRefreshLayout.this.mRefreshFooter, success);
                    }
                    if (startDelay < Integer.MAX_VALUE) {
                        boolean needHoldFooter = noMoreData && SmartRefreshLayout.this.mEnableFooterFollowWhenNoMoreData && SmartRefreshLayout.this.mSpinner < 0 && SmartRefreshLayout.this.mRefreshContent.canLoadMore();
                        final int offset = SmartRefreshLayout.this.mSpinner - (needHoldFooter ? Math.max(SmartRefreshLayout.this.mSpinner, -SmartRefreshLayout.this.mFooterHeight) : 0);
                        if (SmartRefreshLayout.this.mIsBeingDragged || SmartRefreshLayout.this.mNestedInProgress) {
                            long time = System.currentTimeMillis();
                            if (SmartRefreshLayout.this.mIsBeingDragged) {
                                SmartRefreshLayout.this.mTouchY = SmartRefreshLayout.this.mLastTouchY;
                                SmartRefreshLayout.this.mTouchSpinner = SmartRefreshLayout.this.mSpinner - offset;
                                SmartRefreshLayout.this.mIsBeingDragged = false;
                                int offsetY = SmartRefreshLayout.this.mEnableFooterTranslationContent ? offset : 0;
                                SmartRefreshLayout.super.dispatchTouchEvent(MotionEvent.obtain((long)time, (long)time, (int)0, (float)SmartRefreshLayout.this.mLastTouchX, (float)(SmartRefreshLayout.this.mLastTouchY + (float)offsetY + (float)(SmartRefreshLayout.this.mTouchSlop * 2)), (int)0));
                                SmartRefreshLayout.super.dispatchTouchEvent(MotionEvent.obtain((long)time, (long)time, (int)2, (float)SmartRefreshLayout.this.mLastTouchX, (float)(SmartRefreshLayout.this.mLastTouchY + (float)offsetY), (int)0));
                            }
                            if (SmartRefreshLayout.this.mNestedInProgress) {
                                SmartRefreshLayout.this.mTotalUnconsumed = 0;
                                SmartRefreshLayout.super.dispatchTouchEvent(MotionEvent.obtain((long)time, (long)time, (int)1, (float)SmartRefreshLayout.this.mLastTouchX, (float)SmartRefreshLayout.this.mLastTouchY, (int)0));
                                SmartRefreshLayout.this.mNestedInProgress = false;
                                SmartRefreshLayout.this.mTouchSpinner = 0;
                            }
                        }
                        SmartRefreshLayout.this.mHandler.postDelayed(new Runnable(){

                            @Override
                            public void run() {
                                ValueAnimator.AnimatorUpdateListener updateListener = null;
                                if (SmartRefreshLayout.this.mEnableScrollContentWhenLoaded && offset < 0 && (updateListener = SmartRefreshLayout.this.mRefreshContent.scrollContentWhenFinished(SmartRefreshLayout.this.mSpinner)) != null) {
                                    updateListener.onAnimationUpdate(ValueAnimator.ofInt((int[])new int[]{0, 0}));
                                }
                                ValueAnimator animator = null;
                                AnimatorListenerAdapter listenerAdapter = new AnimatorListenerAdapter(){

                                    public void onAnimationEnd(Animator animation) {
                                        if (animation != null && animation.getDuration() == 0L) {
                                            return;
                                        }
                                        SmartRefreshLayout.this.mFooterLocked = false;
                                        if (noMoreData) {
                                            SmartRefreshLayout.this.setNoMoreData(true);
                                        }
                                        if (SmartRefreshLayout.this.mState == RefreshState.LoadFinish) {
                                            SmartRefreshLayout.this.notifyStateChanged(RefreshState.None);
                                        }
                                    }
                                };
                                if (SmartRefreshLayout.this.mSpinner > 0) {
                                    animator = SmartRefreshLayout.this.mKernel.animSpinner(0);
                                } else if (updateListener != null || SmartRefreshLayout.this.mSpinner == 0) {
                                    if (SmartRefreshLayout.this.reboundAnimator != null) {
                                        SmartRefreshLayout.this.reboundAnimator.setDuration(0L);
                                        SmartRefreshLayout.this.reboundAnimator.cancel();
                                        SmartRefreshLayout.this.reboundAnimator = null;
                                    }
                                    SmartRefreshLayout.this.mKernel.moveSpinner(0, false);
                                    SmartRefreshLayout.this.mKernel.setState(RefreshState.None);
                                } else if (noMoreData && SmartRefreshLayout.this.mEnableFooterFollowWhenNoMoreData) {
                                    if (SmartRefreshLayout.this.mSpinner >= -SmartRefreshLayout.this.mFooterHeight) {
                                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.None);
                                    } else {
                                        animator = SmartRefreshLayout.this.mKernel.animSpinner(-SmartRefreshLayout.this.mFooterHeight);
                                    }
                                } else {
                                    animator = SmartRefreshLayout.this.mKernel.animSpinner(0);
                                }
                                if (animator != null) {
                                    animator.addListener((Animator.AnimatorListener)listenerAdapter);
                                } else {
                                    listenerAdapter.onAnimationEnd(null);
                                }
                            }
                        }, SmartRefreshLayout.this.mSpinner < 0 ? (long)startDelay : 0L);
                    }
                }
            }
        };
        if (delay > 0) {
            this.mHandler.postDelayed(runnable, (long)delay);
        } else {
            runnable.run();
        }
        return this;
    }

    @Override
    public RefreshLayout finishLoadMoreWithNoMoreData() {
        long passTime = System.currentTimeMillis() - this.mLastOpenTime;
        return this.finishLoadMore(Math.min(Math.max(0, 300 - (int)passTime), 300) << 16, true, true);
    }

    @Override
    public RefreshLayout closeHeaderOrFooter() {
        if (this.mState == RefreshState.None && (this.mViceState == RefreshState.Refreshing || this.mViceState == RefreshState.Loading)) {
            this.mViceState = RefreshState.None;
        }
        if (this.mState == RefreshState.Refreshing) {
            this.finishRefresh();
        } else if (this.mState == RefreshState.Loading) {
            this.finishLoadMore();
        } else if (this.mKernel.animSpinner(0) == null) {
            this.notifyStateChanged(RefreshState.None);
        } else if (this.mState.isHeader) {
            this.notifyStateChanged(RefreshState.PullDownCanceled);
        } else {
            this.notifyStateChanged(RefreshState.PullUpCanceled);
        }
        return this;
    }

    @Override
    public boolean autoRefresh() {
        return this.autoRefresh(this.mAttachedToWindow ? 0 : 400, this.mReboundDuration, (this.mHeaderMaxDragRate + this.mHeaderTriggerRate) / 2.0f, false);
    }

    @Override
    public boolean autoRefresh(int delayed) {
        return this.autoRefresh(delayed, this.mReboundDuration, (this.mHeaderMaxDragRate + this.mHeaderTriggerRate) / 2.0f, false);
    }

    @Override
    public boolean autoRefreshAnimationOnly() {
        return this.autoRefresh(this.mAttachedToWindow ? 0 : 400, this.mReboundDuration, (this.mHeaderMaxDragRate + this.mHeaderTriggerRate) / 2.0f, true);
    }

    @Override
    public boolean autoRefresh(int delayed, final int duration, final float dragRate, final boolean animationOnly) {
        if (this.mState == RefreshState.None && this.isEnableRefreshOrLoadMore(this.mEnableRefresh)) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (SmartRefreshLayout.this.mViceState != RefreshState.Refreshing) {
                        return;
                    }
                    if (SmartRefreshLayout.this.reboundAnimator != null) {
                        SmartRefreshLayout.this.reboundAnimator.setDuration(0L);
                        SmartRefreshLayout.this.reboundAnimator.cancel();
                        SmartRefreshLayout.this.reboundAnimator = null;
                    }
                    SmartRefreshLayout thisView = SmartRefreshLayout.this;
                    SmartRefreshLayout.this.mLastTouchX = (float)thisView.getMeasuredWidth() / 2.0f;
                    SmartRefreshLayout.this.mKernel.setState(RefreshState.PullDownToRefresh);
                    if (SmartRefreshLayout.this.mRefreshHeader != null && SmartRefreshLayout.this.mRefreshHeader.autoOpen(duration, dragRate, animationOnly)) {
                        return;
                    }
                    float height = SmartRefreshLayout.this.mHeaderHeight == 0 ? SmartRefreshLayout.this.mHeaderTriggerRate : (float)SmartRefreshLayout.this.mHeaderHeight;
                    float dragHeight = dragRate < 10.0f ? height * dragRate : dragRate;
                    SmartRefreshLayout.this.reboundAnimator = ValueAnimator.ofInt((int[])new int[]{SmartRefreshLayout.this.mSpinner, (int)dragHeight});
                    SmartRefreshLayout.this.reboundAnimator.setDuration((long)duration);
                    SmartRefreshLayout.this.reboundAnimator.setInterpolator((TimeInterpolator)new SmartUtil(SmartUtil.INTERPOLATOR_VISCOUS_FLUID));
                    SmartRefreshLayout.this.reboundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            if (SmartRefreshLayout.this.reboundAnimator != null && SmartRefreshLayout.this.mRefreshHeader != null) {
                                SmartRefreshLayout.this.mKernel.moveSpinner((Integer)animation.getAnimatedValue(), true);
                            }
                        }
                    });
                    SmartRefreshLayout.this.reboundAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            SmartRefreshLayout.this.mKernel.onAutoRefreshAnimationEnd(animation, animationOnly);
                        }
                    });
                    SmartRefreshLayout.this.reboundAnimator.start();
                }
            };
            this.setViceState(RefreshState.Refreshing);
            if (delayed > 0) {
                this.mHandler.postDelayed(runnable, (long)delayed);
            } else {
                runnable.run();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean autoLoadMore() {
        return this.autoLoadMore(0, this.mReboundDuration, (this.mFooterMaxDragRate + this.mFooterTriggerRate) / 2.0f, false);
    }

    @Override
    public boolean autoLoadMore(int delayed) {
        return this.autoLoadMore(delayed, this.mReboundDuration, (this.mFooterMaxDragRate + this.mFooterTriggerRate) / 2.0f, false);
    }

    @Override
    public boolean autoLoadMoreAnimationOnly() {
        return this.autoLoadMore(0, this.mReboundDuration, (this.mFooterMaxDragRate + this.mFooterTriggerRate) / 2.0f, true);
    }

    @Override
    public boolean autoLoadMore(int delayed, final int duration, final float dragRate, final boolean animationOnly) {
        if (this.mState == RefreshState.None && this.isEnableRefreshOrLoadMore(this.mEnableLoadMore) && !this.mFooterNoMoreData) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    if (SmartRefreshLayout.this.mViceState != RefreshState.Loading) {
                        return;
                    }
                    if (SmartRefreshLayout.this.reboundAnimator != null) {
                        SmartRefreshLayout.this.reboundAnimator.setDuration(0L);
                        SmartRefreshLayout.this.reboundAnimator.cancel();
                        SmartRefreshLayout.this.reboundAnimator = null;
                    }
                    SmartRefreshLayout thisView = SmartRefreshLayout.this;
                    SmartRefreshLayout.this.mLastTouchX = (float)thisView.getMeasuredWidth() / 2.0f;
                    SmartRefreshLayout.this.mKernel.setState(RefreshState.PullUpToLoad);
                    if (SmartRefreshLayout.this.mRefreshFooter != null && SmartRefreshLayout.this.mRefreshFooter.autoOpen(duration, dragRate, animationOnly)) {
                        return;
                    }
                    float height = SmartRefreshLayout.this.mFooterHeight == 0 ? SmartRefreshLayout.this.mFooterTriggerRate : (float)SmartRefreshLayout.this.mFooterHeight;
                    float dragHeight = dragRate < 10.0f ? dragRate * height : dragRate;
                    SmartRefreshLayout.this.reboundAnimator = ValueAnimator.ofInt((int[])new int[]{SmartRefreshLayout.this.mSpinner, -((int)dragHeight)});
                    SmartRefreshLayout.this.reboundAnimator.setDuration((long)duration);
                    SmartRefreshLayout.this.reboundAnimator.setInterpolator((TimeInterpolator)new SmartUtil(SmartUtil.INTERPOLATOR_VISCOUS_FLUID));
                    SmartRefreshLayout.this.reboundAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                        public void onAnimationUpdate(ValueAnimator animation) {
                            if (SmartRefreshLayout.this.reboundAnimator != null && SmartRefreshLayout.this.mRefreshFooter != null) {
                                SmartRefreshLayout.this.mKernel.moveSpinner((Integer)animation.getAnimatedValue(), true);
                            }
                        }
                    });
                    SmartRefreshLayout.this.reboundAnimator.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            SmartRefreshLayout.this.mKernel.onAutoLoadMoreAnimationEnd(animation, animationOnly);
                        }
                    });
                    SmartRefreshLayout.this.reboundAnimator.start();
                }
            };
            this.setViceState(RefreshState.Loading);
            if (delayed > 0) {
                this.mHandler.postDelayed(runnable, (long)delayed);
            } else {
                runnable.run();
            }
            return true;
        }
        return false;
    }

    public static void setDefaultRefreshHeaderCreator(@NonNull DefaultRefreshHeaderCreator creator) {
        sHeaderCreator = creator;
    }

    public static void setDefaultRefreshFooterCreator(@NonNull DefaultRefreshFooterCreator creator) {
        sFooterCreator = creator;
    }

    public static void setDefaultRefreshInitializer(@NonNull DefaultRefreshInitializer initializer) {
        sRefreshInitializer = initializer;
    }

    @Override
    public boolean isRefreshing() {
        return this.mState == RefreshState.Refreshing;
    }

    @Override
    public boolean isLoading() {
        return this.mState == RefreshState.Loading;
    }

    public class RefreshKernelImpl
    implements RefreshKernel {
        @Override
        @NonNull
        public RefreshLayout getRefreshLayout() {
            return SmartRefreshLayout.this;
        }

        @Override
        @NonNull
        public RefreshContent getRefreshContent() {
            return SmartRefreshLayout.this.mRefreshContent;
        }

        @Override
        public RefreshKernel setState(@NonNull RefreshState state) {
            switch (state) {
                case None: {
                    if (SmartRefreshLayout.this.mState != RefreshState.None && SmartRefreshLayout.this.mSpinner == 0) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.None);
                        break;
                    }
                    if (SmartRefreshLayout.this.mSpinner == 0) break;
                    this.animSpinner(0);
                    break;
                }
                case PullDownToRefresh: {
                    if (!SmartRefreshLayout.this.mState.isOpening && SmartRefreshLayout.this.isEnableRefreshOrLoadMore(SmartRefreshLayout.this.mEnableRefresh)) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.PullDownToRefresh);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.PullDownToRefresh);
                    break;
                }
                case PullUpToLoad: {
                    if (!(!SmartRefreshLayout.this.isEnableRefreshOrLoadMore(SmartRefreshLayout.this.mEnableLoadMore) || SmartRefreshLayout.this.mState.isOpening || SmartRefreshLayout.this.mState.isFinishing || SmartRefreshLayout.this.mFooterNoMoreData && SmartRefreshLayout.this.mEnableFooterFollowWhenNoMoreData && SmartRefreshLayout.this.mFooterNoMoreDataEffective)) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.PullUpToLoad);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.PullUpToLoad);
                    break;
                }
                case PullDownCanceled: {
                    if (!SmartRefreshLayout.this.mState.isOpening && SmartRefreshLayout.this.isEnableRefreshOrLoadMore(SmartRefreshLayout.this.mEnableRefresh)) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.PullDownCanceled);
                        this.setState(RefreshState.None);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.PullDownCanceled);
                    break;
                }
                case PullUpCanceled: {
                    if (!(!SmartRefreshLayout.this.isEnableRefreshOrLoadMore(SmartRefreshLayout.this.mEnableLoadMore) || SmartRefreshLayout.this.mState.isOpening || SmartRefreshLayout.this.mFooterNoMoreData && SmartRefreshLayout.this.mEnableFooterFollowWhenNoMoreData && SmartRefreshLayout.this.mFooterNoMoreDataEffective)) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.PullUpCanceled);
                        this.setState(RefreshState.None);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.PullUpCanceled);
                    break;
                }
                case ReleaseToRefresh: {
                    if (!SmartRefreshLayout.this.mState.isOpening && SmartRefreshLayout.this.isEnableRefreshOrLoadMore(SmartRefreshLayout.this.mEnableRefresh)) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.ReleaseToRefresh);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.ReleaseToRefresh);
                    break;
                }
                case ReleaseToLoad: {
                    if (!(!SmartRefreshLayout.this.isEnableRefreshOrLoadMore(SmartRefreshLayout.this.mEnableLoadMore) || SmartRefreshLayout.this.mState.isOpening || SmartRefreshLayout.this.mState.isFinishing || SmartRefreshLayout.this.mFooterNoMoreData && SmartRefreshLayout.this.mEnableFooterFollowWhenNoMoreData && SmartRefreshLayout.this.mFooterNoMoreDataEffective)) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.ReleaseToLoad);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.ReleaseToLoad);
                    break;
                }
                case ReleaseToTwoLevel: {
                    if (!SmartRefreshLayout.this.mState.isOpening && SmartRefreshLayout.this.isEnableRefreshOrLoadMore(SmartRefreshLayout.this.mEnableRefresh)) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.ReleaseToTwoLevel);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.ReleaseToTwoLevel);
                    break;
                }
                case RefreshReleased: {
                    if (!SmartRefreshLayout.this.mState.isOpening && SmartRefreshLayout.this.isEnableRefreshOrLoadMore(SmartRefreshLayout.this.mEnableRefresh)) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.RefreshReleased);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.RefreshReleased);
                    break;
                }
                case LoadReleased: {
                    if (!SmartRefreshLayout.this.mState.isOpening && SmartRefreshLayout.this.isEnableRefreshOrLoadMore(SmartRefreshLayout.this.mEnableLoadMore)) {
                        SmartRefreshLayout.this.notifyStateChanged(RefreshState.LoadReleased);
                        break;
                    }
                    SmartRefreshLayout.this.setViceState(RefreshState.LoadReleased);
                    break;
                }
                case Refreshing: {
                    SmartRefreshLayout.this.setStateRefreshing(true);
                    break;
                }
                case Loading: {
                    SmartRefreshLayout.this.setStateLoading(true);
                    break;
                }
                default: {
                    SmartRefreshLayout.this.notifyStateChanged(state);
                }
            }
            return null;
        }

        @Override
        public RefreshKernel startTwoLevel(boolean open) {
            if (open) {
                AnimatorListenerAdapter listener = new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        if (animation != null && animation.getDuration() == 0L) {
                            return;
                        }
                        SmartRefreshLayout.this.mKernel.setState(RefreshState.TwoLevel);
                    }
                };
                SmartRefreshLayout thisView = SmartRefreshLayout.this;
                ValueAnimator animator = this.animSpinner(thisView.getMeasuredHeight());
                if (animator != null && animator == SmartRefreshLayout.this.reboundAnimator) {
                    animator.setDuration((long)SmartRefreshLayout.this.mFloorDuration);
                    animator.addListener((Animator.AnimatorListener)listener);
                } else {
                    listener.onAnimationEnd(null);
                }
            } else if (this.animSpinner(0) == null) {
                SmartRefreshLayout.this.notifyStateChanged(RefreshState.None);
            }
            return this;
        }

        @Override
        public RefreshKernel finishTwoLevel() {
            if (SmartRefreshLayout.this.mState == RefreshState.TwoLevel) {
                SmartRefreshLayout.this.mKernel.setState(RefreshState.TwoLevelFinish);
                if (SmartRefreshLayout.this.mSpinner == 0) {
                    this.moveSpinner(0, false);
                    SmartRefreshLayout.this.notifyStateChanged(RefreshState.None);
                } else {
                    this.animSpinner(0).setDuration((long)SmartRefreshLayout.this.mFloorDuration);
                }
            }
            return this;
        }

        @Override
        public RefreshKernel moveSpinner(int spinner, boolean isDragging) {
            int left;
            int widthSpec;
            ViewGroup.MarginLayoutParams mlp;
            ViewGroup.LayoutParams lp;
            int maxDragHeight;
            int offset;
            if (!(SmartRefreshLayout.this.mSpinner != spinner || SmartRefreshLayout.this.mRefreshHeader != null && SmartRefreshLayout.this.mRefreshHeader.isSupportHorizontalDrag() || SmartRefreshLayout.this.mRefreshFooter != null && SmartRefreshLayout.this.mRefreshFooter.isSupportHorizontalDrag())) {
                return this;
            }
            SmartRefreshLayout thisView = SmartRefreshLayout.this;
            int oldSpinner = SmartRefreshLayout.this.mSpinner;
            SmartRefreshLayout.this.mSpinner = spinner;
            if (isDragging && (SmartRefreshLayout.this.mViceState.isDragging || SmartRefreshLayout.this.mViceState.isOpening)) {
                float f = SmartRefreshLayout.this.mSpinner;
                float f2 = SmartRefreshLayout.this.mHeaderTriggerRate < 10.0f ? (float)SmartRefreshLayout.this.mHeaderHeight * SmartRefreshLayout.this.mHeaderTriggerRate : SmartRefreshLayout.this.mHeaderTriggerRate;
                if (f > f2) {
                    if (SmartRefreshLayout.this.mState != RefreshState.ReleaseToTwoLevel) {
                        SmartRefreshLayout.this.mKernel.setState(RefreshState.ReleaseToRefresh);
                    }
                } else {
                    float f3 = -SmartRefreshLayout.this.mSpinner;
                    float f4 = SmartRefreshLayout.this.mFooterTriggerRate < 10.0f ? (float)SmartRefreshLayout.this.mFooterHeight * SmartRefreshLayout.this.mFooterTriggerRate : SmartRefreshLayout.this.mFooterTriggerRate;
                    if (f3 > f4 && !SmartRefreshLayout.this.mFooterNoMoreData) {
                        SmartRefreshLayout.this.mKernel.setState(RefreshState.ReleaseToLoad);
                    } else if (SmartRefreshLayout.this.mSpinner < 0 && !SmartRefreshLayout.this.mFooterNoMoreData) {
                        SmartRefreshLayout.this.mKernel.setState(RefreshState.PullUpToLoad);
                    } else if (SmartRefreshLayout.this.mSpinner > 0) {
                        SmartRefreshLayout.this.mKernel.setState(RefreshState.PullDownToRefresh);
                    }
                }
            }
            if (SmartRefreshLayout.this.mRefreshContent != null) {
                int tSpinner = 0;
                boolean changed = false;
                if (spinner >= 0) {
                    if (SmartRefreshLayout.this.isEnableTranslationContent(SmartRefreshLayout.this.mEnableHeaderTranslationContent, SmartRefreshLayout.this.mRefreshHeader)) {
                        changed = true;
                        tSpinner = spinner;
                    } else if (oldSpinner < 0) {
                        changed = true;
                        tSpinner = 0;
                    }
                }
                if (spinner <= 0) {
                    if (SmartRefreshLayout.this.isEnableTranslationContent(SmartRefreshLayout.this.mEnableFooterTranslationContent, SmartRefreshLayout.this.mRefreshFooter)) {
                        changed = true;
                        tSpinner = spinner;
                    } else if (oldSpinner > 0) {
                        changed = true;
                        tSpinner = 0;
                    }
                }
                if (changed) {
                    SmartRefreshLayout.this.mRefreshContent.moveSpinner(tSpinner, SmartRefreshLayout.this.mHeaderTranslationViewId, SmartRefreshLayout.this.mFooterTranslationViewId);
                    if (SmartRefreshLayout.this.mFooterNoMoreData && SmartRefreshLayout.this.mFooterNoMoreDataEffective && SmartRefreshLayout.this.mEnableFooterFollowWhenNoMoreData && SmartRefreshLayout.this.mRefreshFooter instanceof RefreshFooter && SmartRefreshLayout.this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.Translate && SmartRefreshLayout.this.isEnableRefreshOrLoadMore(SmartRefreshLayout.this.mEnableLoadMore)) {
                        SmartRefreshLayout.this.mRefreshFooter.getView().setTranslationY((float)Math.max(0, tSpinner));
                    }
                    boolean header = SmartRefreshLayout.this.mEnableClipHeaderWhenFixedBehind && SmartRefreshLayout.this.mRefreshHeader != null && SmartRefreshLayout.this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.FixedBehind;
                    header = header || SmartRefreshLayout.this.mHeaderBackgroundColor != 0;
                    boolean footer = SmartRefreshLayout.this.mEnableClipFooterWhenFixedBehind && SmartRefreshLayout.this.mRefreshFooter != null && SmartRefreshLayout.this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.FixedBehind;
                    boolean bl = footer = footer || SmartRefreshLayout.this.mFooterBackgroundColor != 0;
                    if (header && (tSpinner >= 0 || oldSpinner > 0) || footer && (tSpinner <= 0 || oldSpinner < 0)) {
                        thisView.invalidate();
                    }
                }
            }
            if ((spinner >= 0 || oldSpinner > 0) && SmartRefreshLayout.this.mRefreshHeader != null) {
                offset = Math.max(spinner, 0);
                int headerHeight = SmartRefreshLayout.this.mHeaderHeight;
                maxDragHeight = (int)(SmartRefreshLayout.this.mHeaderMaxDragRate < 10.0f ? (float)SmartRefreshLayout.this.mHeaderHeight * SmartRefreshLayout.this.mHeaderMaxDragRate : SmartRefreshLayout.this.mHeaderMaxDragRate);
                float percent = 1.0f * (float)offset / (SmartRefreshLayout.this.mHeaderTriggerRate < 10.0f ? SmartRefreshLayout.this.mHeaderTriggerRate * (float)SmartRefreshLayout.this.mHeaderHeight : SmartRefreshLayout.this.mHeaderTriggerRate);
                if (SmartRefreshLayout.this.isEnableRefreshOrLoadMore(SmartRefreshLayout.this.mEnableRefresh) || SmartRefreshLayout.this.mState == RefreshState.RefreshFinish && !isDragging) {
                    if (oldSpinner != SmartRefreshLayout.this.mSpinner) {
                        if (SmartRefreshLayout.this.mRefreshHeader.getSpinnerStyle() == SpinnerStyle.Translate) {
                            SmartRefreshLayout.this.mRefreshHeader.getView().setTranslationY((float)SmartRefreshLayout.this.mSpinner);
                            if (SmartRefreshLayout.this.mHeaderBackgroundColor != 0 && SmartRefreshLayout.this.mPaint != null && !SmartRefreshLayout.this.isEnableTranslationContent(SmartRefreshLayout.this.mEnableHeaderTranslationContent, SmartRefreshLayout.this.mRefreshHeader)) {
                                thisView.invalidate();
                            }
                        } else if (SmartRefreshLayout.this.mRefreshHeader.getSpinnerStyle().scale) {
                            View headerView = SmartRefreshLayout.this.mRefreshHeader.getView();
                            lp = headerView.getLayoutParams();
                            mlp = lp instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)lp : sDefaultMarginLP;
                            widthSpec = View.MeasureSpec.makeMeasureSpec((int)headerView.getMeasuredWidth(), (int)0x40000000);
                            headerView.measure(widthSpec, View.MeasureSpec.makeMeasureSpec((int)Math.max(SmartRefreshLayout.this.mSpinner - mlp.bottomMargin - mlp.topMargin, 0), (int)0x40000000));
                            left = mlp.leftMargin;
                            int top = mlp.topMargin + SmartRefreshLayout.this.mHeaderInsetStart;
                            headerView.layout(left, top, left + headerView.getMeasuredWidth(), top + headerView.getMeasuredHeight());
                        }
                        SmartRefreshLayout.this.mRefreshHeader.onMoving(isDragging, percent, offset, headerHeight, maxDragHeight);
                    }
                    if (isDragging && SmartRefreshLayout.this.mRefreshHeader.isSupportHorizontalDrag()) {
                        int offsetX = (int)SmartRefreshLayout.this.mLastTouchX;
                        int offsetMax = thisView.getWidth();
                        float percentX = SmartRefreshLayout.this.mLastTouchX / (float)(offsetMax == 0 ? 1 : offsetMax);
                        SmartRefreshLayout.this.mRefreshHeader.onHorizontalDrag(percentX, offsetX, offsetMax);
                    }
                }
                if (oldSpinner != SmartRefreshLayout.this.mSpinner && SmartRefreshLayout.this.mOnMultiListener != null && SmartRefreshLayout.this.mRefreshHeader instanceof RefreshHeader) {
                    SmartRefreshLayout.this.mOnMultiListener.onHeaderMoving((RefreshHeader)SmartRefreshLayout.this.mRefreshHeader, isDragging, percent, offset, headerHeight, maxDragHeight);
                }
            }
            if ((spinner <= 0 || oldSpinner < 0) && SmartRefreshLayout.this.mRefreshFooter != null) {
                offset = -Math.min(spinner, 0);
                int footerHeight = SmartRefreshLayout.this.mFooterHeight;
                maxDragHeight = (int)(SmartRefreshLayout.this.mFooterMaxDragRate < 10.0f ? (float)SmartRefreshLayout.this.mFooterHeight * SmartRefreshLayout.this.mFooterMaxDragRate : SmartRefreshLayout.this.mFooterMaxDragRate);
                float percent = (float)offset * 1.0f / (SmartRefreshLayout.this.mFooterTriggerRate < 10.0f ? SmartRefreshLayout.this.mFooterTriggerRate * (float)SmartRefreshLayout.this.mFooterHeight : SmartRefreshLayout.this.mFooterTriggerRate);
                if (SmartRefreshLayout.this.isEnableRefreshOrLoadMore(SmartRefreshLayout.this.mEnableLoadMore) || SmartRefreshLayout.this.mState == RefreshState.LoadFinish && !isDragging) {
                    if (oldSpinner != SmartRefreshLayout.this.mSpinner) {
                        if (SmartRefreshLayout.this.mRefreshFooter.getSpinnerStyle() == SpinnerStyle.Translate) {
                            SmartRefreshLayout.this.mRefreshFooter.getView().setTranslationY((float)SmartRefreshLayout.this.mSpinner);
                            if (SmartRefreshLayout.this.mFooterBackgroundColor != 0 && SmartRefreshLayout.this.mPaint != null && !SmartRefreshLayout.this.isEnableTranslationContent(SmartRefreshLayout.this.mEnableFooterTranslationContent, SmartRefreshLayout.this.mRefreshFooter)) {
                                thisView.invalidate();
                            }
                        } else if (SmartRefreshLayout.this.mRefreshFooter.getSpinnerStyle().scale) {
                            View footerView = SmartRefreshLayout.this.mRefreshFooter.getView();
                            lp = footerView.getLayoutParams();
                            mlp = lp instanceof ViewGroup.MarginLayoutParams ? (ViewGroup.MarginLayoutParams)lp : sDefaultMarginLP;
                            widthSpec = View.MeasureSpec.makeMeasureSpec((int)footerView.getMeasuredWidth(), (int)0x40000000);
                            footerView.measure(widthSpec, View.MeasureSpec.makeMeasureSpec((int)Math.max(-SmartRefreshLayout.this.mSpinner - mlp.bottomMargin - mlp.topMargin, 0), (int)0x40000000));
                            left = mlp.leftMargin;
                            int bottom = mlp.topMargin + thisView.getMeasuredHeight() - SmartRefreshLayout.this.mFooterInsetStart;
                            footerView.layout(left, bottom - footerView.getMeasuredHeight(), left + footerView.getMeasuredWidth(), bottom);
                        }
                        SmartRefreshLayout.this.mRefreshFooter.onMoving(isDragging, percent, offset, footerHeight, maxDragHeight);
                    }
                    if (isDragging && SmartRefreshLayout.this.mRefreshFooter.isSupportHorizontalDrag()) {
                        int offsetX = (int)SmartRefreshLayout.this.mLastTouchX;
                        int offsetMax = thisView.getWidth();
                        float percentX = SmartRefreshLayout.this.mLastTouchX / (float)(offsetMax == 0 ? 1 : offsetMax);
                        SmartRefreshLayout.this.mRefreshFooter.onHorizontalDrag(percentX, offsetX, offsetMax);
                    }
                }
                if (oldSpinner != SmartRefreshLayout.this.mSpinner && SmartRefreshLayout.this.mOnMultiListener != null && SmartRefreshLayout.this.mRefreshFooter instanceof RefreshFooter) {
                    SmartRefreshLayout.this.mOnMultiListener.onFooterMoving((RefreshFooter)SmartRefreshLayout.this.mRefreshFooter, isDragging, percent, offset, footerHeight, maxDragHeight);
                }
            }
            return this;
        }

        @Override
        public ValueAnimator animSpinner(int endSpinner) {
            return SmartRefreshLayout.this.animSpinner(endSpinner, 0, SmartRefreshLayout.this.mReboundInterpolator, SmartRefreshLayout.this.mReboundDuration);
        }

        @Override
        public RefreshKernel requestDrawBackgroundFor(@NonNull RefreshComponent internal, int backgroundColor) {
            if (SmartRefreshLayout.this.mPaint == null && backgroundColor != 0) {
                SmartRefreshLayout.this.mPaint = new Paint();
            }
            if (internal.equals(SmartRefreshLayout.this.mRefreshHeader)) {
                SmartRefreshLayout.this.mHeaderBackgroundColor = backgroundColor;
            } else if (internal.equals(SmartRefreshLayout.this.mRefreshFooter)) {
                SmartRefreshLayout.this.mFooterBackgroundColor = backgroundColor;
            }
            return this;
        }

        @Override
        public RefreshKernel requestNeedTouchEventFor(@NonNull RefreshComponent internal, boolean request) {
            if (internal.equals(SmartRefreshLayout.this.mRefreshHeader)) {
                SmartRefreshLayout.this.mHeaderNeedTouchEventWhenRefreshing = request;
            } else if (internal.equals(SmartRefreshLayout.this.mRefreshFooter)) {
                SmartRefreshLayout.this.mFooterNeedTouchEventWhenLoading = request;
            }
            return this;
        }

        @Override
        public RefreshKernel requestDefaultTranslationContentFor(@NonNull RefreshComponent internal, boolean translation) {
            if (internal.equals(SmartRefreshLayout.this.mRefreshHeader)) {
                if (!SmartRefreshLayout.this.mManualHeaderTranslationContent) {
                    SmartRefreshLayout.this.mManualHeaderTranslationContent = true;
                    SmartRefreshLayout.this.mEnableHeaderTranslationContent = translation;
                }
            } else if (internal.equals(SmartRefreshLayout.this.mRefreshFooter) && !SmartRefreshLayout.this.mManualFooterTranslationContent) {
                SmartRefreshLayout.this.mManualFooterTranslationContent = true;
                SmartRefreshLayout.this.mEnableFooterTranslationContent = translation;
            }
            return this;
        }

        @Override
        public RefreshKernel requestRemeasureHeightFor(@NonNull RefreshComponent internal) {
            if (internal.equals(SmartRefreshLayout.this.mRefreshHeader)) {
                if (SmartRefreshLayout.this.mHeaderHeightStatus.notified) {
                    SmartRefreshLayout.this.mHeaderHeightStatus = SmartRefreshLayout.this.mHeaderHeightStatus.unNotify();
                }
            } else if (internal.equals(SmartRefreshLayout.this.mRefreshFooter) && SmartRefreshLayout.this.mFooterHeightStatus.notified) {
                SmartRefreshLayout.this.mFooterHeightStatus = SmartRefreshLayout.this.mFooterHeightStatus.unNotify();
            }
            return this;
        }

        @Override
        public RefreshKernel requestFloorDuration(int duration) {
            SmartRefreshLayout.this.mFloorDuration = duration;
            return this;
        }

        @Override
        public RefreshKernel requestFloorBottomPullUpToCloseRate(float rate) {
            SmartRefreshLayout.this.mTwoLevelBottomPullUpToCloseRate = rate;
            return this;
        }

        @Override
        public RefreshKernel onAutoRefreshAnimationEnd(Animator animation, boolean animationOnly) {
            if (animation != null && animation.getDuration() == 0L) {
                return this;
            }
            SmartRefreshLayout.this.reboundAnimator = null;
            if (SmartRefreshLayout.this.mState != RefreshState.ReleaseToRefresh) {
                this.setState(RefreshState.ReleaseToRefresh);
            }
            SmartRefreshLayout.this.setStateRefreshing(!animationOnly);
            return this;
        }

        @Override
        public RefreshKernel onAutoLoadMoreAnimationEnd(Animator animation, boolean animationOnly) {
            if (animation != null && animation.getDuration() == 0L) {
                return this;
            }
            SmartRefreshLayout.this.reboundAnimator = null;
            if (SmartRefreshLayout.this.mRefreshFooter != null) {
                if (SmartRefreshLayout.this.mState != RefreshState.ReleaseToLoad) {
                    this.setState(RefreshState.ReleaseToLoad);
                }
                SmartRefreshLayout.this.setStateLoading(!animationOnly);
            } else {
                this.setState(RefreshState.None);
            }
            return this;
        }
    }

    public static class LayoutParams
    extends ViewGroup.MarginLayoutParams {
        public int backgroundColor = 0;
        public SpinnerStyle spinnerStyle = null;

        public LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.SmartRefreshLayout_Layout);
            this.backgroundColor = ta.getColor(R.styleable.SmartRefreshLayout_Layout_layout_srlBackgroundColor, this.backgroundColor);
            if (ta.hasValue(R.styleable.SmartRefreshLayout_Layout_layout_srlSpinnerStyle)) {
                this.spinnerStyle = SpinnerStyle.values[ta.getInt(R.styleable.SmartRefreshLayout_Layout_layout_srlSpinnerStyle, SpinnerStyle.Translate.ordinal)];
            }
            ta.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }
    }

    protected class BounceRunnable
    implements Runnable {
        int mFrame = 0;
        int mFrameDelay = 10;
        int mSmoothDistance;
        long mLastTime;
        float mOffset = 0.0f;
        float mVelocity;

        BounceRunnable(float velocity, int smoothDistance) {
            this.mVelocity = velocity;
            this.mSmoothDistance = smoothDistance;
            this.mLastTime = AnimationUtils.currentAnimationTimeMillis();
            SmartRefreshLayout.this.mHandler.postDelayed((Runnable)this, (long)this.mFrameDelay);
            if (velocity > 0.0f) {
                SmartRefreshLayout.this.mKernel.setState(RefreshState.PullDownToRefresh);
            } else {
                SmartRefreshLayout.this.mKernel.setState(RefreshState.PullUpToLoad);
            }
        }

        @Override
        public void run() {
            if (SmartRefreshLayout.this.animationRunnable == this && !SmartRefreshLayout.this.mState.isFinishing) {
                this.mVelocity = Math.abs(SmartRefreshLayout.this.mSpinner) >= Math.abs(this.mSmoothDistance) ? (this.mSmoothDistance != 0 ? (float)((double)this.mVelocity * Math.pow(0.45f, ++this.mFrame * 2)) : (float)((double)this.mVelocity * Math.pow(0.85f, ++this.mFrame * 2))) : (float)((double)this.mVelocity * Math.pow(0.95f, ++this.mFrame * 2));
                long now = AnimationUtils.currentAnimationTimeMillis();
                float t = 1.0f * (float)(now - this.mLastTime) / 1000.0f;
                float velocity = this.mVelocity * t;
                if (Math.abs(velocity) >= 1.0f) {
                    this.mLastTime = now;
                    this.mOffset += velocity;
                    SmartRefreshLayout.this.moveSpinnerInfinitely(this.mOffset);
                    SmartRefreshLayout.this.mHandler.postDelayed((Runnable)this, (long)this.mFrameDelay);
                } else {
                    if (SmartRefreshLayout.this.mViceState.isDragging && SmartRefreshLayout.this.mViceState.isHeader) {
                        SmartRefreshLayout.this.mKernel.setState(RefreshState.PullDownCanceled);
                    } else if (SmartRefreshLayout.this.mViceState.isDragging && SmartRefreshLayout.this.mViceState.isFooter) {
                        SmartRefreshLayout.this.mKernel.setState(RefreshState.PullUpCanceled);
                    }
                    SmartRefreshLayout.this.animationRunnable = null;
                    if (Math.abs(SmartRefreshLayout.this.mSpinner) >= Math.abs(this.mSmoothDistance)) {
                        int duration = 10 * Math.min(Math.max((int)SmartUtil.px2dp(Math.abs(SmartRefreshLayout.this.mSpinner - this.mSmoothDistance)), 30), 100);
                        SmartRefreshLayout.this.animSpinner(this.mSmoothDistance, 0, SmartRefreshLayout.this.mReboundInterpolator, duration);
                    }
                }
            }
        }
    }

    protected class FlingRunnable
    implements Runnable {
        int mOffset;
        int mFrame = 0;
        int mFrameDelay = 10;
        float mVelocity;
        float mDamping = 0.98f;
        long mStartTime = 0L;
        long mLastTime = AnimationUtils.currentAnimationTimeMillis();

        FlingRunnable(float velocity) {
            this.mVelocity = velocity;
            this.mOffset = SmartRefreshLayout.this.mSpinner;
        }

        public Runnable start() {
            if (SmartRefreshLayout.this.mState.isFinishing) {
                return null;
            }
            if (SmartRefreshLayout.this.mSpinner != 0 && (!SmartRefreshLayout.this.mState.isOpening && (!SmartRefreshLayout.this.mFooterNoMoreData || !SmartRefreshLayout.this.mEnableFooterFollowWhenNoMoreData || !SmartRefreshLayout.this.mFooterNoMoreDataEffective || !SmartRefreshLayout.this.isEnableRefreshOrLoadMore(SmartRefreshLayout.this.mEnableLoadMore)) || (SmartRefreshLayout.this.mState == RefreshState.Loading || SmartRefreshLayout.this.mFooterNoMoreData && SmartRefreshLayout.this.mEnableFooterFollowWhenNoMoreData && SmartRefreshLayout.this.mFooterNoMoreDataEffective && SmartRefreshLayout.this.isEnableRefreshOrLoadMore(SmartRefreshLayout.this.mEnableLoadMore)) && SmartRefreshLayout.this.mSpinner < -SmartRefreshLayout.this.mFooterHeight || SmartRefreshLayout.this.mState == RefreshState.Refreshing && SmartRefreshLayout.this.mSpinner > SmartRefreshLayout.this.mHeaderHeight)) {
                int frame = 0;
                int offset = SmartRefreshLayout.this.mSpinner;
                int spinner = SmartRefreshLayout.this.mSpinner;
                float velocity = this.mVelocity;
                while (spinner * offset > 0) {
                    float velocityFrame;
                    if (Math.abs(velocityFrame = (velocity = (float)((double)velocity * Math.pow(this.mDamping, (float)(++frame * this.mFrameDelay) / 10.0f))) * (1.0f * (float)this.mFrameDelay / 1000.0f)) < 1.0f) {
                        if (SmartRefreshLayout.this.mState.isOpening && (SmartRefreshLayout.this.mState != RefreshState.Refreshing || offset <= SmartRefreshLayout.this.mHeaderHeight) && (SmartRefreshLayout.this.mState == RefreshState.Refreshing || offset >= -SmartRefreshLayout.this.mFooterHeight)) break;
                        return null;
                    }
                    offset = (int)((float)offset + velocityFrame);
                }
            }
            this.mStartTime = AnimationUtils.currentAnimationTimeMillis();
            SmartRefreshLayout.this.mHandler.postDelayed((Runnable)this, (long)this.mFrameDelay);
            return this;
        }

        @Override
        public void run() {
            if (SmartRefreshLayout.this.animationRunnable == this && !SmartRefreshLayout.this.mState.isFinishing) {
                long now = AnimationUtils.currentAnimationTimeMillis();
                long span = now - this.mLastTime;
                this.mVelocity = (float)((double)this.mVelocity * Math.pow(this.mDamping, (float)(now - this.mStartTime) / (1000.0f / (float)this.mFrameDelay)));
                float velocity = this.mVelocity * (1.0f * (float)span / 1000.0f);
                if (Math.abs(velocity) > 1.0f) {
                    this.mLastTime = now;
                    this.mOffset = (int)((float)this.mOffset + velocity);
                    if (SmartRefreshLayout.this.mSpinner * this.mOffset > 0) {
                        SmartRefreshLayout.this.mKernel.moveSpinner(this.mOffset, true);
                        SmartRefreshLayout.this.mHandler.postDelayed((Runnable)this, (long)this.mFrameDelay);
                    } else {
                        SmartRefreshLayout.this.animationRunnable = null;
                        SmartRefreshLayout.this.mKernel.moveSpinner(0, true);
                        SmartUtil.fling(SmartRefreshLayout.this.mRefreshContent.getScrollableView(), (int)(-this.mVelocity));
                        if (SmartRefreshLayout.this.mFooterLocked && velocity > 0.0f) {
                            SmartRefreshLayout.this.mFooterLocked = false;
                        }
                    }
                } else {
                    SmartRefreshLayout.this.animationRunnable = null;
                }
            }
        }
    }
}

