/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.httpclient.okhttp;

import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequestAsync;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.httpclient.okhttp.OAuthAsyncCompletionHandler;
import com.github.scribejava.httpclient.okhttp.OkHttpFuture;
import com.github.scribejava.httpclient.okhttp.OkHttpHttpClientConfig;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Future;
import okhttp3.Cache;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.internal.http.HttpMethod;

public class OkHttpHttpClient
implements HttpClient {
    private static final MediaType DEFAULT_CONTENT_TYPE_MEDIA_TYPE = MediaType.parse((String)"application/x-www-form-urlencoded");
    private final OkHttpClient client;

    public OkHttpHttpClient(OkHttpHttpClientConfig config) {
        OkHttpClient.Builder clientBuilder = config.getClientBuilder();
        this.client = clientBuilder == null ? new OkHttpClient() : clientBuilder.build();
    }

    public OkHttpHttpClient(OkHttpClient client) {
        this.client = client;
    }

    public void close() throws IOException {
        this.client.dispatcher().executorService().shutdown();
        this.client.connectionPool().evictAll();
        Cache cache = this.client.cache();
        if (cache != null) {
            cache.close();
        }
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, byte[] bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodyType.BYTE_ARRAY, bodyContents, callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodyType.STRING, bodyContents, callback, converter);
    }

    public <T> Future<T> executeAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, File bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        return this.doExecuteAsync(userAgent, headers, httpVerb, completeUrl, BodyType.FILE, bodyContents, callback, converter);
    }

    private <T> Future<T> doExecuteAsync(String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, BodyType bodyType, Object bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        RequestBody body;
        Request.Builder requestBuilder = new Request.Builder();
        requestBuilder.url(completeUrl);
        String method = httpVerb.name();
        if (bodyContents != null && HttpMethod.permitsRequestBody((String)method)) {
            MediaType mediaType = headers.containsKey("Content-Type") ? MediaType.parse((String)headers.get("Content-Type")) : DEFAULT_CONTENT_TYPE_MEDIA_TYPE;
            body = bodyType.createBody(mediaType, bodyContents);
        } else {
            body = null;
        }
        requestBuilder.method(method, body);
        for (Map.Entry entry : headers.entrySet()) {
            requestBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        if (userAgent != null) {
            requestBuilder.header("User-Agent", userAgent);
        }
        Call call = this.client.newCall(requestBuilder.build());
        OkHttpFuture okHttpFuture = new OkHttpFuture(call);
        call.enqueue(new OAuthAsyncCompletionHandler<T>(callback, converter, okHttpFuture));
        return okHttpFuture;
    }

    private static enum BodyType {
        BYTE_ARRAY{

            @Override
            RequestBody createBody(MediaType mediaType, Object bodyContents) {
                return RequestBody.create((MediaType)mediaType, (byte[])((byte[])bodyContents));
            }
        }
        ,
        STRING{

            @Override
            RequestBody createBody(MediaType mediaType, Object bodyContents) {
                return RequestBody.create((MediaType)mediaType, (String)((String)bodyContents));
            }
        }
        ,
        FILE{

            @Override
            RequestBody createBody(MediaType mediaType, Object bodyContents) {
                return RequestBody.create((MediaType)mediaType, (File)((File)bodyContents));
            }
        };


        abstract RequestBody createBody(MediaType var1, Object var2);
    }
}

