/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.builder.api.OAuth1SignatureType;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.OAuth1AccessToken;
import com.github.scribejava.core.model.OAuth1RequestToken;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.oauth.OAuthService;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class OAuth10aService
extends OAuthService {
    private static final String VERSION = "1.0";
    private final DefaultApi10a api;
    private final String scope;

    public OAuth10aService(DefaultApi10a api, String apiKey, String apiSecret, String callback, String scope, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        super(apiKey, apiSecret, callback, debugStream, userAgent, httpClientConfig, httpClient);
        this.api = api;
        this.scope = scope;
    }

    public OAuth1RequestToken getRequestToken() throws IOException, InterruptedException, ExecutionException {
        if (this.isDebug()) {
            this.log("obtaining request token from %s", this.api.getRequestTokenEndpoint());
        }
        OAuthRequest request = this.prepareRequestTokenRequest();
        this.log("sending request...");
        Response response = this.execute(request);
        if (this.isDebug()) {
            String body = response.getBody();
            this.log("response status code: %s", response.getCode());
            this.log("response body: %s", body);
        }
        return this.api.getRequestTokenExtractor().extract(response);
    }

    public Future<OAuth1RequestToken> getRequestTokenAsync() {
        return this.getRequestTokenAsync(null);
    }

    public Future<OAuth1RequestToken> getRequestTokenAsync(OAuthAsyncRequestCallback<OAuth1RequestToken> callback) {
        if (this.isDebug()) {
            this.log("async obtaining request token from %s", this.api.getRequestTokenEndpoint());
        }
        OAuthRequest request = this.prepareRequestTokenRequest();
        return this.execute(request, callback, new OAuthRequest.ResponseConverter<OAuth1RequestToken>(){

            @Override
            public OAuth1RequestToken convert(Response response) throws IOException {
                return OAuth10aService.this.getApi().getRequestTokenExtractor().extract(response);
            }
        });
    }

    protected OAuthRequest prepareRequestTokenRequest() {
        OAuthRequest request = new OAuthRequest(this.api.getRequestTokenVerb(), this.api.getRequestTokenEndpoint());
        String callback = this.getCallback();
        if (callback == null) {
            callback = "oob";
        }
        if (this.isDebug()) {
            this.log("setting oauth_callback to %s", callback);
        }
        request.addOAuthParameter("oauth_callback", callback);
        this.addOAuthParams(request, "");
        this.appendSignature(request);
        return request;
    }

    protected void addOAuthParams(OAuthRequest request, String tokenSecret) {
        request.addOAuthParameter("oauth_timestamp", this.api.getTimestampService().getTimestampInSeconds());
        request.addOAuthParameter("oauth_nonce", this.api.getTimestampService().getNonce());
        request.addOAuthParameter("oauth_consumer_key", this.getApiKey());
        request.addOAuthParameter("oauth_signature_method", this.api.getSignatureService().getSignatureMethod());
        request.addOAuthParameter("oauth_version", this.getVersion());
        if (this.scope != null) {
            request.addOAuthParameter("scope", this.scope);
        }
        request.addOAuthParameter("oauth_signature", this.getSignature(request, tokenSecret));
        if (this.isDebug()) {
            this.log("appended additional OAuth parameters: %s", request.getOauthParameters());
        }
    }

    public OAuth1AccessToken getAccessToken(OAuth1RequestToken requestToken, String oauthVerifier) throws IOException, InterruptedException, ExecutionException {
        if (this.isDebug()) {
            this.log("obtaining access token from %s", this.api.getAccessTokenEndpoint());
        }
        OAuthRequest request = this.prepareAccessTokenRequest(requestToken, oauthVerifier);
        Response response = this.execute(request);
        return this.api.getAccessTokenExtractor().extract(response);
    }

    public Future<OAuth1AccessToken> getAccessTokenAsync(OAuth1RequestToken requestToken, String oauthVerifier) {
        return this.getAccessTokenAsync(requestToken, oauthVerifier, null);
    }

    public Future<OAuth1AccessToken> getAccessTokenAsync(OAuth1RequestToken requestToken, String oauthVerifier, OAuthAsyncRequestCallback<OAuth1AccessToken> callback) {
        if (this.isDebug()) {
            this.log("async obtaining access token from %s", this.api.getAccessTokenEndpoint());
        }
        OAuthRequest request = this.prepareAccessTokenRequest(requestToken, oauthVerifier);
        return this.execute(request, callback, new OAuthRequest.ResponseConverter<OAuth1AccessToken>(){

            @Override
            public OAuth1AccessToken convert(Response response) throws IOException {
                return OAuth10aService.this.getApi().getAccessTokenExtractor().extract(response);
            }
        });
    }

    protected OAuthRequest prepareAccessTokenRequest(OAuth1RequestToken requestToken, String oauthVerifier) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        request.addOAuthParameter("oauth_token", requestToken.getToken());
        request.addOAuthParameter("oauth_verifier", oauthVerifier);
        if (this.isDebug()) {
            this.log("setting token to: %s and verifier to: %s", requestToken, oauthVerifier);
        }
        this.addOAuthParams(request, requestToken.getTokenSecret());
        this.appendSignature(request);
        return request;
    }

    public void signRequest(OAuth1AccessToken token, OAuthRequest request) {
        if (this.isDebug()) {
            this.log("signing request: %s", request.getCompleteUrl());
        }
        if (!token.isEmpty() || this.api.isEmptyOAuthTokenParamIsRequired()) {
            request.addOAuthParameter("oauth_token", token.getToken());
        }
        if (this.isDebug()) {
            this.log("setting token to: %s", token);
        }
        this.addOAuthParams(request, token.getTokenSecret());
        this.appendSignature(request);
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public String getAuthorizationUrl(OAuth1RequestToken requestToken) {
        return this.api.getAuthorizationUrl(requestToken);
    }

    private String getSignature(OAuthRequest request, String tokenSecret) {
        this.log("generating signature...");
        String baseString = this.api.getBaseStringExtractor().extract(request);
        String signature = this.api.getSignatureService().getSignature(baseString, this.getApiSecret(), tokenSecret);
        if (this.isDebug()) {
            this.log("base string is: %s", baseString);
            this.log("signature is: %s", signature);
        }
        return signature;
    }

    protected void appendSignature(OAuthRequest request) {
        OAuth1SignatureType signatureType = this.api.getSignatureType();
        switch (signatureType) {
            case HEADER: {
                this.log("using Http Header signature");
                String oauthHeader = this.api.getHeaderExtractor().extract(request);
                request.addHeader("Authorization", oauthHeader);
                break;
            }
            case QUERY_STRING: {
                this.log("using Querystring signature");
                for (Map.Entry<String, String> oauthParameter : request.getOauthParameters().entrySet()) {
                    request.addQuerystringParameter(oauthParameter.getKey(), oauthParameter.getValue());
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown new Signature Type '" + (Object)((Object)signatureType) + "'.");
            }
        }
    }

    public DefaultApi10a getApi() {
        return this.api;
    }
}

