/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.httpclient;

import com.github.scribejava.core.httpclient.BodyPartPayload;
import java.util.ArrayList;
import java.util.List;

public class MultipartPayload {
    private final String boundary;
    private final List<BodyPartPayload> bodyParts = new ArrayList<BodyPartPayload>();

    public MultipartPayload(String boundary) {
        this.boundary = boundary;
    }

    public byte[] getStartBoundary(BodyPartPayload bodyPart) {
        return ("--" + this.boundary + "\r\nContent-Disposition: " + bodyPart.getContentDisposition() + "\r\n" + (bodyPart.getContentType() == null ? "" : "Content-Type: " + bodyPart.getContentType() + "\r\n") + "\r\n").getBytes();
    }

    public byte[] getEndBoundary() {
        return ("\r\n--" + this.boundary + "--\r\n").getBytes();
    }

    public int getContentLength() {
        int contentLength = 0;
        for (BodyPartPayload bodyPart : this.bodyParts) {
            contentLength += bodyPart.getPayload().length + bodyPart.getContentDisposition().length();
            if (bodyPart.getContentType() == null) continue;
            contentLength += 16 + bodyPart.getContentType().length();
        }
        return contentLength += (37 + this.boundary.length() * 2) * this.bodyParts.size();
    }

    public List<BodyPartPayload> getBodyParts() {
        return this.bodyParts;
    }

    public void addMultipartPayload(String contentDisposition, String contentType, byte[] payload) {
        this.bodyParts.add(new BodyPartPayload(contentDisposition, contentType, payload));
    }
}

