/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuth2Authorization;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuthService;
import com.github.scribejava.core.pkce.AuthorizationUrlWithPKCE;
import com.github.scribejava.core.pkce.PKCE;
import com.github.scribejava.core.pkce.PKCEService;
import com.github.scribejava.core.revoke.TokenTypeHint;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class OAuth20Service
extends OAuthService {
    private static final String VERSION = "2.0";
    private static final PKCEService PKCE_SERVICE = new PKCEService();
    private final DefaultApi20 api;
    private final String responseType;
    private final String state;

    @Deprecated
    public OAuth20Service(DefaultApi20 api, String apiKey, String apiSecret, String callback, String scope, OutputStream debugStream, String state, String responseType, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        this(api, apiKey, apiSecret, callback, scope, state, responseType, userAgent, httpClientConfig, httpClient);
    }

    public OAuth20Service(DefaultApi20 api, String apiKey, String apiSecret, String callback, String scope, String state, String responseType, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        super(apiKey, apiSecret, callback, scope, userAgent, httpClientConfig, httpClient);
        this.responseType = responseType;
        this.state = state;
        this.api = api;
    }

    protected OAuth2AccessToken sendAccessTokenRequestSync(OAuthRequest request) throws IOException, InterruptedException, ExecutionException {
        return this.api.getAccessTokenExtractor().extract(this.execute(request));
    }

    protected Future<OAuth2AccessToken> sendAccessTokenRequestAsync(OAuthRequest request) {
        return this.sendAccessTokenRequestAsync(request, null);
    }

    protected Future<OAuth2AccessToken> sendAccessTokenRequestAsync(OAuthRequest request, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        return this.execute(request, callback, new OAuthRequest.ResponseConverter<OAuth2AccessToken>(){

            @Override
            public OAuth2AccessToken convert(Response response) throws IOException {
                return OAuth20Service.this.getApi().getAccessTokenExtractor().extract(response);
            }
        });
    }

    public Future<OAuth2AccessToken> getAccessTokenAsync(String code) {
        return this.getAccessToken(code, null, null);
    }

    public Future<OAuth2AccessToken> getAccessTokenAsync(String code, String pkceCodeVerifier) {
        return this.getAccessToken(code, null, pkceCodeVerifier);
    }

    public OAuth2AccessToken getAccessToken(String code) throws IOException, InterruptedException, ExecutionException {
        return this.getAccessToken(code, (String)null);
    }

    public OAuth2AccessToken getAccessToken(String code, String pkceCodeVerifier) throws IOException, InterruptedException, ExecutionException {
        OAuthRequest request = this.createAccessTokenRequest(code, pkceCodeVerifier);
        return this.sendAccessTokenRequestSync(request);
    }

    public Future<OAuth2AccessToken> getAccessToken(String code, OAuthAsyncRequestCallback<OAuth2AccessToken> callback, String pkceCodeVerifier) {
        OAuthRequest request = this.createAccessTokenRequest(code, pkceCodeVerifier);
        return this.sendAccessTokenRequestAsync(request, callback);
    }

    public Future<OAuth2AccessToken> getAccessToken(String code, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        return this.getAccessToken(code, callback, null);
    }

    protected OAuthRequest createAccessTokenRequest(String code) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        this.api.getClientAuthenticationType().addClientAuthentication(request, this.getApiKey(), this.getApiSecret());
        request.addParameter("code", code);
        request.addParameter("redirect_uri", this.getCallback());
        String scope = this.getScope();
        if (scope != null) {
            request.addParameter("scope", scope);
        }
        request.addParameter("grant_type", "authorization_code");
        return request;
    }

    protected OAuthRequest createAccessTokenRequest(String code, String pkceCodeVerifier) {
        OAuthRequest request = this.createAccessTokenRequest(code);
        if (pkceCodeVerifier != null) {
            request.addParameter("code_verifier", pkceCodeVerifier);
        }
        return request;
    }

    public Future<OAuth2AccessToken> refreshAccessTokenAsync(String refreshToken) {
        return this.refreshAccessToken(refreshToken, null);
    }

    public OAuth2AccessToken refreshAccessToken(String refreshToken) throws IOException, InterruptedException, ExecutionException {
        OAuthRequest request = this.createRefreshTokenRequest(refreshToken);
        return this.sendAccessTokenRequestSync(request);
    }

    public Future<OAuth2AccessToken> refreshAccessToken(String refreshToken, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        OAuthRequest request = this.createRefreshTokenRequest(refreshToken);
        return this.sendAccessTokenRequestAsync(request, callback);
    }

    protected OAuthRequest createRefreshTokenRequest(String refreshToken) {
        if (refreshToken == null || refreshToken.isEmpty()) {
            throw new IllegalArgumentException("The refreshToken cannot be null or empty");
        }
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getRefreshTokenEndpoint());
        this.api.getClientAuthenticationType().addClientAuthentication(request, this.getApiKey(), this.getApiSecret());
        String scope = this.getScope();
        if (scope != null) {
            request.addParameter("scope", scope);
        }
        request.addParameter("refresh_token", refreshToken);
        request.addParameter("grant_type", "refresh_token");
        return request;
    }

    public OAuth2AccessToken getAccessTokenPasswordGrant(String uname, String password) throws IOException, InterruptedException, ExecutionException {
        OAuthRequest request = this.createAccessTokenPasswordGrantRequest(uname, password);
        return this.sendAccessTokenRequestSync(request);
    }

    public Future<OAuth2AccessToken> getAccessTokenPasswordGrantAsync(String uname, String password) {
        return this.getAccessTokenPasswordGrantAsync(uname, password, null);
    }

    public Future<OAuth2AccessToken> getAccessTokenPasswordGrantAsync(String uname, String password, OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        OAuthRequest request = this.createAccessTokenPasswordGrantRequest(uname, password);
        return this.sendAccessTokenRequestAsync(request, callback);
    }

    protected OAuthRequest createAccessTokenPasswordGrantRequest(String username, String password) {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        request.addParameter("username", username);
        request.addParameter("password", password);
        String scope = this.getScope();
        if (scope != null) {
            request.addParameter("scope", scope);
        }
        request.addParameter("grant_type", "password");
        this.api.getClientAuthenticationType().addClientAuthentication(request, this.getApiKey(), this.getApiSecret());
        return request;
    }

    public Future<OAuth2AccessToken> getAccessTokenClientCredentialsGrantAsync() {
        return this.getAccessTokenClientCredentialsGrant(null);
    }

    public OAuth2AccessToken getAccessTokenClientCredentialsGrant() throws IOException, InterruptedException, ExecutionException {
        OAuthRequest request = this.createAccessTokenClientCredentialsGrantRequest();
        return this.sendAccessTokenRequestSync(request);
    }

    public Future<OAuth2AccessToken> getAccessTokenClientCredentialsGrant(OAuthAsyncRequestCallback<OAuth2AccessToken> callback) {
        OAuthRequest request = this.createAccessTokenClientCredentialsGrantRequest();
        return this.sendAccessTokenRequestAsync(request, callback);
    }

    protected OAuthRequest createAccessTokenClientCredentialsGrantRequest() {
        OAuthRequest request = new OAuthRequest(this.api.getAccessTokenVerb(), this.api.getAccessTokenEndpoint());
        this.api.getClientAuthenticationType().addClientAuthentication(request, this.getApiKey(), this.getApiSecret());
        String scope = this.getScope();
        if (scope != null) {
            request.addParameter("scope", scope);
        }
        request.addParameter("grant_type", "client_credentials");
        return request;
    }

    @Override
    public String getVersion() {
        return VERSION;
    }

    public void signRequest(String accessToken, OAuthRequest request) {
        this.api.getSignatureType().signRequest(accessToken, request);
    }

    public void signRequest(OAuth2AccessToken accessToken, OAuthRequest request) {
        this.signRequest(accessToken == null ? null : accessToken.getAccessToken(), request);
    }

    public AuthorizationUrlWithPKCE getAuthorizationUrlWithPKCE() {
        return this.getAuthorizationUrlWithPKCE(null);
    }

    public AuthorizationUrlWithPKCE getAuthorizationUrlWithPKCE(Map<String, String> additionalParams) {
        PKCE pkce = PKCE_SERVICE.generatePKCE();
        return new AuthorizationUrlWithPKCE(pkce, this.getAuthorizationUrl(additionalParams, pkce));
    }

    public String getAuthorizationUrl() {
        return this.getAuthorizationUrl(null, null);
    }

    public String getAuthorizationUrl(Map<String, String> additionalParams) {
        return this.getAuthorizationUrl(additionalParams, null);
    }

    public String getAuthorizationUrl(PKCE pkce) {
        return this.getAuthorizationUrl(null, pkce);
    }

    public String getAuthorizationUrl(Map<String, String> additionalParams, PKCE pkce) {
        Map<String, String> params;
        if (pkce == null) {
            params = additionalParams;
        } else {
            params = additionalParams == null ? new HashMap<String, String>() : new HashMap<String, String>(additionalParams);
            params.putAll(pkce.getAuthorizationUrlParams());
        }
        return this.api.getAuthorizationUrl(this.getResponseType(), this.getApiKey(), this.getCallback(), this.getScope(), this.getState(), params);
    }

    public DefaultApi20 getApi() {
        return this.api;
    }

    protected OAuthRequest createRevokeTokenRequest(String tokenToRevoke, TokenTypeHint tokenTypeHint) {
        OAuthRequest request = new OAuthRequest(Verb.POST, this.api.getRevokeTokenEndpoint());
        this.api.getClientAuthenticationType().addClientAuthentication(request, this.getApiKey(), this.getApiSecret());
        request.addParameter("token", tokenToRevoke);
        if (tokenTypeHint != null) {
            request.addParameter("token_type_hint", tokenTypeHint.toString());
        }
        return request;
    }

    public Future<Void> revokeTokenAsync(String tokenToRevoke) {
        return this.revokeTokenAsync(tokenToRevoke, null);
    }

    public Future<Void> revokeTokenAsync(String tokenToRevoke, TokenTypeHint tokenTypeHint) {
        return this.revokeToken(tokenToRevoke, null, tokenTypeHint);
    }

    public void revokeToken(String tokenToRevoke) throws IOException, InterruptedException, ExecutionException {
        this.revokeToken(tokenToRevoke, (TokenTypeHint)null);
    }

    public void revokeToken(String tokenToRevoke, TokenTypeHint tokenTypeHint) throws IOException, InterruptedException, ExecutionException {
        OAuthRequest request = this.createRevokeTokenRequest(tokenToRevoke, tokenTypeHint);
        this.checkForErrorRevokeToken(this.execute(request));
    }

    public Future<Void> revokeToken(String tokenToRevoke, OAuthAsyncRequestCallback<Void> callback) {
        return this.revokeToken(tokenToRevoke, callback, null);
    }

    public Future<Void> revokeToken(String tokenToRevoke, OAuthAsyncRequestCallback<Void> callback, TokenTypeHint tokenTypeHint) {
        OAuthRequest request = this.createRevokeTokenRequest(tokenToRevoke, tokenTypeHint);
        return this.execute(request, callback, new OAuthRequest.ResponseConverter<Void>(){

            @Override
            public Void convert(Response response) throws IOException {
                OAuth20Service.this.checkForErrorRevokeToken(response);
                return null;
            }
        });
    }

    private void checkForErrorRevokeToken(Response response) throws IOException {
        if (response.getCode() != 200) {
            OAuth2AccessTokenJsonExtractor.instance().generateError(response.getBody());
        }
    }

    public OAuth2Authorization extractAuthorization(String redirectLocation) {
        OAuth2Authorization authorization = new OAuth2Authorization();
        int end = redirectLocation.indexOf(35);
        if (end == -1) {
            end = redirectLocation.length();
        }
        block8: for (String param : redirectLocation.substring(redirectLocation.indexOf(63) + 1, end).split("&")) {
            String[] keyValue = param.split("=");
            if (keyValue.length != 2) continue;
            switch (keyValue[0]) {
                case "code": {
                    authorization.setCode(keyValue[1]);
                    continue block8;
                }
                case "state": {
                    authorization.setState(keyValue[1]);
                    continue block8;
                }
            }
        }
        return authorization;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public String getState() {
        return this.state;
    }
}

