/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.builder.api;

import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.builder.api.ClientAuthenticationType;
import com.github.scribejava.core.builder.api.OAuth2SignatureType;
import com.github.scribejava.core.extractors.OAuth2AccessTokenJsonExtractor;
import com.github.scribejava.core.extractors.TokenExtractor;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.ParameterList;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.OutputStream;
import java.util.Map;

public abstract class DefaultApi20
implements BaseApi<OAuth20Service> {
    public TokenExtractor<OAuth2AccessToken> getAccessTokenExtractor() {
        return OAuth2AccessTokenJsonExtractor.instance();
    }

    public Verb getAccessTokenVerb() {
        return Verb.POST;
    }

    public abstract String getAccessTokenEndpoint();

    public String getRefreshTokenEndpoint() {
        return this.getAccessTokenEndpoint();
    }

    public String getRevokeTokenEndpoint() {
        throw new UnsupportedOperationException("This API doesn't support revoking tokens or we have no info about this");
    }

    protected abstract String getAuthorizationBaseUrl();

    public String getAuthorizationUrl(String responseType, String apiKey, String callback, String scope, String state, Map<String, String> additionalParams) {
        ParameterList parameters = new ParameterList(additionalParams);
        parameters.add("response_type", responseType);
        parameters.add("client_id", apiKey);
        if (callback != null) {
            parameters.add("redirect_uri", callback);
        }
        if (scope != null) {
            parameters.add("scope", scope);
        }
        if (state != null) {
            parameters.add("state", state);
        }
        return parameters.appendTo(this.getAuthorizationBaseUrl());
    }

    @Override
    public OAuth20Service createService(String apiKey, String apiSecret, String callback, String scope, OutputStream debugStream, String state, String responseType, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        return new OAuth20Service(this, apiKey, apiSecret, callback, scope, state, responseType, userAgent, httpClientConfig, httpClient);
    }

    public OAuth2SignatureType getSignatureType() {
        return OAuth2SignatureType.BEARER_AUTHORIZATION_REQUEST_HEADER_FIELD;
    }

    public ClientAuthenticationType getClientAuthenticationType() {
        return ClientAuthenticationType.HTTP_BASIC_AUTHENTICATION_SCHEME;
    }
}

