/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.builder.api;

import com.github.scribejava.core.java8.Base64;
import com.github.scribejava.core.model.OAuthRequest;
import java.nio.charset.Charset;

public enum ClientAuthenticationType {
    HTTP_BASIC_AUTHENTICATION_SCHEME{
        private final Base64.Encoder base64Encoder = Base64.getEncoder();

        @Override
        public void addClientAuthentication(OAuthRequest request, String apiKey, String apiSecret) {
            if (apiKey != null && apiSecret != null) {
                request.addHeader("Authorization", "Basic " + this.base64Encoder.encodeToString(String.format("%s:%s", apiKey, apiSecret).getBytes(Charset.forName("UTF-8"))));
            }
        }
    }
    ,
    REQUEST_BODY{

        @Override
        public void addClientAuthentication(OAuthRequest request, String apiKey, String apiSecret) {
            request.addParameter("client_id", apiKey);
            if (apiSecret != null) {
                request.addParameter("client_secret", apiSecret);
            }
        }
    };


    public abstract void addClientAuthentication(OAuthRequest var1, String var2, String var3);
}

