/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.httpclient.HttpClientProvider;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClient;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClientConfig;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public abstract class OAuthService
implements Closeable {
    private final String apiKey;
    private final String apiSecret;
    private final String callback;
    private final String scope;
    private final String userAgent;
    private final HttpClient httpClient;
    @Deprecated
    private final OAuthConfig oAuthConfig;

    public OAuthService(String apiKey, String apiSecret, String callback, String scope, OutputStream debugStream, String state, String responseType, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.callback = callback;
        this.scope = scope;
        this.userAgent = userAgent;
        this.httpClient = httpClientConfig == null && httpClient == null ? new JDKHttpClient(JDKHttpClientConfig.defaultConfig()) : (httpClient == null ? OAuthService.getClient(httpClientConfig) : httpClient);
        this.oAuthConfig = new OAuthConfig(apiKey, apiSecret, callback, scope, debugStream, state, responseType, userAgent, httpClientConfig, httpClient);
    }

    @Deprecated
    public OAuthService(OAuthConfig config) {
        this(config.getApiKey(), config.getApiSecret(), config.getCallback(), config.getScope(), config.getDebugStream(), config.getState(), config.getResponseType(), config.getUserAgent(), config.getHttpClientConfig(), config.getHttpClient());
    }

    private static HttpClient getClient(HttpClientConfig config) {
        for (HttpClientProvider provider : ServiceLoader.load(HttpClientProvider.class)) {
            HttpClient client = provider.createClient(config);
            if (client == null) continue;
            return client;
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.httpClient.close();
    }

    @Deprecated
    public OAuthConfig getConfig() {
        return this.oAuthConfig;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String getCallback() {
        return this.callback;
    }

    public String getScope() {
        return this.scope;
    }

    public abstract String getVersion();

    public Future<Response> executeAsync(OAuthRequest request) {
        return this.execute(request, null);
    }

    public Future<Response> execute(OAuthRequest request, OAuthAsyncRequestCallback<Response> callback) {
        return this.execute(request, callback, null);
    }

    public <R> Future<R> execute(OAuthRequest request, OAuthAsyncRequestCallback<R> callback, OAuthRequest.ResponseConverter<R> converter) {
        File filePayload = request.getFilePayload();
        if (filePayload != null) {
            return this.httpClient.executeAsync(this.userAgent, request.getHeaders(), request.getVerb(), request.getCompleteUrl(), filePayload, callback, converter);
        }
        if (request.getStringPayload() != null) {
            return this.httpClient.executeAsync(this.userAgent, request.getHeaders(), request.getVerb(), request.getCompleteUrl(), request.getStringPayload(), callback, converter);
        }
        return this.httpClient.executeAsync(this.userAgent, request.getHeaders(), request.getVerb(), request.getCompleteUrl(), request.getByteArrayPayload(), callback, converter);
    }

    public Response execute(OAuthRequest request) throws InterruptedException, ExecutionException, IOException {
        File filePayload = request.getFilePayload();
        if (filePayload != null) {
            return this.httpClient.execute(this.userAgent, request.getHeaders(), request.getVerb(), request.getCompleteUrl(), filePayload);
        }
        if (request.getStringPayload() != null) {
            return this.httpClient.execute(this.userAgent, request.getHeaders(), request.getVerb(), request.getCompleteUrl(), request.getStringPayload());
        }
        return this.httpClient.execute(this.userAgent, request.getHeaders(), request.getVerb(), request.getCompleteUrl(), request.getByteArrayPayload());
    }
}

