/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.AbstractRequest;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.ParameterList;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;

public class OAuthRequest
extends AbstractRequest {
    private static final String OAUTH_PREFIX = "oauth_";
    private final String url;
    private final Verb verb;
    private final ParameterList querystringParams = new ParameterList();
    private final ParameterList bodyParams = new ParameterList();
    private final Map<String, String> headers = new HashMap<String, String>();
    private String charset;
    private String stringPayload;
    private byte[] byteArrayPayload;
    private File filePayload;
    private final Map<String, String> oauthParameters = new HashMap<String, String>();
    private String realm;

    public OAuthRequest(Verb verb, String url) {
        this.verb = verb;
        this.url = url;
    }

    @Deprecated
    public OAuthRequest(Verb verb, String url, OAuthConfig config) {
        this(verb, url);
    }

    public void addOAuthParameter(String key, String value) {
        this.oauthParameters.put(this.checkKey(key), value);
    }

    private String checkKey(String key) {
        if (key.startsWith(OAUTH_PREFIX) || key.equals("scope") || key.equals("realm")) {
            return key;
        }
        throw new IllegalArgumentException(String.format("OAuth parameters must either be '%s', '%s' or start with '%s'", "scope", "realm", OAUTH_PREFIX));
    }

    public Map<String, String> getOauthParameters() {
        return this.oauthParameters;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getCompleteUrl() {
        return this.querystringParams.appendTo(this.url);
    }

    public void addHeader(String key, String value) {
        this.headers.put(key, value);
    }

    public void addBodyParameter(String key, String value) {
        this.bodyParams.add(key, value);
    }

    public void addQuerystringParameter(String key, String value) {
        this.querystringParams.add(key, value);
    }

    public void addParameter(String key, String value) {
        if (this.hasBodyContent()) {
            this.bodyParams.add(key, value);
        } else {
            this.querystringParams.add(key, value);
        }
    }

    protected boolean hasBodyContent() {
        return this.verb == Verb.PUT || this.verb == Verb.POST;
    }

    public void setPayload(String payload) {
        this.resetPayload();
        this.stringPayload = payload;
    }

    public void setPayload(byte[] payload) {
        this.resetPayload();
        this.byteArrayPayload = (byte[])payload.clone();
    }

    public void setPayload(File payload) {
        this.resetPayload();
        this.filePayload = payload;
    }

    private void resetPayload() {
        this.stringPayload = null;
        this.byteArrayPayload = null;
        this.filePayload = null;
    }

    public ParameterList getQueryStringParams() {
        try {
            ParameterList result = new ParameterList();
            String queryString = new URL(this.url).getQuery();
            result.addQuerystring(queryString);
            result.addAll(this.querystringParams);
            return result;
        }
        catch (MalformedURLException mue) {
            throw new OAuthException("Malformed URL", mue);
        }
    }

    public ParameterList getBodyParams() {
        return this.bodyParams;
    }

    public String getUrl() {
        return this.url;
    }

    public String getSanitizedUrl() {
        if (this.url.startsWith("http://") && (this.url.endsWith(":80") || this.url.contains(":80/"))) {
            return this.url.replaceAll("\\?.*", "").replaceAll(":80", "");
        }
        if (this.url.startsWith("https://") && (this.url.endsWith(":443") || this.url.contains(":443/"))) {
            return this.url.replaceAll("\\?.*", "").replaceAll(":443", "");
        }
        return this.url.replaceAll("\\?.*", "");
    }

    public String getStringPayload() {
        return this.stringPayload;
    }

    public byte[] getByteArrayPayload() {
        if (this.byteArrayPayload != null) {
            return this.byteArrayPayload;
        }
        String body = this.bodyParams.asFormUrlEncodedString();
        try {
            return body.getBytes(this.getCharset());
        }
        catch (UnsupportedEncodingException uee) {
            throw new OAuthException("Unsupported Charset: " + this.getCharset(), uee);
        }
    }

    public File getFilePayload() {
        return this.filePayload;
    }

    public String toString() {
        return String.format("@Request(%s %s)", new Object[]{this.getVerb(), this.getUrl()});
    }

    public Verb getVerb() {
        return this.verb;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getCharset() {
        return this.charset == null ? Charset.defaultCharset().name() : this.charset;
    }

    public void setCharset(String charsetName) {
        this.charset = charsetName;
    }

    public static interface ResponseConverter<T> {
        public T convert(Response var1) throws IOException;
    }
}

