/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.HttpClient;
import com.github.scribejava.core.model.SignatureType;
import java.io.IOException;
import java.io.OutputStream;

public class OAuthConfig {
    private final String apiKey;
    private final String apiSecret;
    private final String callback;
    private final SignatureType signatureType;
    private final String scope;
    private final OutputStream debugStream;
    private final String state;
    private final String responseType;
    private final String userAgent;
    private final Integer connectTimeout;
    private final Integer readTimeout;
    private HttpClientConfig httpClientConfig;
    private com.github.scribejava.core.httpclient.HttpClient httpClient;

    public OAuthConfig(String key, String secret) {
        this(key, secret, null, null, null, null, null, null, null, null, null, (HttpClientConfig)null, null);
    }

    @Deprecated
    public OAuthConfig(String apiKey, String apiSecret, String callback, SignatureType signatureType, String scope, OutputStream debugStream, String state, String responseType, String userAgent, Integer connectTimeout, Integer readTimeout, HttpClient.Config httpClientConfig, HttpClient httpClient) {
        throw new UnsupportedOperationException("deprecated, use another method, see javadocs");
    }

    public OAuthConfig(String apiKey, String apiSecret, String callback, SignatureType signatureType, String scope, OutputStream debugStream, String state, String responseType, String userAgent, Integer connectTimeout, Integer readTimeout, HttpClientConfig httpClientConfig, com.github.scribejava.core.httpclient.HttpClient httpClient) {
        this.apiKey = apiKey;
        this.apiSecret = apiSecret;
        this.callback = callback;
        this.signatureType = signatureType;
        this.scope = scope;
        this.debugStream = debugStream;
        this.state = state;
        this.responseType = responseType;
        this.userAgent = userAgent;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.httpClientConfig = httpClientConfig;
        this.httpClient = httpClient;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String getCallback() {
        return this.callback;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public String getScope() {
        return this.scope;
    }

    public String getState() {
        return this.state;
    }

    public String getResponseType() {
        return this.responseType;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void log(String message) {
        if (this.debugStream != null) {
            message = message + '\n';
            try {
                this.debugStream.write(message.getBytes("UTF8"));
            }
            catch (IOException | RuntimeException e) {
                throw new RuntimeException("there were problems while writting to the debug stream", e);
            }
        }
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public HttpClientConfig getHttpClientConfig() {
        return this.httpClientConfig;
    }

    public com.github.scribejava.core.httpclient.HttpClient getHttpClient() {
        return this.httpClient;
    }
}

