/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.async.ahc.OAuthAsyncCompletionHandler;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.ForceTypeOfHttpRequest;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequestAsync;
import com.github.scribejava.core.model.ScribeJavaConfig;
import com.github.scribejava.core.model.Verb;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Future;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;

public abstract class OAuthService {
    private final OAuthConfig config;
    private final com.ning.http.client.AsyncHttpClient ningAsyncHttpClient;
    private final AsyncHttpClient ahcAsyncHttpClient;

    public OAuthService(OAuthConfig config) {
        this.config = config;
        ForceTypeOfHttpRequest forceTypeOfHttpRequest = ScribeJavaConfig.getForceTypeOfHttpRequests();
        AsyncHttpClientConfig ningConfig = config.getNingAsyncHttpClientConfig();
        org.asynchttpclient.AsyncHttpClientConfig ahcConfig = config.getAhcAsyncHttpClientConfig();
        if (ningConfig == null && ahcConfig == null) {
            if (ForceTypeOfHttpRequest.FORCE_ASYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                throw new OAuthException("Cannot use sync operations, only async");
            }
            if (ForceTypeOfHttpRequest.PREFER_ASYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                config.log("Cannot use sync operations, only async");
            }
            this.ningAsyncHttpClient = null;
            this.ahcAsyncHttpClient = null;
        } else {
            if (ForceTypeOfHttpRequest.FORCE_SYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                throw new OAuthException("Cannot use async operations, only sync");
            }
            if (ForceTypeOfHttpRequest.PREFER_SYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                config.log("Cannot use async operations, only sync");
            }
            if (ahcConfig == null) {
                this.ningAsyncHttpClient = NingProvider.createClient(config.getNingAsyncHttpProviderClassName(), ningConfig);
                this.ahcAsyncHttpClient = null;
            } else {
                this.ahcAsyncHttpClient = AHCProvider.createClient(ahcConfig);
                this.ningAsyncHttpClient = null;
            }
        }
    }

    public void closeAsyncClient() throws IOException {
        if (this.ahcAsyncHttpClient == null) {
            this.ningAsyncHttpClient.close();
        } else {
            this.ahcAsyncHttpClient.close();
        }
    }

    public OAuthConfig getConfig() {
        return this.config;
    }

    public abstract String getVersion();

    public <T> Future<T> executeAsync(Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        if (this.ahcAsyncHttpClient == null) {
            return NingProvider.ningExecuteAsync(this.ningAsyncHttpClient, this.config.getUserAgent(), headers, httpVerb, completeUrl, bodyContents, callback, converter);
        }
        return AHCProvider.ahcExecuteAsync(this.ahcAsyncHttpClient, this.config.getUserAgent(), headers, httpVerb, completeUrl, bodyContents, callback, converter);
    }

    private static class AHCProvider {
        private AHCProvider() {
        }

        private static AsyncHttpClient createClient(org.asynchttpclient.AsyncHttpClientConfig ahcConfig) {
            return new DefaultAsyncHttpClient(ahcConfig);
        }

        private static <T> Future<T> ahcExecuteAsync(AsyncHttpClient ahcAsyncHttpClient, String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
            BoundRequestBuilder boundRequestBuilder;
            switch (httpVerb) {
                case GET: {
                    boundRequestBuilder = ahcAsyncHttpClient.prepareGet(completeUrl);
                    break;
                }
                case POST: {
                    BoundRequestBuilder requestBuilder = ahcAsyncHttpClient.preparePost(completeUrl);
                    if (!headers.containsKey("Content-Type")) {
                        requestBuilder = (BoundRequestBuilder)requestBuilder.addHeader((CharSequence)"Content-Type", "application/x-www-form-urlencoded");
                    }
                    boundRequestBuilder = (BoundRequestBuilder)requestBuilder.setBody(bodyContents);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("message build error: unknown verb type");
                }
            }
            for (Map.Entry<String, String> header : headers.entrySet()) {
                boundRequestBuilder.addHeader((CharSequence)header.getKey(), header.getValue());
            }
            if (userAgent != null) {
                boundRequestBuilder.setHeader((CharSequence)"User-Agent", userAgent);
            }
            return boundRequestBuilder.execute(new OAuthAsyncCompletionHandler<T>(callback, converter));
        }
    }

    private static class NingProvider {
        private NingProvider() {
        }

        private static com.ning.http.client.AsyncHttpClient createClient(String ningAsyncHttpProviderClassName, AsyncHttpClientConfig ningConfig) {
            return ningAsyncHttpProviderClassName == null ? new com.ning.http.client.AsyncHttpClient(ningConfig) : new com.ning.http.client.AsyncHttpClient(ningAsyncHttpProviderClassName, ningConfig);
        }

        private static <T> Future<T> ningExecuteAsync(com.ning.http.client.AsyncHttpClient ningAsyncHttpClient, String userAgent, Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
            AsyncHttpClient.BoundRequestBuilder boundRequestBuilder;
            switch (httpVerb) {
                case GET: {
                    boundRequestBuilder = ningAsyncHttpClient.prepareGet(completeUrl);
                    break;
                }
                case POST: {
                    AsyncHttpClient.BoundRequestBuilder requestBuilder = ningAsyncHttpClient.preparePost(completeUrl);
                    if (!headers.containsKey("Content-Type")) {
                        requestBuilder = requestBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded");
                    }
                    boundRequestBuilder = requestBuilder.setBody(bodyContents);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("message build error: unknown verb type");
                }
            }
            for (Map.Entry<String, String> header : headers.entrySet()) {
                boundRequestBuilder.addHeader(header.getKey(), header.getValue());
            }
            if (userAgent != null) {
                boundRequestBuilder.setHeader("User-Agent", userAgent);
            }
            return boundRequestBuilder.execute(new com.github.scribejava.core.async.ning.OAuthAsyncCompletionHandler<T>(callback, converter));
        }
    }
}

