/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.oauth;

import com.github.scribejava.core.async.ahc.OAuthAsyncCompletionHandler;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.ForceTypeOfHttpRequest;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.model.OAuthRequestAsync;
import com.github.scribejava.core.model.ScribeJavaConfig;
import com.github.scribejava.core.model.Verb;
import com.ning.http.client.AsyncHttpClient;
import com.ning.http.client.AsyncHttpClientConfig;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Future;
import org.asynchttpclient.AsyncHttpClient;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;

public abstract class OAuthService {
    private final OAuthConfig config;
    private final com.ning.http.client.AsyncHttpClient ningAsyncHttpClient;
    private final AsyncHttpClient ahcAsyncHttpClient;

    public OAuthService(OAuthConfig config) {
        this.config = config;
        ForceTypeOfHttpRequest forceTypeOfHttpRequest = ScribeJavaConfig.getForceTypeOfHttpRequests();
        AsyncHttpClientConfig ningConfig = config.getNingAsyncHttpClientConfig();
        org.asynchttpclient.AsyncHttpClientConfig ahcConfig = config.getAhcAsyncHttpClientConfig();
        if (ningConfig == null && ahcConfig == null) {
            if (ForceTypeOfHttpRequest.FORCE_ASYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                throw new OAuthException("Cannot use sync operations, only async");
            }
            if (ForceTypeOfHttpRequest.PREFER_ASYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                config.log("Cannot use sync operations, only async");
            }
            this.ningAsyncHttpClient = null;
            this.ahcAsyncHttpClient = null;
        } else {
            if (ForceTypeOfHttpRequest.FORCE_SYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                throw new OAuthException("Cannot use async operations, only sync");
            }
            if (ForceTypeOfHttpRequest.PREFER_SYNC_ONLY_HTTP_REQUESTS == forceTypeOfHttpRequest) {
                config.log("Cannot use async operations, only sync");
            }
            if (ahcConfig == null) {
                String ningAsyncHttpProviderClassName = config.getNingAsyncHttpProviderClassName();
                this.ningAsyncHttpClient = ningAsyncHttpProviderClassName == null ? new com.ning.http.client.AsyncHttpClient(ningConfig) : new com.ning.http.client.AsyncHttpClient(ningAsyncHttpProviderClassName, ningConfig);
                this.ahcAsyncHttpClient = null;
            } else {
                this.ahcAsyncHttpClient = new DefaultAsyncHttpClient(ahcConfig);
                this.ningAsyncHttpClient = null;
            }
        }
    }

    public void closeAsyncClient() throws IOException {
        if (this.ahcAsyncHttpClient == null) {
            this.ningAsyncHttpClient.close();
        } else {
            this.ahcAsyncHttpClient.close();
        }
    }

    public OAuthConfig getConfig() {
        return this.config;
    }

    public abstract String getVersion();

    public <T> Future<T> executeAsync(Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        if (this.ahcAsyncHttpClient == null) {
            return this.ningExecuteAsync(headers, httpVerb, completeUrl, bodyContents, callback, converter);
        }
        return this.ahcExecuteAsync(headers, httpVerb, completeUrl, bodyContents, callback, converter);
    }

    private <T> Future<T> ningExecuteAsync(Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        AsyncHttpClient.BoundRequestBuilder boundRequestBuilder;
        switch (httpVerb) {
            case GET: {
                boundRequestBuilder = this.ningAsyncHttpClient.prepareGet(completeUrl);
                break;
            }
            case POST: {
                Object requestBuilder = this.ningAsyncHttpClient.preparePost(completeUrl);
                if (!headers.containsKey("Content-Type")) {
                    requestBuilder = requestBuilder.addHeader("Content-Type", "application/x-www-form-urlencoded");
                }
                boundRequestBuilder = requestBuilder.setBody(bodyContents);
                break;
            }
            default: {
                throw new IllegalArgumentException("message build error: unknown verb type");
            }
        }
        for (Map.Entry entry : headers.entrySet()) {
            boundRequestBuilder.addHeader((String)entry.getKey(), (String)entry.getValue());
        }
        String userAgent = this.config.getUserAgent();
        if (userAgent != null) {
            boundRequestBuilder.setHeader("User-Agent", userAgent);
        }
        return boundRequestBuilder.execute(new com.github.scribejava.core.async.ning.OAuthAsyncCompletionHandler<T>(callback, converter));
    }

    private <T> Future<T> ahcExecuteAsync(Map<String, String> headers, Verb httpVerb, String completeUrl, String bodyContents, OAuthAsyncRequestCallback<T> callback, OAuthRequestAsync.ResponseConverter<T> converter) {
        BoundRequestBuilder boundRequestBuilder;
        switch (httpVerb) {
            case GET: {
                boundRequestBuilder = this.ahcAsyncHttpClient.prepareGet(completeUrl);
                break;
            }
            case POST: {
                Object requestBuilder = this.ahcAsyncHttpClient.preparePost(completeUrl);
                if (!headers.containsKey("Content-Type")) {
                    requestBuilder = (BoundRequestBuilder)requestBuilder.addHeader((CharSequence)"Content-Type", "application/x-www-form-urlencoded");
                }
                boundRequestBuilder = (BoundRequestBuilder)requestBuilder.setBody(bodyContents);
                break;
            }
            default: {
                throw new IllegalArgumentException("message build error: unknown verb type");
            }
        }
        for (Map.Entry entry : headers.entrySet()) {
            boundRequestBuilder.addHeader((CharSequence)entry.getKey(), (String)entry.getValue());
        }
        String userAgent = this.config.getUserAgent();
        if (userAgent != null) {
            boundRequestBuilder.setHeader((CharSequence)"User-Agent", userAgent);
        }
        return boundRequestBuilder.execute(new OAuthAsyncCompletionHandler<T>(callback, converter));
    }
}

