/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.model.SignatureType;
import java.io.IOException;
import java.io.OutputStream;

public class OAuthConfig {
    private final String apiKey;
    private final String apiSecret;
    private final String callback;
    private final SignatureType signatureType;
    private final String scope;
    private final String grantType;
    private final OutputStream debugStream;
    private final Integer connectTimeout;
    private final Integer readTimeout;
    private final String state;
    private final String responseType;

    public OAuthConfig(String key, String secret) {
        this(key, secret, null, null, null, null, null, null, null, null, null);
    }

    public OAuthConfig(String key, String secret, String callback, SignatureType type, String scope, OutputStream stream, Integer connectTimeout, Integer readTimeout, String grantType, String state, String responseType) {
        this.apiKey = key;
        this.apiSecret = secret;
        this.callback = callback;
        this.signatureType = type;
        this.scope = scope;
        this.debugStream = stream;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.grantType = grantType;
        this.state = state;
        this.responseType = responseType;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String getCallback() {
        return this.callback;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public String getScope() {
        return this.scope;
    }

    public boolean hasScope() {
        return this.scope != null;
    }

    public String getGrantType() {
        return this.grantType;
    }

    public boolean hasGrantType() {
        return this.grantType != null;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public Integer getReadTimeout() {
        return this.readTimeout;
    }

    public void log(String message) {
        if (this.debugStream != null) {
            message = message + '\n';
            try {
                this.debugStream.write(message.getBytes("UTF8"));
            }
            catch (IOException | RuntimeException e) {
                throw new RuntimeException("there were problems while writting to the debug stream", e);
            }
        }
    }

    public String getState() {
        return this.state;
    }

    public String getResponseType() {
        return this.responseType;
    }
}

