/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.builder;

import com.github.scribejava.core.builder.api.Api;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.model.SignatureType;
import com.github.scribejava.core.utils.Preconditions;
import java.io.OutputStream;

abstract class AbstractServiceBuilder<T extends AbstractServiceBuilder> {
    private Api api;
    private String callback = "oob";
    private String apiKey;
    private String apiSecret;
    private String scope;
    private String state;
    private SignatureType signatureType = SignatureType.Header;
    private OutputStream debugStream;
    private String grantType;

    public T provider(Class<? extends Api> apiClass) {
        Preconditions.checkNotNull(apiClass, "Api class cannot be null");
        try {
            this.api = apiClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException | RuntimeException e) {
            throw new OAuthException("Error while creating the Api object", e);
        }
        return (T)this;
    }

    public T provider(Api api) {
        Preconditions.checkNotNull(api, "Api cannot be null");
        this.api = api;
        return (T)this;
    }

    public T callback(String callback) {
        Preconditions.checkNotNull(callback, "Callback can't be null");
        this.callback = callback;
        return (T)this;
    }

    public T apiKey(String apiKey) {
        Preconditions.checkEmptyString(apiKey, "Invalid Api key");
        this.apiKey = apiKey;
        return (T)this;
    }

    public T apiSecret(String apiSecret) {
        Preconditions.checkEmptyString(apiSecret, "Invalid Api secret");
        this.apiSecret = apiSecret;
        return (T)this;
    }

    public T scope(String scope) {
        Preconditions.checkEmptyString(scope, "Invalid OAuth scope");
        this.scope = scope;
        return (T)this;
    }

    public T state(String state) {
        Preconditions.checkEmptyString(state, "Invalid OAuth state");
        this.state = state;
        return (T)this;
    }

    public T signatureType(SignatureType type) {
        Preconditions.checkNotNull((Object)type, "Signature type can't be null");
        this.signatureType = type;
        return (T)this;
    }

    public T debugStream(OutputStream stream) {
        Preconditions.checkNotNull(stream, "debug stream can't be null");
        this.debugStream = stream;
        return (T)this;
    }

    public T grantType(String grantType) {
        Preconditions.checkEmptyString(grantType, "Invalid OAuth grantType");
        this.grantType = grantType;
        return (T)this;
    }

    public T debug() {
        this.debugStream(System.out);
        return (T)this;
    }

    public void checkPreconditions() {
        Preconditions.checkNotNull(this.api, "You must specify a valid api through the provider() method");
        Preconditions.checkEmptyString(this.apiKey, "You must provide an api key");
        Preconditions.checkEmptyString(this.apiSecret, "You must provide an api secret");
    }

    public Api getApi() {
        return this.api;
    }

    public String getCallback() {
        return this.callback;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public String getScope() {
        return this.scope;
    }

    public String getState() {
        return this.state;
    }

    public SignatureType getSignatureType() {
        return this.signatureType;
    }

    public OutputStream getDebugStream() {
        return this.debugStream;
    }

    public String getGrantType() {
        return this.grantType;
    }
}

