/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;

public class GitHubApi
extends DefaultApi20 {
    private static final String AUTHORIZE_URL = "https://github.com/login/oauth/authorize?client_id=%s&redirect_uri=%s";

    private GitHubApi() {
    }

    public static GitHubApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public String getAccessTokenEndpoint() {
        return "https://github.com/login/oauth/access_token";
    }

    public String getAuthorizationUrl(OAuthConfig config) {
        String state;
        Preconditions.checkValidUrl((String)config.getCallback(), (String)"Must provide a valid url as callback. GitHub does not support OOB");
        StringBuilder sb = new StringBuilder(String.format(AUTHORIZE_URL, config.getApiKey(), OAuthEncoder.encode((String)config.getCallback())));
        if (config.hasScope()) {
            sb.append('&').append("scope").append('=').append(OAuthEncoder.encode((String)config.getScope()));
        }
        if ((state = config.getState()) != null) {
            sb.append('&').append("state").append('=').append(OAuthEncoder.encode((String)state));
        }
        return sb.toString();
    }

    private static class InstanceHolder {
        private static final GitHubApi INSTANCE = new GitHubApi();

        private InstanceHolder() {
        }
    }
}

