/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.Token;

public class NetProspexApi
extends DefaultApi10a {
    private static final String REQUEST_TOKEN_URL = "https://api.netprospex.com/1.0/oauth/request-token";
    private static final String ACCESS_TOKEN_URL = "https://api.netprospex.com/1.0/oauth/access-token";
    private static final String AUTHORIZE_URL = "https://api.netprospex.com/1.0/oauth/authorize?oauth_token=%s";

    private NetProspexApi() {
    }

    public static NetProspexApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public String getRequestTokenEndpoint() {
        return REQUEST_TOKEN_URL;
    }

    public String getAccessTokenEndpoint() {
        return ACCESS_TOKEN_URL;
    }

    public String getAuthorizationUrl(Token requestToken) {
        return String.format(AUTHORIZE_URL, requestToken.getToken());
    }

    private static class InstanceHolder {
        private static final NetProspexApi INSTANCE = new NetProspexApi();

        private InstanceHolder() {
        }
    }
}

