/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis;

import com.github.scribejava.core.builder.api.DefaultApi10a;
import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.model.Verb;

public class MendeleyApi
extends DefaultApi10a {
    private static final String AUTHORIZATION_URL = "http://api.mendeley.com/oauth/authorize?oauth_token=%s";

    private MendeleyApi() {
    }

    public static MendeleyApi instance() {
        return InstanceHolder.INSTANCE;
    }

    public String getRequestTokenEndpoint() {
        return "http://api.mendeley.com/oauth/request_token/";
    }

    public String getAccessTokenEndpoint() {
        return "http://api.mendeley.com/oauth/access_token/";
    }

    public String getAuthorizationUrl(Token requestToken) {
        return String.format(AUTHORIZATION_URL, requestToken.getToken());
    }

    public Verb getAccessTokenVerb() {
        return Verb.GET;
    }

    public Verb getRequestTokenVerb() {
        return Verb.GET;
    }

    private static class InstanceHolder {
        private static final MendeleyApi INSTANCE = new MendeleyApi();

        private InstanceHolder() {
        }
    }
}

