/*
 * Decompiled with CFR 0.152.
 */
package scopt;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ListBuffer;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JFunction1;
import scala.util.Either;
import scopt.DefaultOEffectSetup;
import scopt.DefaultOParserSetup;
import scopt.OEffect;
import scopt.OEffectSetup;
import scopt.OParserSetup;
import scopt.ORunner$;
import scopt.OptionDef;
import scopt.OptionDef$;
import scopt.OptionDefCallback;
import scopt.OptionDefKind;
import scopt.OptionDefKind$Arg$;
import scopt.OptionDefKind$Check$;
import scopt.OptionDefKind$Cmd$;
import scopt.OptionDefKind$Head$;
import scopt.OptionDefKind$Note$;
import scopt.OptionDefKind$Opt$;
import scopt.OptionDefKind$OptHelp$;
import scopt.OptionDefKind$OptVersion$;
import scopt.OptionDefKind$ProgramName$;
import scopt.Read;
import scopt.Read$;
import scopt.RenderingMode;

public abstract class OptionParser<C>
extends OptionDefCallback<C> {
    private final String programName;
    private final ListBuffer options;
    private final DefaultOParserSetup defaultParserSetup;
    private final DefaultOEffectSetup defaultEffectSetup;
    private Tuple2 $1$$lzy1;
    private boolean $1$bitmap$1;

    public <C> OptionParser(String programName) {
        this.programName = programName;
        this.options = new ListBuffer();
        this.defaultParserSetup = new DefaultOParserSetup(){};
        this.defaultEffectSetup = new DefaultOEffectSetup(){};
    }

    public ListBuffer<OptionDef<?, C>> options() {
        return this.options;
    }

    public DefaultOParserSetup defaultParserSetup() {
        return this.defaultParserSetup;
    }

    public DefaultOEffectSetup defaultEffectSetup() {
        return this.defaultEffectSetup;
    }

    private Tuple2<String, String> $1$() {
        if (!this.$1$bitmap$1) {
            Tuple2<String, String> tuple2 = ORunner$.MODULE$.renderUsage(this.renderingMode(), this.optionsWithProgramName());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            String header0 = (String)tuple2._1();
            String usage0 = (String)tuple2._2();
            this.$1$$lzy1 = Tuple2$.MODULE$.apply((Object)header0, (Object)usage0);
            this.$1$bitmap$1 = true;
        }
        return this.$1$$lzy1;
    }

    public String header0() {
        return (String)this.$1$()._1();
    }

    public String usage0() {
        return (String)this.$1$()._2();
    }

    public boolean errorOnUnknownArgument() {
        return this.defaultParserSetup().errorOnUnknownArgument();
    }

    public Option<Object> showUsageOnError() {
        return this.defaultParserSetup().showUsageOnError();
    }

    public void reportError(String msg) {
        this.defaultEffectSetup().reportError(msg);
    }

    public void reportWarning(String msg) {
        this.defaultEffectSetup().reportWarning(msg);
    }

    public RenderingMode renderingMode() {
        return this.defaultParserSetup().renderingMode();
    }

    public void terminate(Either<String, BoxedUnit> exitState) {
        this.defaultEffectSetup().terminate(exitState);
    }

    public void displayToOut(String msg) {
        this.defaultEffectSetup().displayToOut(msg);
    }

    public void displayToErr(String msg) {
        this.defaultEffectSetup().displayToErr(msg);
    }

    public OptionDef<BoxedUnit, C> head(scala.collection.immutable.Seq<String> xs) {
        return this.makeDef(OptionDefKind$Head$.MODULE$, "", Read$.MODULE$.unitRead()).text(xs.mkString(" "));
    }

    public <A> OptionDef<A, C> opt(String name, Read<A> evidence$1) {
        return this.makeDef(OptionDefKind$Opt$.MODULE$, name, evidence$1);
    }

    public <A> OptionDef<A, C> opt(char x, String name, Read<A> evidence$2) {
        return this.opt(name, evidence$2).abbr(BoxesRunTime.boxToCharacter((char)x).toString());
    }

    public OptionDef<BoxedUnit, C> note(String x) {
        return this.makeDef(OptionDefKind$Note$.MODULE$, "", Read$.MODULE$.unitRead()).text(x);
    }

    public <A> OptionDef<A, C> arg(String name, Read<A> evidence$3) {
        return this.makeDef(OptionDefKind$Arg$.MODULE$, name, evidence$3).required();
    }

    public OptionDef<BoxedUnit, C> cmd(String name) {
        return this.makeDef(OptionDefKind$Cmd$.MODULE$, name, Read$.MODULE$.unitRead());
    }

    public OptionDef<BoxedUnit, C> help(String name) {
        return this.makeDef(OptionDefKind$OptHelp$.MODULE$, name, Read$.MODULE$.unitRead());
    }

    public OptionDef<BoxedUnit, C> help(char x, String name) {
        return this.help(name).abbr(BoxesRunTime.boxToCharacter((char)x).toString());
    }

    public OptionDef<BoxedUnit, C> version(String name) {
        return this.makeDef(OptionDefKind$OptVersion$.MODULE$, name, Read$.MODULE$.unitRead());
    }

    public OptionDef<BoxedUnit, C> version(char x, String name) {
        return this.version(name).abbr(BoxesRunTime.boxToCharacter((char)x).toString());
    }

    public OptionDef<BoxedUnit, C> checkConfig(Function1<C, Either<String, BoxedUnit>> f) {
        return this.makeDef(OptionDefKind$Check$.MODULE$, "", Read$.MODULE$.unitRead()).validateConfig(f);
    }

    public String header() {
        return this.header0();
    }

    public String usage() {
        return this.usage0();
    }

    public Either<String, BoxedUnit> success() {
        return OptionDef$.MODULE$.makeSuccess();
    }

    public Either<String, BoxedUnit> failure(String msg) {
        return package$.MODULE$.Left().apply((Object)msg);
    }

    public <A> OptionDef<A, C> makeDef(OptionDefKind kind, String name, Read<A> evidence$4) {
        return this.updateOption(new OptionDef(kind, name, this, evidence$4), evidence$4);
    }

    @Override
    public <A> void onChange(OptionDef<A, C> option, Read<A> evidence$5) {
        this.updateOption(option, evidence$5);
    }

    public <A> OptionDef<A, C> updateOption(OptionDef<A, C> option, Read<A> evidence$6) {
        Growable growable;
        int idx = this.options().indexWhere((Function1)(JFunction1 & Serializable)_$1 -> _$1.id() == option.id());
        if (idx > -1) {
            this.options().update(idx, option);
            growable = BoxedUnit.UNIT;
        } else {
            growable = this.options().$plus$eq(option);
        }
        return option;
    }

    public List<OptionDef<?, C>> optionsWithProgramName() {
        OptionDef optionDef = new OptionDef(OptionDefKind$ProgramName$.MODULE$, "", Read$.MODULE$.unitRead()).text(this.programName);
        return this.options().toList().$colon$colon(optionDef);
    }

    public Option<C> parse(Seq<String> args, C init) {
        Tuple2<Option<C>, List<OEffect>> tuple2 = ORunner$.MODULE$.runParser(args, init, this.optionsWithProgramName(), new OParserSetup(this){
            private final OptionParser $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public RenderingMode renderingMode() {
                return this.$outer.renderingMode();
            }

            public boolean errorOnUnknownArgument() {
                return this.$outer.errorOnUnknownArgument();
            }

            public Option showUsageOnError() {
                return this.$outer.showUsageOnError();
            }
        });
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Option r = (Option)tuple2._1();
        List es = (List)tuple2._2();
        ORunner$.MODULE$.runEffects((List<OEffect>)es, new OEffectSetup(this){
            private final OptionParser $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public void displayToOut(String msg) {
                this.$outer.displayToOut(msg);
            }

            public void displayToErr(String msg) {
                this.$outer.displayToErr(msg);
            }

            public void reportError(String msg) {
                this.$outer.reportError(msg);
            }

            public void reportWarning(String msg) {
                this.$outer.reportWarning(msg);
            }

            public void terminate(Either exitState) {
                this.$outer.terminate((Either<String, BoxedUnit>)exitState);
            }
        });
        return r;
    }
}

