/*
 * Decompiled with CFR 0.152.
 */
package com.github.sbt.avro.mojo;

import com.github.sbt.avro.mojo.AvroFileRef;
import com.github.sbt.avro.mojo.SchemaGenerationException;
import com.github.sbt.avro.mojo.SchemaParserBuilder;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.avro.compiler.specific.SpecificCompiler;
import org.apache.avro.generic.GenericData;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvscFilesCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(AvscFilesCompiler.class);
    private final SchemaParserBuilder builder;
    private Schema.Parser schemaParser;
    private String templateDirectory;
    private GenericData.StringType stringType;
    private SpecificCompiler.FieldVisibility fieldVisibility;
    private boolean useNamespace;
    private boolean enableDecimalLogicalType;
    private boolean createSetters;
    private Optional<Boolean> optionalGetters = Optional.empty();
    private Map<AvroFileRef, Exception> compileExceptions;
    private boolean logCompileExceptions;

    public AvscFilesCompiler(SchemaParserBuilder schemaParserBuilder) {
        this.builder = schemaParserBuilder;
        this.schemaParser = schemaParserBuilder.build();
    }

    public void compileFiles(Set<AvroFileRef> set, File file) {
        HashSet<AvroFileRef> hashSet = new HashSet<AvroFileRef>();
        HashSet<AvroFileRef> hashSet2 = new HashSet<AvroFileRef>(set);
        boolean bl = true;
        while (bl && !hashSet2.isEmpty()) {
            bl = false;
            this.compileExceptions = new HashMap<AvroFileRef, Exception>();
            for (AvroFileRef object : hashSet2) {
                boolean bl2 = this.tryCompile(object, file);
                if (!bl2) continue;
                hashSet.add(object);
                bl = true;
            }
            hashSet2.removeAll(hashSet);
        }
        if (!hashSet2.isEmpty()) {
            String string = hashSet2.stream().map(AvroFileRef::toString).collect(Collectors.joining(", "));
            SchemaGenerationException schemaGenerationException = new SchemaGenerationException(String.format("Can not compile schema files: %s", string));
            for (AvroFileRef avroFileRef : hashSet2) {
                Exception exception = this.compileExceptions.get(avroFileRef);
                if (exception == null) continue;
                if (this.logCompileExceptions) {
                    LOG.error(avroFileRef.toString(), (Throwable)exception);
                }
                schemaGenerationException.addSuppressed(exception);
            }
            throw schemaGenerationException;
        }
    }

    private boolean tryCompile(AvroFileRef avroFileRef, File file) {
        Schema schema;
        Schema.Parser parser = this.stashParser();
        try {
            schema = this.schemaParser.parse(avroFileRef.getFile());
            this.validateParsedSchema(avroFileRef, schema);
        }
        catch (SchemaParseException schemaParseException) {
            this.schemaParser = parser;
            this.compileExceptions.put(avroFileRef, (Exception)((Object)schemaParseException));
            return false;
        }
        catch (IOException iOException) {
            throw new SchemaGenerationException(String.format("Error parsing schema file %s", avroFileRef), iOException);
        }
        SpecificCompiler specificCompiler = new SpecificCompiler(schema);
        specificCompiler.setTemplateDir(this.templateDirectory);
        specificCompiler.setStringType(this.stringType);
        specificCompiler.setFieldVisibility(this.fieldVisibility);
        specificCompiler.setEnableDecimalLogicalType(this.enableDecimalLogicalType);
        specificCompiler.setCreateSetters(this.createSetters);
        if (this.optionalGetters.isPresent()) {
            specificCompiler.setGettersReturnOptional(this.optionalGetters.get().booleanValue());
            specificCompiler.setOptionalGettersForNullableFieldsOnly(this.optionalGetters.get().booleanValue());
        }
        try {
            specificCompiler.compileToDestination(avroFileRef.getFile(), file);
        }
        catch (IOException iOException) {
            throw new SchemaGenerationException(String.format("Error compiling schema file %s to %s", avroFileRef, file), iOException);
        }
        return true;
    }

    private Schema.Parser stashParser() {
        Schema.Parser parser = this.builder.build();
        Set set = parser.getTypes().keySet();
        Map map = this.schemaParser.getTypes();
        map.keySet().removeAll(set);
        parser.addTypes(map);
        return parser;
    }

    private void validateParsedSchema(AvroFileRef avroFileRef, Schema schema) {
        if (this.useNamespace) {
            if (schema.getType() != Schema.Type.RECORD && schema.getType() != Schema.Type.ENUM) {
                throw new SchemaGenerationException(String.format("Error compiling schema file %s. Only one root RECORD or ENUM type is allowed per file.", avroFileRef));
            }
            if (!avroFileRef.pathToClassName().equals(schema.getFullName())) {
                throw new SchemaGenerationException(String.format("Error compiling schema file %s. File class name %s does not match record class name %s", avroFileRef, avroFileRef.pathToClassName(), schema.getFullName()));
            }
        }
    }

    public void setTemplateDirectory(String string) {
        this.templateDirectory = string;
    }

    public void setStringType(GenericData.StringType stringType) {
        this.stringType = stringType;
    }

    public void setFieldVisibility(SpecificCompiler.FieldVisibility fieldVisibility) {
        this.fieldVisibility = fieldVisibility;
    }

    public void setUseNamespace(boolean bl) {
        this.useNamespace = bl;
    }

    public void setEnableDecimalLogicalType(Boolean bl) {
        this.enableDecimalLogicalType = bl;
    }

    public void setCreateSetters(boolean bl) {
        this.createSetters = bl;
    }

    public void setLogCompileExceptions(boolean bl) {
        this.logCompileExceptions = bl;
    }

    public void setOptionalGetters(boolean bl) {
        this.optionalGetters = Optional.of(bl);
    }
}

