/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.junit.jupiter;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ContainerExtensionContext;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestExtensionContext;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.test.context.TestContextManager;
import org.springframework.test.context.junit.jupiter.ParameterAutowireUtils;
import org.springframework.util.Assert;

public class SpringExtension
implements BeforeAllCallback,
AfterAllCallback,
TestInstancePostProcessor,
BeforeEachCallback,
AfterEachCallback,
ParameterResolver {
    private static final ExtensionContext.Namespace namespace = ExtensionContext.Namespace.create((Object[])new Object[]{SpringExtension.class});

    public void beforeAll(ContainerExtensionContext context) throws Exception {
        this.getTestContextManager((ExtensionContext)context).beforeTestClass();
    }

    public void afterAll(ContainerExtensionContext context) throws Exception {
        try {
            this.getTestContextManager((ExtensionContext)context).afterTestClass();
        }
        finally {
            context.getStore(namespace).remove(context.getTestClass().get());
        }
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext context) throws Exception {
        this.getTestContextManager(context).prepareTestInstance(testInstance);
    }

    public void beforeEach(TestExtensionContext context) throws Exception {
        Object testInstance = context.getTestInstance();
        Method testMethod = (Method)context.getTestMethod().get();
        this.getTestContextManager((ExtensionContext)context).beforeTestMethod(testInstance, testMethod);
    }

    public void afterEach(TestExtensionContext context) throws Exception {
        Object testInstance = context.getTestInstance();
        Method testMethod = (Method)context.getTestMethod().get();
        Throwable testException = context.getTestException().orElse(null);
        this.getTestContextManager((ExtensionContext)context).afterTestMethod(testInstance, testMethod, testException);
    }

    public boolean supports(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        Executable executable = parameter.getDeclaringExecutable();
        return executable instanceof Constructor && AnnotatedElementUtils.hasAnnotation((AnnotatedElement)executable, Autowired.class) || ParameterAutowireUtils.isAutowirable(parameter);
    }

    public Object resolve(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        Class testClass = (Class)extensionContext.getTestClass().get();
        ApplicationContext applicationContext = this.getApplicationContext(extensionContext);
        return ParameterAutowireUtils.resolveDependency(parameter, testClass, applicationContext);
    }

    private ApplicationContext getApplicationContext(ExtensionContext context) {
        return this.getTestContextManager(context).getTestContext().getApplicationContext();
    }

    private TestContextManager getTestContextManager(ExtensionContext context) {
        Assert.notNull((Object)context, (String)"ExtensionContext must not be null");
        Class testClass = (Class)context.getTestClass().get();
        ExtensionContext.Store store = context.getStore(namespace);
        return (TestContextManager)store.getOrComputeIfAbsent((Object)testClass, TestContextManager::new, TestContextManager.class);
    }
}

