/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.spring;

import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jodconverter.DocumentConverter;
import org.jodconverter.LocalConverter;
import org.jodconverter.document.DefaultDocumentFormatRegistry;
import org.jodconverter.document.DocumentFamily;
import org.jodconverter.document.DocumentFormat;
import org.jodconverter.document.DocumentFormatRegistry;
import org.jodconverter.office.LocalOfficeManager;
import org.jodconverter.office.OfficeException;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.office.OfficeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class JodConverterBean
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(JodConverterBean.class);
    private String officeHome;
    private String portNumbers;
    private String workingDir;
    private String templateProfileDir;
    private Boolean killExistingProcess = true;
    private Long processTimeout = 120000L;
    private Long processRetryInterval = 250L;
    private Long taskExecutionTimeout = 120000L;
    private Integer maxTasksPerProcess = 200;
    private Long taskQueueTimeout = 30000L;
    private OfficeManager officeManager;
    private DocumentConverter documentConverter;

    public void afterPropertiesSet() throws OfficeException {
        LocalOfficeManager.Builder builder = LocalOfficeManager.builder();
        if (!StringUtils.isBlank((CharSequence)this.portNumbers)) {
            builder.portNumbers(ArrayUtils.toPrimitive((Integer[])((Integer[])Stream.of(StringUtils.split((String)this.portNumbers, (String)", ")).map(str -> NumberUtils.toInt((String)str, (int)2002)).toArray(Integer[]::new))));
        }
        builder.officeHome(this.officeHome);
        builder.workingDir(this.workingDir);
        builder.templateProfileDir(this.templateProfileDir);
        builder.killExistingProcess(this.killExistingProcess.booleanValue());
        builder.processTimeout(this.processTimeout.longValue());
        builder.processRetryInterval(this.processRetryInterval.longValue());
        builder.taskExecutionTimeout(this.taskExecutionTimeout.longValue());
        builder.maxTasksPerProcess(this.maxTasksPerProcess.intValue());
        builder.taskQueueTimeout(this.taskQueueTimeout.longValue());
        this.officeManager = builder.build();
        this.documentConverter = LocalConverter.make((OfficeManager)this.officeManager);
        this.officeManager.start();
    }

    public DocumentConverter getConverter() {
        return this.documentConverter;
    }

    public void destroy() {
        OfficeUtils.stopQuietly((OfficeManager)this.officeManager);
    }

    public void logAvailableFormats() {
        DocumentFormatRegistry ref = DefaultDocumentFormatRegistry.getInstance();
        Set formats = ref.getOutputFormats(DocumentFamily.TEXT);
        this.logSupportedGroupFormats("Supported Text Document Formats are:", formats);
        formats = ref.getOutputFormats(DocumentFamily.SPREADSHEET);
        this.logSupportedGroupFormats("Supported SpreadSheet Document Formats are:", formats);
        formats = ref.getOutputFormats(DocumentFamily.PRESENTATION);
        this.logSupportedGroupFormats("Supported Presentation Document Formats are:", formats);
        formats = ref.getOutputFormats(DocumentFamily.DRAWING);
        this.logSupportedGroupFormats("Supported Drawing Document Formats are:", formats);
    }

    private void logSupportedGroupFormats(String text, Set<DocumentFormat> formats) {
        LOGGER.info(text);
        formats.stream().map(DocumentFormat::getName).forEach(arg_0 -> ((Logger)LOGGER).info(arg_0));
    }

    public void setKillExistingProcess(Boolean killExistingProcess) {
        this.killExistingProcess = killExistingProcess;
    }

    public void setMaxTasksPerProcess(Integer maxTasksPerProcess) {
        this.maxTasksPerProcess = maxTasksPerProcess;
    }

    public void setOfficeHome(String officeHome) {
        this.officeHome = officeHome;
    }

    public void setPortNumbers(String portNumbers) {
        this.portNumbers = portNumbers;
    }

    public void setProcessRetryInterval(Long processRetryInterval) {
        this.processRetryInterval = processRetryInterval;
    }

    public void setProcessTimeout(Long processTimeout) {
        this.processTimeout = processTimeout;
    }

    public void setTaskExecutionTimeout(Long taskExecutionTimeout) {
        this.taskExecutionTimeout = taskExecutionTimeout;
    }

    public void setTaskQueueTimeout(Long taskQueueTimeout) {
        this.taskQueueTimeout = taskQueueTimeout;
    }

    public void setTemplateProfileDir(String templateProfileDir) {
        this.templateProfileDir = templateProfileDir;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }
}

