/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.boot.autoconfigure;

import java.util.Optional;
import org.jodconverter.DocumentConverter;
import org.jodconverter.OnlineConverter;
import org.jodconverter.boot.autoconfigure.JodConverterOnlineProperties;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.office.OnlineOfficeManager;
import org.jodconverter.ssl.SslConfig;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={OnlineConverter.class})
@ConditionalOnProperty(prefix="jodconverter.online", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={JodConverterOnlineProperties.class})
public class JodConverterOnlineAutoConfiguration {
    private final JodConverterOnlineProperties properties;

    public JodConverterOnlineAutoConfiguration(JodConverterOnlineProperties properties) {
        this.properties = properties;
    }

    private OfficeManager createOfficeManager() {
        OnlineOfficeManager.Builder builder = OnlineOfficeManager.builder();
        builder.urlConnection(this.properties.getUrl());
        builder.poolSize(this.properties.getPoolSize());
        builder.workingDir(this.properties.getWorkingDir());
        builder.taskExecutionTimeout(this.properties.getTaskExecutionTimeout());
        builder.taskQueueTimeout(this.properties.getTaskQueueTimeout());
        builder.sslConfig((SslConfig)Optional.ofNullable(this.properties.getSsl()).map(ssl -> {
            SslConfig sslConfig = new SslConfig();
            sslConfig.setEnabled(ssl.isEnabled());
            sslConfig.setCiphers(ssl.getCiphers());
            sslConfig.setKeyAlias(ssl.getKeyAlias());
            sslConfig.setKeyPassword(ssl.getKeyPassword());
            sslConfig.setKeyStore(ssl.getKeyStore());
            sslConfig.setKeyStorePassword(ssl.getKeyStorePassword());
            sslConfig.setKeyStoreType(ssl.getKeyStoreType());
            sslConfig.setKeyStoreProvider(ssl.getKeyStoreProvider());
            sslConfig.setEnabledProtocols(ssl.getEnabledProtocols());
            sslConfig.setTrustStore(ssl.getTrustStore());
            sslConfig.setTrustStorePassword(ssl.getTrustStorePassword());
            sslConfig.setTrustStoreType(ssl.getTrustStoreType());
            sslConfig.setTrustStoreProvider(ssl.getTrustStoreProvider());
            sslConfig.setProtocol(ssl.getProtocol());
            sslConfig.setVerifyHostname(ssl.isVerifyHostname());
            return sslConfig;
        }).orElse(null));
        return builder.build();
    }

    @Bean(initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean(name={"onlineOfficeManager"})
    public OfficeManager onlineOfficeManager() {
        return this.createOfficeManager();
    }

    @Bean
    @ConditionalOnMissingBean(name={"onlineDocumentConverter"})
    @ConditionalOnBean(name={"onlineOfficeManager"})
    public DocumentConverter onlineDocumentConverter(OfficeManager onlineOfficeManager) {
        return OnlineConverter.make((OfficeManager)onlineOfficeManager);
    }
}

