/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.boot.autoconfigure;

import java.io.InputStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jodconverter.DocumentConverter;
import org.jodconverter.LocalConverter;
import org.jodconverter.boot.autoconfigure.JodConverterLocalProperties;
import org.jodconverter.document.DefaultDocumentFormatRegistryInstanceHolder;
import org.jodconverter.document.DocumentFormatRegistry;
import org.jodconverter.document.JsonDocumentFormatRegistry;
import org.jodconverter.office.LocalOfficeManager;
import org.jodconverter.office.LocalOfficeUtils;
import org.jodconverter.office.OfficeManager;
import org.jodconverter.process.ProcessManager;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;

@Configuration
@ConditionalOnClass(value={LocalConverter.class})
@ConditionalOnProperty(prefix="jodconverter.local", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={JodConverterLocalProperties.class})
public class JodConverterLocalAutoConfiguration {
    private final JodConverterLocalProperties properties;

    public JodConverterLocalAutoConfiguration(JodConverterLocalProperties properties) {
        this.properties = properties;
    }

    private OfficeManager createOfficeManager(ProcessManager processManager) {
        LocalOfficeManager.Builder builder = LocalOfficeManager.builder();
        if (!StringUtils.isBlank((CharSequence)this.properties.getPortNumbers())) {
            builder.portNumbers(ArrayUtils.toPrimitive((Integer[])((Integer[])Stream.of(StringUtils.split((String)this.properties.getPortNumbers(), (String)", ")).map(str -> NumberUtils.toInt((String)str, (int)2002)).toArray(Integer[]::new))));
        }
        builder.officeHome(this.properties.getOfficeHome());
        builder.workingDir(this.properties.getWorkingDir());
        builder.templateProfileDir(this.properties.getTemplateProfileDir());
        builder.killExistingProcess(this.properties.isKillExistingProcess());
        builder.processTimeout(this.properties.getProcessTimeout());
        builder.processRetryInterval(this.properties.getProcessRetryInterval());
        builder.taskExecutionTimeout(this.properties.getTaskExecutionTimeout());
        builder.maxTasksPerProcess(this.properties.getMaxTasksPerProcess());
        builder.taskQueueTimeout(this.properties.getTaskQueueTimeout());
        String processManagerClass = this.properties.getProcessManagerClass();
        if (StringUtils.isNotEmpty((CharSequence)processManagerClass)) {
            builder.processManager(processManagerClass);
        } else {
            builder.processManager(processManager);
        }
        return builder.build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"processManager"})
    public ProcessManager processManager() {
        return LocalOfficeUtils.findBestProcessManager();
    }

    @Bean
    @ConditionalOnMissingBean(name={"documentFormatRegistry"})
    public DocumentFormatRegistry documentFormatRegistry(ResourceLoader resourceLoader) throws Exception {
        JsonDocumentFormatRegistry registry = null;
        if (StringUtils.isBlank((CharSequence)this.properties.getDocumentFormatRegistry())) {
            try (InputStream in = resourceLoader.getResource("classpath:document-formats.json").getInputStream();){
                registry = JsonDocumentFormatRegistry.create((InputStream)in, this.properties.getFormatOptions());
            }
        }
        try (InputStream in = resourceLoader.getResource(this.properties.getDocumentFormatRegistry()).getInputStream();){
            registry = JsonDocumentFormatRegistry.create((InputStream)in, this.properties.getFormatOptions());
        }
        DefaultDocumentFormatRegistryInstanceHolder.setInstance((DocumentFormatRegistry)registry);
        return registry;
    }

    @Bean(name={"localOfficeManager"}, initMethod="start", destroyMethod="stop")
    @ConditionalOnMissingBean(name={"localOfficeManager"})
    public OfficeManager localOfficeManager(ProcessManager processManager) {
        return this.createOfficeManager(processManager);
    }

    @Bean
    @ConditionalOnMissingBean(name={"localDocumentConverter"})
    @ConditionalOnBean(name={"localOfficeManager", "documentFormatRegistry"})
    public DocumentConverter localDocumentConverter(OfficeManager localOfficeManager, DocumentFormatRegistry documentFormatRegistry) {
        return ((LocalConverter.Builder)((LocalConverter.Builder)LocalConverter.builder().officeManager(localOfficeManager)).formatRegistry(documentFormatRegistry)).build();
    }
}

