/*
 * Decompiled with CFR 0.152.
 */
package dev.sayem.jsontotable;

import java.util.List;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public class HtmlTable {
    private HtmlTable() {
    }

    public static String fromJson(String json, List<String> cssClasses) {
        if (json == null || json.isEmpty()) {
            throw new RuntimeException("Json can't be null or empty!");
        }
        if (json.trim().startsWith("{")) {
            JSONObject jsonObject = new JSONObject(json);
            return HtmlTable.convertToHtmlTable(HtmlTable.fromObject(jsonObject), cssClasses);
        }
        if (json.trim().startsWith("[")) {
            JSONArray jsonArray = new JSONArray(json);
            return HtmlTable.convertToHtmlTable(jsonArray, cssClasses);
        }
        throw new RuntimeException("Provided value doesn't seem to be a json formatted string!");
    }

    private static JSONArray fromObject(JSONObject object) {
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)object);
        return jsonArray;
    }

    private static String convertToHtmlTable(JSONArray jsonArray, List<String> cssClasses) {
        if (jsonArray.isEmpty()) {
            return "";
        }
        Object item = jsonArray.get(0);
        if (!(item instanceof JSONObject) && !(item instanceof JSONArray)) {
            return item.toString();
        }
        if (item instanceof JSONArray) {
            return HtmlTable.convertToHtmlTable((JSONArray)item, cssClasses);
        }
        Set keys = jsonArray.getJSONObject(0).keySet();
        StringBuilder html = new StringBuilder();
        html.append("<table class=\"").append(String.join((CharSequence)" ", cssClasses)).append("\">");
        html.append("<thead>").append("<tr>");
        keys.forEach(key -> html.append("<th>").append((String)key).append("</th>"));
        html.append("</tr>").append("</thead>");
        html.append("<tbody>");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject obj = jsonArray.getJSONObject(i);
            html.append("<tr>");
            keys.forEach(key -> {
                Object value = obj.get(key);
                String toAppend = value instanceof JSONArray ? HtmlTable.convertToHtmlTable((JSONArray)value, cssClasses) : (value instanceof JSONObject ? HtmlTable.convertToHtmlTable(HtmlTable.fromObject((JSONObject)value), cssClasses) : value.toString());
                html.append("<td>").append(toAppend).append("</td>");
            });
            html.append("</tr>");
        }
        html.append("</tbody>");
        html.append("</table>");
        return html.toString();
    }
}

