/*
 * Decompiled with CFR 0.152.
 */
package com.savvyapps.togglebuttonlayout;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import androidx.annotation.AttrRes;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006J\u0018\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u000b\u001a\u00020\u0006J\u001a\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0001\u0010\u000e\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/savvyapps/togglebuttonlayout/Utils;", "", "()V", "xdpi", "", "dpToPx", "", "context", "Landroid/content/Context;", "dp", "getThemeAttrColor", "attributeColor", "getThemeAttrDrawable", "Landroid/graphics/drawable/Drawable;", "attributeDrawable", "togglebuttonlayout_release"})
public final class Utils {
    private static float xdpi;
    public static final Utils INSTANCE;

    public final int dpToPx(@NotNull Context context, int dp) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        if (xdpi == Float.MIN_VALUE) {
            Resources resources = context.getResources();
            Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"context.resources");
            xdpi = resources.getDisplayMetrics().xdpi;
        }
        return Math.round((float)dp * (xdpi / (float)160));
    }

    @Nullable
    public final Drawable getThemeAttrDrawable(@NotNull Context context, @AttrRes int attributeDrawable) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int[] attrs = new int[]{attributeDrawable};
        TypedArray ta = context.obtainStyledAttributes(attrs);
        Drawable drawableFromTheme = ta.getDrawable(0);
        ta.recycle();
        return drawableFromTheme;
    }

    public final int getThemeAttrColor(@NotNull Context context, @AttrRes int attributeColor) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int[] attrs = new int[]{attributeColor};
        TypedArray ta = context.obtainStyledAttributes(attrs);
        int color = ta.getColor(0, 0);
        ta.recycle();
        return color;
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
        xdpi = Float.MIN_VALUE;
    }
}

