/*
 * Decompiled with CFR 0.152.
 */
package com.orm.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.util.Log;

public class ManifestHelper {
    public static final String METADATA_DATABASE = "DATABASE";
    public static final String METADATA_VERSION = "VERSION";
    public static final String METADATA_DOMAIN_PACKAGE_NAME = "DOMAIN_PACKAGE_NAME";
    public static final String METADATA_QUERY_LOG = "QUERY_LOG";
    public static final String DATABASE_DEFAULT_NAME = "Sugar.db";

    public static int getDatabaseVersion(Context context) {
        Integer databaseVersion = ManifestHelper.getMetaDataInteger(context, METADATA_VERSION);
        if (databaseVersion == null || databaseVersion == 0) {
            databaseVersion = 1;
        }
        return databaseVersion;
    }

    public static String getDomainPackageName(Context context) {
        String domainPackageName = ManifestHelper.getMetaDataString(context, METADATA_DOMAIN_PACKAGE_NAME);
        if (domainPackageName == null) {
            domainPackageName = "";
        }
        return domainPackageName;
    }

    public static String getDatabaseName(Context context) {
        String databaseName = ManifestHelper.getMetaDataString(context, METADATA_DATABASE);
        if (databaseName == null) {
            databaseName = DATABASE_DEFAULT_NAME;
        }
        return databaseName;
    }

    public static boolean getDebugEnabled(Context context) {
        return ManifestHelper.getMetaDataBoolean(context, METADATA_QUERY_LOG);
    }

    private static String getMetaDataString(Context context, String name) {
        String value = null;
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo ai = pm.getApplicationInfo(context.getPackageName(), 128);
            value = ai.metaData.getString(name);
        }
        catch (Exception e) {
            Log.d((String)"sugar", (String)("Couldn't find config value: " + name));
        }
        return value;
    }

    private static Integer getMetaDataInteger(Context context, String name) {
        Integer value = null;
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo ai = pm.getApplicationInfo(context.getPackageName(), 128);
            value = ai.metaData.getInt(name);
        }
        catch (Exception e) {
            Log.d((String)"sugar", (String)("Couldn't find config value: " + name));
        }
        return value;
    }

    private static Boolean getMetaDataBoolean(Context context, String name) {
        Boolean value = false;
        PackageManager pm = context.getPackageManager();
        try {
            ApplicationInfo ai = pm.getApplicationInfo(context.getPackageName(), 128);
            value = ai.metaData.getBoolean(name);
        }
        catch (Exception e) {
            Log.d((String)"sugar", (String)("Couldn't find config value: " + name));
        }
        return value;
    }
}

