/*
 * Decompiled with CFR 0.152.
 */
package com.orm;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteStatement;
import android.text.TextUtils;
import android.util.Log;
import com.orm.SugarContext;
import com.orm.SugarDb;
import com.orm.dsl.Table;
import com.orm.util.NamingHelper;
import com.orm.util.QueryBuilder;
import com.orm.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentMap;

public class SugarRecord {
    private Long id = null;

    public static <T> int deleteAll(Class<T> type) {
        return SugarRecord.deleteAll(type, null, new String[0]);
    }

    public static <T> int deleteAll(Class<T> type, String whereClause, String ... whereArgs) {
        SugarDb db = SugarContext.getSugarContext().getSugarDb();
        SQLiteDatabase sqLiteDatabase = db.getDB();
        return sqLiteDatabase.delete(NamingHelper.toSQLName(type), whereClause, whereArgs);
    }

    public static <T> void saveInTx(T ... objects) {
        SugarRecord.saveInTx(Arrays.asList(objects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void saveInTx(Collection<T> objects) {
        SQLiteDatabase sqLiteDatabase = SugarContext.getSugarContext().getSugarDb().getDB();
        try {
            sqLiteDatabase.beginTransaction();
            sqLiteDatabase.setLockingEnabled(false);
            for (T object : objects) {
                SugarRecord.save(object);
            }
            sqLiteDatabase.setTransactionSuccessful();
        }
        catch (Exception e) {
            Log.i((String)"Sugar", (String)("Error in saving in transaction " + e.getMessage()));
        }
        finally {
            sqLiteDatabase.endTransaction();
            sqLiteDatabase.setLockingEnabled(true);
        }
    }

    public static <T> int deleteInTx(T ... objects) {
        return SugarRecord.deleteInTx(Arrays.asList(objects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> int deleteInTx(Collection<T> objects) {
        SQLiteDatabase sqLiteDatabase = SugarContext.getSugarContext().getSugarDb().getDB();
        int deletedRows = 0;
        try {
            sqLiteDatabase.beginTransaction();
            sqLiteDatabase.setLockingEnabled(false);
            for (T object : objects) {
                if (!SugarRecord.delete(object)) continue;
                ++deletedRows;
            }
            sqLiteDatabase.setTransactionSuccessful();
        }
        catch (Exception e) {
            deletedRows = 0;
            Log.i((String)"Sugar", (String)("Error in deleting in transaction " + e.getMessage()));
        }
        finally {
            sqLiteDatabase.endTransaction();
            sqLiteDatabase.setLockingEnabled(true);
        }
        return deletedRows;
    }

    public static <T> List<T> listAll(Class<T> type) {
        return SugarRecord.find(type, null, null, null, null, null);
    }

    public static <T> List<T> listAll(Class<T> type, String orderBy) {
        return SugarRecord.find(type, null, null, null, orderBy, null);
    }

    public static <T> T findById(Class<T> type, Long id) {
        List<T> list = SugarRecord.find(type, "id=?", new String[]{String.valueOf(id)}, null, null, "1");
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static <T> T findById(Class<T> type, Integer id) {
        return SugarRecord.findById(type, (long)id);
    }

    public static <T> List<T> findById(Class<T> type, String[] ids) {
        String whereClause = "id IN (" + QueryBuilder.generatePlaceholders(ids.length) + ")";
        return SugarRecord.find(type, whereClause, ids);
    }

    public static <T> T first(Class<T> type) {
        List<T> list = SugarRecord.findWithQuery(type, "SELECT * FROM " + NamingHelper.toSQLName(type) + " ORDER BY ID ASC LIMIT 1", new String[0]);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static <T> T last(Class<T> type) {
        List<T> list = SugarRecord.findWithQuery(type, "SELECT * FROM " + NamingHelper.toSQLName(type) + " ORDER BY ID DESC LIMIT 1", new String[0]);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    public static <T> Iterator<T> findAll(Class<T> type) {
        return SugarRecord.findAsIterator(type, null, null, null, null, null);
    }

    public static <T> Iterator<T> findAsIterator(Class<T> type, String whereClause, String ... whereArgs) {
        return SugarRecord.findAsIterator(type, whereClause, whereArgs, null, null, null);
    }

    public static <T> Iterator<T> findWithQueryAsIterator(Class<T> type, String query, String ... arguments) {
        SugarDb db = SugarContext.getSugarContext().getSugarDb();
        SQLiteDatabase sqLiteDatabase = db.getDB();
        Cursor c = sqLiteDatabase.rawQuery(query, arguments);
        return new CursorIterator<T>(type, c);
    }

    public static <T> Iterator<T> findAsIterator(Class<T> type, String whereClause, String[] whereArgs, String groupBy, String orderBy, String limit) {
        SugarDb db = SugarContext.getSugarContext().getSugarDb();
        SQLiteDatabase sqLiteDatabase = db.getDB();
        Cursor c = sqLiteDatabase.query(NamingHelper.toSQLName(type), null, whereClause, whereArgs, groupBy, null, orderBy, limit);
        return new CursorIterator<T>(type, c);
    }

    public static <T> List<T> find(Class<T> type, String whereClause, String ... whereArgs) {
        return SugarRecord.find(type, whereClause, whereArgs, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> findWithQuery(Class<T> type, String query, String ... arguments) {
        SugarDb db = SugarContext.getSugarContext().getSugarDb();
        SQLiteDatabase sqLiteDatabase = db.getDB();
        ArrayList<T> toRet = new ArrayList<T>();
        try (Cursor c = sqLiteDatabase.rawQuery(query, arguments);){
            while (c.moveToNext()) {
                T entity = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                SugarRecord.inflate(c, entity, SugarContext.getSugarContext().getEntitiesMap());
                toRet.add(entity);
            }
        }
        return toRet;
    }

    public static void executeQuery(String query, String ... arguments) {
        SugarContext.getSugarContext().getSugarDb().getDB().execSQL(query, (Object[])arguments);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> find(Class<T> type, String whereClause, String[] whereArgs, String groupBy, String orderBy, String limit) {
        SugarDb db = SugarContext.getSugarContext().getSugarDb();
        SQLiteDatabase sqLiteDatabase = db.getDB();
        ArrayList<T> toRet = new ArrayList<T>();
        try (Cursor c = sqLiteDatabase.query(NamingHelper.toSQLName(type), null, whereClause, whereArgs, groupBy, null, orderBy, limit);){
            while (c.moveToNext()) {
                T entity = type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                SugarRecord.inflate(c, entity, SugarContext.getSugarContext().getEntitiesMap());
                toRet.add(entity);
            }
        }
        return toRet;
    }

    public static <T> long count(Class<?> type) {
        return SugarRecord.count(type, null, null, null, null, null);
    }

    public static <T> long count(Class<?> type, String whereClause, String[] whereArgs) {
        return SugarRecord.count(type, whereClause, whereArgs, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> long count(Class<?> type, String whereClause, String[] whereArgs, String groupBy, String orderBy, String limit) {
        SQLiteStatement sqliteStatement;
        SugarDb db = SugarContext.getSugarContext().getSugarDb();
        SQLiteDatabase sqLiteDatabase = db.getDB();
        long toRet = -1L;
        String filter = !TextUtils.isEmpty((CharSequence)whereClause) ? " where " + whereClause : "";
        try {
            sqliteStatement = sqLiteDatabase.compileStatement("SELECT count(*) FROM " + NamingHelper.toSQLName(type) + filter);
        }
        catch (SQLiteException e) {
            e.printStackTrace();
            return toRet;
        }
        if (whereArgs != null) {
            for (int i = whereArgs.length; i != 0; --i) {
                sqliteStatement.bindString(i, whereArgs[i - 1]);
            }
        }
        try {
            toRet = sqliteStatement.simpleQueryForLong();
        }
        finally {
            sqliteStatement.close();
        }
        return toRet;
    }

    public static long save(Object object) {
        return SugarRecord.save(SugarContext.getSugarContext().getSugarDb().getDB(), object);
    }

    static long save(SQLiteDatabase db, Object object) {
        ConcurrentMap<Object, Long> entitiesMap = SugarContext.getSugarContext().getEntitiesMap();
        List<Field> columns = ReflectionUtil.getTableFields(object.getClass());
        ContentValues values = new ContentValues(columns.size());
        Field idField = null;
        for (Field column : columns) {
            ReflectionUtil.addFieldValueToColumn(values, column, object, entitiesMap);
            if (!column.getName().equals("id")) continue;
            idField = column;
        }
        boolean isSugarEntity = SugarRecord.isSugarEntity(object.getClass());
        if (isSugarEntity && entitiesMap.containsKey(object)) {
            values.put("id", (Long)entitiesMap.get(object));
        }
        long id = db.insertWithOnConflict(NamingHelper.toSQLName(object.getClass()), null, values, 5);
        if (object.getClass().isAnnotationPresent(Table.class)) {
            if (idField != null) {
                idField.setAccessible(true);
                try {
                    idField.set(object, new Long(id));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            } else {
                entitiesMap.put(object, id);
            }
        } else if (SugarRecord.class.isAssignableFrom(object.getClass())) {
            ((SugarRecord)object).setId(id);
        }
        Log.i((String)"Sugar", (String)(object.getClass().getSimpleName() + " saved : " + id));
        return id;
    }

    public static boolean isSugarEntity(Class<?> objectClass) {
        return objectClass.isAnnotationPresent(Table.class) || SugarRecord.class.isAssignableFrom(objectClass);
    }

    private static void inflate(Cursor cursor, Object object, Map<Object, Long> entitiesMap) {
        List<Field> columns = ReflectionUtil.getTableFields(object.getClass());
        if (!entitiesMap.containsKey(object)) {
            entitiesMap.put(object, cursor.getLong(cursor.getColumnIndex("ID")));
        }
        for (Field field : columns) {
            field.setAccessible(true);
            Class<?> fieldType = field.getType();
            if (SugarRecord.isSugarEntity(fieldType)) {
                try {
                    long id = cursor.getLong(cursor.getColumnIndex(NamingHelper.toSQLName(field)));
                    field.set(object, id > 0L ? SugarRecord.findById(fieldType, id) : null);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                continue;
            }
            ReflectionUtil.setFieldValueFromCursor(cursor, field, object);
        }
    }

    public boolean delete() {
        Long id = this.getId();
        Class<?> type = this.getClass();
        if (id != null && id > 0L) {
            SQLiteDatabase db = SugarContext.getSugarContext().getSugarDb().getDB();
            Log.i((String)"Sugar", (String)(type.getSimpleName() + " deleted : " + id));
            return db.delete(NamingHelper.toSQLName(type), "Id=?", new String[]{id.toString()}) == 1;
        }
        Log.i((String)"Sugar", (String)("Cannot delete object: " + type.getSimpleName() + " - object has not been saved"));
        return false;
    }

    public static boolean delete(Object object) {
        Class<?> type = object.getClass();
        if (type.isAnnotationPresent(Table.class)) {
            try {
                Field field = type.getDeclaredField("id");
                field.setAccessible(true);
                Long id = (Long)field.get(object);
                if (id != null && id > 0L) {
                    SQLiteDatabase db = SugarContext.getSugarContext().getSugarDb().getDB();
                    boolean deleted = db.delete(NamingHelper.toSQLName(type), "Id=?", new String[]{id.toString()}) == 1;
                    Log.i((String)"Sugar", (String)(type.getSimpleName() + " deleted : " + id));
                    return deleted;
                }
                Log.i((String)"Sugar", (String)("Cannot delete object: " + object.getClass().getSimpleName() + " - object has not been saved"));
                return false;
            }
            catch (NoSuchFieldException e) {
                Log.i((String)"Sugar", (String)("Cannot delete object: " + object.getClass().getSimpleName() + " - annotated object has no id"));
                return false;
            }
            catch (IllegalAccessException e) {
                Log.i((String)"Sugar", (String)("Cannot delete object: " + object.getClass().getSimpleName() + " - can't access id"));
                return false;
            }
        }
        if (SugarRecord.class.isAssignableFrom(type)) {
            return ((SugarRecord)object).delete();
        }
        Log.i((String)"Sugar", (String)("Cannot delete object: " + object.getClass().getSimpleName() + " - not persisted"));
        return false;
    }

    public long save() {
        return SugarRecord.save(SugarContext.getSugarContext().getSugarDb().getDB(), this);
    }

    void inflate(Cursor cursor) {
        SugarRecord.inflate(cursor, this, SugarContext.getSugarContext().getEntitiesMap());
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    static class CursorIterator<E>
    implements Iterator<E> {
        Class<E> type;
        Cursor cursor;

        public CursorIterator(Class<E> type, Cursor cursor) {
            this.type = type;
            this.cursor = cursor;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != null && !this.cursor.isClosed() && !this.cursor.isAfterLast();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E next() {
            E entity = null;
            if (this.cursor == null || this.cursor.isAfterLast()) {
                throw new NoSuchElementException();
            }
            if (this.cursor.isBeforeFirst()) {
                this.cursor.moveToFirst();
            }
            try {
                entity = this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                SugarRecord.inflate(this.cursor, entity, SugarContext.getSugarContext().getEntitiesMap());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.cursor.moveToNext();
                if (this.cursor.isAfterLast()) {
                    this.cursor.close();
                }
            }
            return entity;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

