/*
 * Decompiled with CFR 0.152.
 */
package com.orm.query;

public class Condition {
    private String property;
    private Object value;
    private Check check;

    public Condition(String property) {
        this.property = property;
    }

    public static Condition prop(String property) {
        return new Condition(property);
    }

    public Condition eq(Object value) {
        this.value = value;
        this.check = Check.EQUALS;
        return this;
    }

    public Condition like(Object value) {
        this.value = value;
        this.check = Check.LIKE;
        return this;
    }

    public Condition notLike(Object value) {
        this.value = value;
        this.check = Check.NOT_LIKE;
        return this;
    }

    public Condition notEq(Object value) {
        this.value = value;
        this.check = Check.NOT_EQUALS;
        return this;
    }

    public Condition gt(Object value) {
        this.value = value;
        this.check = Check.GREATER_THAN;
        return this;
    }

    public Condition lt(Object value) {
        this.value = value;
        this.check = Check.LESSER_THAN;
        return this;
    }

    public String getProperty() {
        return this.property;
    }

    public Object getValue() {
        return this.value;
    }

    public Check getCheck() {
        return this.check;
    }

    public String getCheckSymbol() {
        return this.check.getSymbol();
    }

    static enum Type {
        AND,
        OR,
        NOT;

    }

    static enum Check {
        EQUALS(" = "),
        GREATER_THAN(" > "),
        LESSER_THAN(" < "),
        NOT_EQUALS(" != "),
        LIKE(" LIKE "),
        NOT_LIKE(" NOT LIKE ");

        private String symbol;

        private Check(String symbol) {
            this.symbol = symbol;
        }

        public String getSymbol() {
            return this.symbol;
        }
    }
}

