/*
 * Decompiled with CFR 0.152.
 */
package com.orm.query;

import com.orm.SugarRecord;
import com.orm.query.Condition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Select<T extends SugarRecord<?>>
implements Iterable {
    private Class<T> record;
    private String[] arguments;
    private String whereClause = "";
    private String orderBy;
    private String groupBy;
    private String limit;
    private String offset;
    private List<Object> args = new ArrayList<Object>();

    public Select(Class<T> record) {
        this.record = record;
    }

    public static <T extends SugarRecord<T>> Select<T> from(Class<T> record) {
        return new Select<T>(record);
    }

    public Select<T> orderBy(String prop) {
        this.orderBy = prop;
        return this;
    }

    public Select<T> groupBy(String prop) {
        this.groupBy = prop;
        return this;
    }

    public Select<T> limit(String limit) {
        this.limit = limit;
        return this;
    }

    public Select<T> where(String whereClause) {
        this.whereClause = whereClause;
        return this;
    }

    public Select<T> where(Condition ... condition) {
        this.mergeConditions(condition, Condition.Type.AND);
        return this;
    }

    private void mergeConditions(Condition[] conditions, Condition.Type type) {
        for (Condition condition : conditions) {
            if (!"".equals(this.whereClause)) {
                this.whereClause = this.whereClause + " " + type.name() + " ";
            }
            if (Condition.Check.LIKE.equals((Object)condition.getCheck()) || Condition.Check.NOT_LIKE.equals((Object)condition.getCheck())) {
                this.whereClause = this.whereClause + condition.getProperty() + condition.getCheckSymbol() + "'" + condition.getValue().toString() + "'";
                continue;
            }
            this.whereClause = this.whereClause + condition.getProperty() + condition.getCheckSymbol() + "? ";
            this.args.add(condition.getValue());
        }
    }

    public Select<T> whereOr(Condition ... args) {
        this.mergeConditions(args, Condition.Type.OR);
        return this;
    }

    public Select<T> and(Condition ... args) {
        this.mergeConditions(args, Condition.Type.AND);
        return this;
    }

    public Select<T> or(Condition ... args) {
        this.mergeConditions(args, Condition.Type.OR);
        return this;
    }

    public Select<T> where(String whereClause, String[] args) {
        this.whereClause = whereClause;
        this.arguments = args;
        return this;
    }

    public List<T> list() {
        if (this.arguments == null) {
            this.arguments = this.convertArgs(this.args);
        }
        return SugarRecord.find(this.record, this.whereClause, this.arguments, this.groupBy, this.orderBy, this.limit);
    }

    public long count() {
        if (this.arguments == null) {
            this.arguments = this.convertArgs(this.args);
        }
        return SugarRecord.count(this.record, this.whereClause, this.arguments, this.groupBy, this.orderBy, this.limit);
    }

    public T first() {
        List<T> list;
        if (this.arguments == null) {
            this.arguments = this.convertArgs(this.args);
        }
        return (T)((list = SugarRecord.find(this.record, this.whereClause, this.arguments, this.groupBy, this.orderBy, "1")).size() > 0 ? (SugarRecord)list.get(0) : null);
    }

    String toSql() {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM");
        sql.append("FROM ");
        sql.append(SugarRecord.getTableName(this.record) + " ");
        if (this.whereClause != null) {
            sql.append("WHERE " + this.whereClause + " ");
        }
        if (this.orderBy != null) {
            sql.append("ORDER BY " + this.orderBy + " ");
        }
        if (this.limit != null) {
            sql.append("LIMIT " + this.limit + " ");
        }
        if (this.offset != null) {
            sql.append("OFFSET " + this.offset + " ");
        }
        return sql.toString();
    }

    String getWhereCond() {
        return this.whereClause;
    }

    String[] getArgs() {
        return this.convertArgs(this.args);
    }

    private String[] convertArgs(List<Object> argsList) {
        String[] argsArray = new String[argsList.size()];
        for (int i = 0; i < argsList.size(); ++i) {
            argsArray[i] = argsList.get(i).toString();
        }
        return argsArray;
    }

    @Override
    public Iterator<T> iterator() {
        if (this.arguments == null) {
            this.arguments = this.convertArgs(this.args);
        }
        return SugarRecord.findAsIterator(this.record, this.whereClause, this.arguments, this.groupBy, this.orderBy, this.limit);
    }
}

