/*
 * Decompiled with CFR 0.152.
 */
package com.satyajit.thespotsdialog;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Bundle;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.widget.TextView;
import com.satyajit.thespotsdialog.AnimatedView;
import com.satyajit.thespotsdialog.AnimatorPlayer;
import com.satyajit.thespotsdialog.HesitateInterpolator;
import com.satyajit.thespotsdialog.ProgressLayout;
import com.satyajit.thespotsdialog.R;

public class SpotsDialog
extends AlertDialog {
    private static final int DELAY = 150;
    private static final int DURATION = 1500;
    private int size;
    private AnimatedView[] spots;
    private AnimatorPlayer animator;
    private CharSequence message;
    private Typeface typeface;

    private SpotsDialog(Context context, String message, int theme, boolean cancelable, DialogInterface.OnCancelListener cancelListener, Typeface typeface) {
        super(context, theme);
        this.message = message;
        this.typeface = typeface;
        this.setCancelable(cancelable);
        if (cancelListener != null) {
            this.setOnCancelListener(cancelListener);
        }
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.the_spots_dialog);
        this.setCanceledOnTouchOutside(false);
        if (this.typeface == null) {
            this.typeface = Typeface.createFromAsset((AssetManager)this.getContext().getAssets(), (String)"fonts/cav.ttf");
        }
        this.initMessage();
        this.initProgress();
    }

    protected void onStart() {
        super.onStart();
        for (AnimatedView view : this.spots) {
            view.setVisibility(0);
        }
        this.animator = new AnimatorPlayer(this.createAnimations());
        this.animator.play();
    }

    protected void onStop() {
        super.onStop();
        this.animator.stop();
    }

    public void setMessage(CharSequence message) {
        this.message = message;
        if (this.isShowing()) {
            this.initMessage();
        }
    }

    private void initMessage() {
        if (this.message != null && this.message.length() > 0) {
            ((TextView)this.findViewById(R.id.dialog_spots_title)).setText(this.message);
            ((TextView)this.findViewById(R.id.dialog_spots_title)).setTypeface(this.typeface);
        }
    }

    private void initProgress() {
        ProgressLayout progress = (ProgressLayout)this.findViewById(R.id.dialog_spots_progress);
        this.size = progress.getSpotsCount();
        this.spots = new AnimatedView[this.size];
        int size = this.getContext().getResources().getDimensionPixelSize(R.dimen.spot_size);
        int progressWidth = this.getContext().getResources().getDimensionPixelSize(R.dimen.progress_width);
        for (int i = 0; i < this.spots.length; ++i) {
            AnimatedView v = new AnimatedView(this.getContext());
            v.setBackgroundResource(R.drawable.the_dialog_spot);
            v.setTarget(progressWidth);
            v.setXFactor(-1.0f);
            v.setVisibility(4);
            progress.addView(v, size, size);
            this.spots[i] = v;
        }
    }

    private Animator[] createAnimations() {
        Animator[] animators = new Animator[this.size];
        for (int i = 0; i < this.spots.length; ++i) {
            final AnimatedView animatedView = this.spots[i];
            ObjectAnimator move = ObjectAnimator.ofFloat((Object)((Object)animatedView), (String)"xFactor", (float[])new float[]{0.0f, 1.0f});
            move.setDuration(1500L);
            move.setInterpolator((TimeInterpolator)new HesitateInterpolator());
            move.setStartDelay((long)(150 * i));
            move.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    animatedView.setVisibility(4);
                }

                public void onAnimationStart(Animator animation) {
                    animatedView.setVisibility(0);
                }
            });
            animators[i] = move;
        }
        return animators;
    }

    public static class Builder {
        private Context context;
        private String message;
        private int messageId;
        private int themeId;
        private Typeface typeface;
        private boolean cancelable = true;
        private DialogInterface.OnCancelListener cancelListener;

        public Builder setContext(Context context) {
            this.context = context;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setTypeface(Typeface typeface) {
            this.typeface = typeface;
            return this;
        }

        public Builder setMessage(@StringRes int messageId) {
            this.messageId = messageId;
            return this;
        }

        public Builder setTheme(@StyleRes int themeId) {
            this.themeId = themeId;
            return this;
        }

        public Builder setCancelable(boolean cancelable) {
            this.cancelable = cancelable;
            return this;
        }

        public Builder setCancelListener(DialogInterface.OnCancelListener cancelListener) {
            this.cancelListener = cancelListener;
            return this;
        }

        public AlertDialog build() {
            return new SpotsDialog(this.context, this.messageId != 0 ? this.context.getString(this.messageId) : this.message, this.themeId != 0 ? this.themeId : R.style.SpotsDialogDefault, this.cancelable, this.cancelListener, this.typeface);
        }
    }
}

