/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.overcast;

import com.github.sarxos.overcast.Instance;
import com.github.sarxos.overcast.OvercastAbstractMojo;
import com.jcabi.log.Logger;
import com.typesafe.config.Config;
import com.xebialabs.overcast.host.CloudHost;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="teardown", defaultPhase=LifecyclePhase.POST_INTEGRATION_TEST)
public class OvercastTeardownMojo
extends OvercastAbstractMojo {
    private CloudHost teardown(String name) throws MojoExecutionException {
        Logger.info((Object)((Object)this), (String)("Tearing down instance " + name));
        CloudHost cloud = this.find(name);
        cloud.teardown();
        return cloud;
    }

    @Override
    public void run() throws MojoExecutionException, MojoFailureException {
        Config config = this.getConfig();
        for (Instance instance : this.getInstances()) {
            String name = instance.getName();
            if (!config.hasPath(name)) {
                throw new MojoExecutionException("Overcast configuration file " + this.getConfFile().getAbsolutePath() + " does not define '" + name + "' instance");
            }
            this.teardown(name);
        }
    }

    @Override
    public String toString() {
        return "OvercastTeardownMojo()";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OvercastTeardownMojo)) {
            return false;
        }
        OvercastTeardownMojo other = (OvercastTeardownMojo)((Object)o);
        return other.canEqual((Object)this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OvercastTeardownMojo;
    }

    @Override
    public int hashCode() {
        int result = 1;
        return result;
    }
}

