/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.overcast;

import com.github.sarxos.overcast.Instance;
import com.github.sarxos.overcast.Mapping;
import com.jcabi.log.Logger;
import com.spotify.docker.client.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import com.xebialabs.overcast.host.CloudHost;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.slf4j.impl.StaticLoggerBinder;

public abstract class OvercastAbstractMojo
extends AbstractMojo {
    private static final String CLOUDS_PROPERTY = "overcast.maven.plugin.cloud.mapping";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    @Parameter(defaultValue="${project}", readonly=true)
    private transient MavenProject project;
    @Parameter(defaultValue="false", required=false)
    private transient boolean skip;
    @Parameter(required=true)
    private transient File conf;
    @Parameter(defaultValue="${project.build.directory}/test-classes/overcast.ser", required=true)
    private transient File target;
    @Parameter(readonly=true, required=true)
    private List<Instance> instances;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        StaticLoggerBinder.getSingleton().setMavenLog(this.getLog());
        if (this.isSkip()) {
            Logger.info((Object)((Object)this), (String)"Execution skipped because of 'skip' option");
            return;
        }
        if (!this.conf.exists()) {
            throw new MojoExecutionException("Overcast configuration file does not exist: " + FilenameUtils.normalize((String)this.conf.getAbsolutePath()));
        }
        Properties properties = System.getProperties();
        String key = "overcast.conf.file";
        String value = properties.getProperty(key);
        properties.setProperty(key, this.conf.getAbsolutePath());
        try {
            this.run();
        }
        finally {
            if (value != null) {
                properties.setProperty(key, value);
            } else {
                properties.remove(key);
            }
        }
    }

    public abstract void run() throws MojoExecutionException, MojoFailureException;

    public boolean isSkip() {
        return this.skip;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public Config getConfig() {
        return ConfigFactory.systemProperties().withFallback((ConfigMergeable)this.loadOvercastConfigFromFile(this.conf)).withFallback((ConfigMergeable)this.loadOvercastConfigFromFile(new File("overcast.conf"))).resolve();
    }

    protected OvercastAbstractMojo setConfFile(File conf) {
        this.conf = conf;
        return this;
    }

    protected File getConfFile() {
        return this.conf;
    }

    private Config loadOvercastConfigFromFile(File file) {
        if (file == null) {
            Logger.warn((Object)((Object)this), (String)"File is null");
            return ConfigFactory.empty();
        }
        if (!file.exists()) {
            Logger.warn((Object)((Object)this), (String)("File " + file + " not found"));
            return ConfigFactory.empty();
        }
        Logger.info((Object)((Object)this), (String)("Loading from file" + file.getAbsolutePath()));
        return ConfigFactory.parseFile((File)file);
    }

    public List<Instance> getInstances() {
        return this.instances;
    }

    public File getTarget() {
        return this.target;
    }

    protected void store(List<Mapping> mappings) throws MojoExecutionException {
        Logger.debug((Object)((Object)this), (String)("Store cloud mappings: " + mappings));
        List trivialities = null;
        try {
            trivialities = (List)MAPPER.readValue(MAPPER.writeValueAsString(mappings), ArrayList.class);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot reduce objects types by JSON reverse conversion", (Exception)e);
        }
        File target = this.getTarget();
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(target));){
            oos.writeObject(trivialities);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Cannot write object to file " + target, (Exception)e);
        }
        this.setCloudMappings(mappings);
    }

    protected CloudHost find(String name) throws MojoExecutionException {
        Logger.debug((Object)((Object)this), (String)("Find mapping " + name));
        List<Mapping> mappings = this.getCloudMappings();
        if (mappings == null) {
            throw new MojoExecutionException("Cannot find cloud mappings, seems like setup goal has not ben executed");
        }
        for (Mapping mapping : mappings) {
            if (!mapping.getName().equals(name)) continue;
            return mapping.getCloud();
        }
        throw new MojoExecutionException("Cloud mapping for name '" + name + "' has not been found");
    }

    protected Mapping map(Instance instance, CloudHost cloud) {
        return new Mapping(instance, cloud);
    }

    private void setCloudMappings(List<Mapping> mappings) {
        this.getProject().getProperties().put(CLOUDS_PROPERTY, mappings);
    }

    private List<Mapping> getCloudMappings() {
        return (List)this.getProject().getProperties().get(CLOUDS_PROPERTY);
    }

    public String toString() {
        return "OvercastAbstractMojo(project=" + this.getProject() + ", skip=" + this.isSkip() + ", conf=" + this.conf + ", target=" + this.getTarget() + ", instances=" + this.getInstances() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OvercastAbstractMojo)) {
            return false;
        }
        OvercastAbstractMojo other = (OvercastAbstractMojo)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        List<Instance> this$instances = this.getInstances();
        List<Instance> other$instances = other.getInstances();
        return !(this$instances == null ? other$instances != null : !((Object)this$instances).equals(other$instances));
    }

    protected boolean canEqual(Object other) {
        return other instanceof OvercastAbstractMojo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Instance> $instances = this.getInstances();
        result = result * 59 + ($instances == null ? 0 : ((Object)$instances).hashCode());
        return result;
    }
}

