/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.netinject;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectorUtils {
    private static final Logger LOG = LoggerFactory.getLogger(InjectorUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static URI resourceToLocalURI(String resource, Class<?> ctx) throws ZipException, IOException, URISyntaxException {
        ProtectionDomain domain = ctx.getProtectionDomain();
        CodeSource source = domain.getCodeSource();
        URI where = source.getLocation().toURI();
        File location = new File(where);
        URI uri = null;
        if (location.isDirectory()) {
            uri = URI.create(where.toString() + resource);
        } else {
            ZipFile zip = new ZipFile(location);
            try {
                uri = InjectorUtils.extract(zip, resource);
            }
            finally {
                zip.close();
            }
        }
        return uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static URI extract(ZipFile zip, String filen) throws IOException {
        File tmp = File.createTempFile(filen + ".", ".tmp");
        tmp.deleteOnExit();
        ZipEntry entry = zip.getEntry(filen);
        if (entry == null) {
            throw new FileNotFoundException(String.format("Cannot find file %s in archive %s", filen, zip.getName()));
        }
        InputStream is = zip.getInputStream(entry);
        FileOutputStream os = new FileOutputStream(tmp);
        byte[] buf = new byte[1024];
        int i = 0;
        try {
            while ((i = is.read(buf)) != -1) {
                ((OutputStream)os).write(buf, 0, i);
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException e) {
                    LOG.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        return tmp.toURI();
    }

    public static final int getProcessID(String name) {
        int[] pids = InjectorUtils.getProcessIDs(name);
        return pids.length > 0 ? pids[0] : -1;
    }

    public static final int[] getProcessIDs(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Process name cannot be null!");
        }
        if (name.isEmpty()) {
            throw new IllegalArgumentException("Process name cannot be empty!");
        }
        Process process = null;
        try {
            process = Runtime.getRuntime().exec(new String[]{"tasklist", "/fo", "csv"});
            process.getOutputStream().close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        ArrayList<String> found = new ArrayList<String>();
        String line = null;
        try {
            br.readLine();
            br.readLine();
            while ((line = br.readLine()) != null) {
                String[] parts = StringUtils.split((String)line, (String)"\",\"", (int)3);
                if (!name.equalsIgnoreCase(parts[0])) continue;
                found.add(parts[1]);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
        int[] pids = new int[found.size()];
        for (int i = 0; i < found.size(); ++i) {
            pids[i] = Integer.parseInt((String)found.get(i));
        }
        return pids;
    }
}

