/*
 * Decompiled with CFR 0.152.
 */
package com.sarthakdoshi.textonimage;

import android.app.ProgressDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.net.Uri;
import android.os.Bundle;
import android.provider.MediaStore;
import android.support.v7.app.ActionBar;
import android.support.v7.app.AppCompatActivity;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.flask.colorpicker.ColorPickerView;
import com.flask.colorpicker.OnColorSelectedListener;
import com.flask.colorpicker.builder.ColorPickerClickListener;
import com.flask.colorpicker.builder.ColorPickerDialogBuilder;
import com.sarthakdoshi.textonimage.R;
import com.sarthakdoshi.textonimage.RotationGestureDetector;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TextOnImage
extends AppCompatActivity
implements RotationGestureDetector.OnRotationGestureListener {
    public static String IMAGE_IN_URI = "imageInURI";
    public static String TEXT_TO_WRITE = "sourceText";
    public static String TEXT_FONT_SIZE = "textFontSize";
    public static String TEXT_COLOR = "textColor";
    public static String IMAGE_OUT_URI = "imageOutURI";
    public static String IMAGE_OUT_ERROR = "imageOutError";
    public static int TEXT_ON_IMAGE_RESULT_OK_CODE = 1;
    public static int TEXT_ON_IMAGE_RESULT_FAILED_CODE = -1;
    public static int TEXT_ON_IMAGE_REQUEST_CODE = 4;
    private static String TAG = TextOnImage.class.getSimpleName();
    private Uri imageInUri;
    private Uri imageOutUri;
    private String saveDir = "/tmp/";
    private String textToWrite = "";
    private String textColor = "#ffffff";
    private float textFontSize;
    private TextView addTextView;
    private String errorAny = "";
    private ImageView sourceImageView;
    private RelativeLayout workingLayout;
    private RelativeLayout baseLayout;
    private ScaleGestureDetector scaleGestureDetector;
    private ProgressDialog progressDialog;
    private RotationGestureDetector mRotationGestureDetector;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.scaleGestureDetector = new ScaleGestureDetector((Context)this, (ScaleGestureDetector.OnScaleGestureListener)new simpleOnScaleGestureListener());
        this.mRotationGestureDetector = new RotationGestureDetector(this);
        this.extractBundle();
        this.uiSetup();
    }

    @Override
    public void OnRotation(RotationGestureDetector rotationDetector) {
        float angle = rotationDetector.getAngle();
        this.addTextView.setRotation(angle);
    }

    public boolean onTouchEvent(MotionEvent event) {
        this.scaleGestureDetector.onTouchEvent(event);
        this.mRotationGestureDetector.onTouchEvent(event);
        return super.onTouchEvent(event);
    }

    private void extractBundle() {
        Bundle bundle = this.getIntent().getExtras();
        this.imageInUri = Uri.parse((String)bundle.getString(IMAGE_IN_URI));
        this.textToWrite = bundle.getString(TEXT_TO_WRITE);
        this.textFontSize = bundle.getFloat(TEXT_FONT_SIZE);
        this.textColor = bundle.getString(TEXT_COLOR);
    }

    private void uiSetup() {
        this.progressDialog = new ProgressDialog((Context)this);
        this.progressDialog.setCancelable(false);
        this.progressDialog.setMessage((CharSequence)"Loading...");
        this.progressDialog.show();
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
            actionBar.setTitle((CharSequence)"Add Text");
        }
        try {
            Bitmap bitmapForImageView = MediaStore.Images.Media.getBitmap((ContentResolver)this.getContentResolver(), (Uri)this.imageInUri);
            int width = 0;
            int height = 0;
            if (bitmapForImageView.getWidth() > bitmapForImageView.getHeight()) {
                width = 1280;
                height = 720;
            } else if (bitmapForImageView.getWidth() < bitmapForImageView.getHeight()) {
                width = 720;
                height = 1280;
            } else {
                width = 600;
                height = 600;
            }
            this.baseLayout = new RelativeLayout((Context)this);
            RelativeLayout.LayoutParams baseLayoutParams = new RelativeLayout.LayoutParams(-1, -1);
            this.baseLayout.setBackgroundColor(Color.parseColor((String)"#000000"));
            this.workingLayout = new RelativeLayout((Context)this);
            RelativeLayout.LayoutParams workingLayoutParams = new RelativeLayout.LayoutParams(width, height);
            workingLayoutParams.addRule(13);
            this.workingLayout.setLayoutParams((ViewGroup.LayoutParams)workingLayoutParams);
            this.sourceImageView = new ImageView((Context)this);
            RelativeLayout.LayoutParams sourceImageParams = new RelativeLayout.LayoutParams(width, height);
            sourceImageParams.addRule(13);
            this.sourceImageView.setLayoutParams((ViewGroup.LayoutParams)sourceImageParams);
            this.addTextView = new TextView((Context)this);
            RelativeLayout.LayoutParams textViewParams = new RelativeLayout.LayoutParams(-2, -2);
            textViewParams.addRule(13);
            this.addTextView.setLayoutParams((ViewGroup.LayoutParams)textViewParams);
            this.workingLayout.addView((View)this.sourceImageView);
            this.workingLayout.addView((View)this.addTextView);
            this.baseLayout.addView((View)this.workingLayout);
            this.setContentView((View)this.baseLayout, (ViewGroup.LayoutParams)baseLayoutParams);
            this.sourceImageView.setImageBitmap(bitmapForImageView);
            this.workingLayout.setDrawingCacheEnabled(true);
            if (this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
        }
        catch (IOException e) {
            if (this.progressDialog.isShowing()) {
                this.progressDialog.dismiss();
            }
            e.printStackTrace();
        }
        this.addTextView.setText((CharSequence)this.textToWrite);
        this.addTextView.setTextSize(this.textFontSize);
        this.addTextView.setTextColor(Color.parseColor((String)this.textColor));
        this.addTextView.setOnTouchListener(new View.OnTouchListener(){
            float lastX = 0.0f;
            float lastY = 0.0f;

            public boolean onTouch(View view, MotionEvent motionEvent) {
                switch (motionEvent.getAction()) {
                    case 0: {
                        this.lastX = motionEvent.getX();
                        this.lastY = motionEvent.getY();
                        break;
                    }
                    case 2: {
                        float dx = motionEvent.getX() - this.lastX;
                        float dy = motionEvent.getY() - this.lastY;
                        float finalX = view.getX() + dx;
                        float finalY = view.getY() + dy + (float)view.getHeight();
                        view.setX(finalX);
                        view.setY(finalY);
                    }
                }
                return true;
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.menu, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == 16908332) {
            this.onBackPressed();
            return true;
        }
        if (item.getItemId() == R.id.setTextButton) {
            this.progressDialog.setMessage((CharSequence)"Adding Text");
            this.progressDialog.show();
            boolean doneSetting = this.setTextFinal();
            if (doneSetting) {
                Intent intent = new Intent();
                intent.putExtra(IMAGE_OUT_URI, this.imageOutUri.toString());
                this.setResult(TEXT_ON_IMAGE_RESULT_OK_CODE, intent);
                if (this.progressDialog.isShowing()) {
                    this.progressDialog.dismiss();
                }
                this.finish();
            } else {
                Intent intent = new Intent();
                intent.putExtra(IMAGE_OUT_ERROR, this.errorAny);
                this.setResult(TEXT_ON_IMAGE_RESULT_FAILED_CODE, intent);
                if (this.progressDialog.isShowing()) {
                    this.progressDialog.dismiss();
                }
                this.finish();
            }
            return true;
        }
        if (item.getItemId() == R.id.setColor) {
            ColorPickerDialogBuilder.with((Context)this, (int)R.style.AppTheme_ColorPicker).setTitle("Choose Color").initialColor(Color.parseColor((String)this.textColor)).wheelType(ColorPickerView.WHEEL_TYPE.CIRCLE).density(20).setOnColorSelectedListener(new OnColorSelectedListener(){

                public void onColorSelected(int i) {
                    TextOnImage.this.addTextView.setTextColor(i);
                }
            }).setPositiveButton((CharSequence)"Ok", new ColorPickerClickListener(){

                public void onClick(DialogInterface dialogInterface, int i, Integer[] integers) {
                    TextOnImage.this.addTextView.setTextColor(i);
                }
            }).setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialogInterface, int i) {
                }
            }).build().show();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private boolean setTextFinal() {
        this.addTextView.setOnTouchListener(null);
        boolean toBeReturn = false;
        this.workingLayout.buildDrawingCache();
        toBeReturn = this.saveFile(Bitmap.createBitmap((Bitmap)this.workingLayout.getDrawingCache()), "temp.jpg");
        return toBeReturn;
    }

    private boolean saveFile(Bitmap sourceImageBitmap, String fileName) {
        boolean result = false;
        String path = this.getApplicationInfo().dataDir + this.saveDir;
        File pathFile = new File(path);
        pathFile.mkdirs();
        File imageFile = new File(path, fileName);
        if (imageFile.exists()) {
            imageFile.delete();
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(imageFile);
            sourceImageBitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)out);
            result = true;
        }
        catch (Exception e) {
            this.errorAny = e.getMessage();
            result = false;
            e.printStackTrace();
        }
        this.imageOutUri = Uri.fromFile((File)imageFile);
        return result;
    }

    public class simpleOnScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        public boolean onScale(ScaleGestureDetector detector) {
            float size = TextOnImage.this.addTextView.getTextSize();
            float factor = detector.getScaleFactor();
            float product = size * factor;
            TextOnImage.this.addTextView.setTextSize(0, product);
            size = TextOnImage.this.addTextView.getTextSize();
            return true;
        }
    }
}

