/*
 * Decompiled with CFR 0.152.
 */
package com.sarthakdoshi.textonimage;

import android.view.MotionEvent;

public class RotationGestureDetector {
    private static final int INVALID_POINTER_ID = -1;
    private float fX;
    private float fY;
    private float sX;
    private float sY;
    private int ptrID1;
    private int ptrID2;
    private float mAngle;
    private OnRotationGestureListener mListener;

    public float getAngle() {
        return this.mAngle;
    }

    public RotationGestureDetector(OnRotationGestureListener listener) {
        this.mListener = listener;
        this.ptrID1 = -1;
        this.ptrID2 = -1;
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getActionMasked()) {
            case 0: {
                this.ptrID1 = event.getPointerId(event.getActionIndex());
                break;
            }
            case 5: {
                this.ptrID2 = event.getPointerId(event.getActionIndex());
                this.sX = event.getX(event.findPointerIndex(this.ptrID1));
                this.sY = event.getY(event.findPointerIndex(this.ptrID1));
                this.fX = event.getX(event.findPointerIndex(this.ptrID2));
                this.fY = event.getY(event.findPointerIndex(this.ptrID2));
                break;
            }
            case 2: {
                if (this.ptrID1 == -1 || this.ptrID2 == -1) break;
                float nsX = event.getX(event.findPointerIndex(this.ptrID1));
                float nsY = event.getY(event.findPointerIndex(this.ptrID1));
                float nfX = event.getX(event.findPointerIndex(this.ptrID2));
                float nfY = event.getY(event.findPointerIndex(this.ptrID2));
                this.mAngle = this.angleBetweenLines(this.fX, this.fY, this.sX, this.sY, nfX, nfY, nsX, nsY);
                if (this.mListener == null) break;
                this.mListener.OnRotation(this);
                break;
            }
            case 1: {
                this.ptrID1 = -1;
                break;
            }
            case 6: {
                this.ptrID2 = -1;
                break;
            }
            case 3: {
                this.ptrID1 = -1;
                this.ptrID2 = -1;
            }
        }
        return true;
    }

    private float angleBetweenLines(float fX, float fY, float sX, float sY, float nfX, float nfY, float nsX, float nsY) {
        float angle2;
        float angle1 = (float)Math.atan2(fY - sY, fX - sX);
        float angle = (float)Math.toDegrees(angle1 - (angle2 = (float)Math.atan2(nfY - nsY, nfX - nsX))) % 360.0f;
        if (angle < -180.0f) {
            angle += 360.0f;
        }
        if (angle > 180.0f) {
            angle -= 360.0f;
        }
        return angle * -1.0f;
    }

    public static interface OnRotationGestureListener {
        public void OnRotation(RotationGestureDetector var1);
    }
}

