/*
 * Decompiled with CFR 0.152.
 */
package sanskritnlp.wiki.bot;

import net.sourceforge.jwbf.core.contentRep.SimpleArticle;
import net.sourceforge.jwbf.mediawiki.actions.util.ApiException;
import net.sourceforge.jwbf.mediawiki.bots.MediaWikiBot;
import org.slf4j.LoggerFactory;
import sanskritnlp.app.sanskritNlp$;
import sanskritnlp.wiki.Section;
import sanskritnlp.wiki.bot.wikiBot;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.io.StdIn$;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.matching.Regex;

public abstract class wikiBot$class {
    public static String getSandboxPage(wikiBot $this) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ":Sandbox"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.wikiSiteName()}));
    }

    public static void login(wikiBot $this) {
        $this.bot_$eq(new MediaWikiBot(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"https://", ".", ".org/w/"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.languageCode(), $this.wikiSiteName()}))));
        if ($this.passwd().isEmpty()) {
            $this.log().info("Enter password");
            $this.passwd_$eq(StdIn$.MODULE$.readLine().trim());
        }
        $this.log().info(new StringBuilder().append((Object)$this.userName()).append((Object)":").append((Object)$this.passwd()).toString());
        $this.bot().login($this.userName(), $this.passwd());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void editArticle(wikiBot $this, SimpleArticle article, String text, String summary, boolean isMinor, int num_retries) {
        BoxedUnit boxedUnit;
        while (true) {
            try {
                article.setText(text);
                article.setEditSummary(summary);
                long nowTime = System.currentTimeMillis() / 1000L;
                if (nowTime - $this.prevEditTime() < (long)$this.minGapBetweenEditsSec()) {
                    $this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"sleeping for ", " secs"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.minGapBetweenEditsSec())})));
                    Thread.sleep($this.minGapBetweenEditsSec() * 1000);
                }
                $this.prevEditTime_$eq(nowTime);
                $this.bot().writeContent(article);
                boxedUnit = BoxedUnit.UNIT;
                return;
            }
            catch (IllegalStateException illegalStateException) {
                $this.log().warn(illegalStateException.getMessage());
                if (num_retries <= 0) break;
                --num_retries;
                continue;
            }
            catch (ApiException apiException) {
                $this.log().warn(apiException.getMessage());
                $this.login();
                if (num_retries <= 0) {
                    boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                --num_retries;
                continue;
            }
            break;
        }
        boxedUnit = BoxedUnit.UNIT;
    }

    public static final void edit(wikiBot $this, String title, String text, String summary, boolean isMinor) {
        SimpleArticle article = $this.getArticle(title, $this.getArticle$default$2());
        $this.editArticle(article, text, summary, isMinor, $this.editArticle$default$5());
    }

    public static final boolean editArticle$default$4(wikiBot $this) {
        return false;
    }

    public static final int editArticle$default$5(wikiBot $this) {
        return 3;
    }

    public static final boolean edit$default$4(wikiBot $this) {
        return false;
    }

    public static final SimpleArticle getArticle(wikiBot $this, String title, ListBuffer lstTitlesVisited) {
        SimpleArticle article;
        while (true) {
            article = $this.bot().readData(title);
            $this.log().info(new StringBuilder().append((Object)"Getting ").append((Object)title).toString());
            lstTitlesVisited.$plus$eq((Object)title);
            Regex redirectPattern = new StringOps(Predef$.MODULE$.augmentString("#[rR][eE][dD][iI][rR][eE][cC][tT]\\s+\\[\\[(.+?)\\]\\].*")).r();
            String string = article.getText().trim();
            Option option = redirectPattern.unapplySeq((CharSequence)string);
            if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break;
            String newTitle = (String)((LinearSeqOptimized)option.get()).apply(0);
            $this.log().info(new StringBuilder().append((Object)"redirected to ").append((Object)newTitle).toString());
            if (lstTitlesVisited.contains((Object)newTitle)) {
                $this.log().error(new StringBuilder().append((Object)"cyclically redirected to ").append((Object)newTitle).toString());
                return null;
            }
            title = newTitle;
        }
        return article;
    }

    public static final ListBuffer getArticle$default$2(wikiBot $this) {
        return (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    private static Tuple2 getArticleSection(wikiBot $this, String title) {
        SimpleArticle article = $this.getArticle(title, $this.getArticle$default$2());
        Section articleSection = new Section(article);
        return new Tuple2((Object)article, (Object)articleSection);
    }

    public static void replaceSectionText(wikiBot $this, SimpleArticle article, String sectionPath, String text, String summary, boolean bAppend, boolean isMinor) {
        Section articleSection = new Section(article);
        Section section = articleSection.getOrCreateSection(sectionPath, articleSection.getOrCreateSection$default$2());
        section.headText_$eq(text);
        $this.editArticle(article, articleSection.toString(), summary, isMinor, $this.editArticle$default$5());
    }

    public static boolean replaceSectionText$default$5(wikiBot $this) {
        return true;
    }

    public static boolean replaceSectionText$default$6(wikiBot $this) {
        return false;
    }

    public static void replaceRegex(wikiBot $this, SimpleArticle article, Map regexMap) {
        ObjectRef replacementText = ObjectRef.create((Object)article.getText());
        regexMap.keys().foreach((Function1)new Serializable($this, replacementText, regexMap){
            public static final long serialVersionUID = 0L;
            private final ObjectRef replacementText$1;
            private final Map regexMap$1;

            public final void apply(String regex) {
                this.replacementText$1.elem = ((String)this.replacementText$1.elem).replaceAll(regex, (String)this.regexMap$1.apply((Object)regex));
            }
            {
                this.replacementText$1 = replacementText$1;
                this.regexMap$1 = regexMap$1;
            }
        });
        article.setText((String)replacementText.elem);
    }

    public static void appendToSection(wikiBot $this, SimpleArticle article, String sectionPath, String text, String summary, boolean bAppend, boolean isMinor) {
        Section articleSection = new Section(article);
        Section section = articleSection.getOrCreateSection(sectionPath, articleSection.getOrCreateSection$default$2());
        section.headText_$eq(new StringBuilder().append((Object)section.headText()).append((Object)text).toString());
        $this.editArticle(article, articleSection.toString(), summary, isMinor, $this.editArticle$default$5());
    }

    public static boolean appendToSection$default$5(wikiBot $this) {
        return true;
    }

    public static boolean appendToSection$default$6(wikiBot $this) {
        return false;
    }

    public static void deleteSection(wikiBot $this, SimpleArticle article, String sectionPath) {
        Section articleSection = new Section(article);
        if (articleSection.deleteSection(sectionPath)) {
            String textPostDeletion = articleSection.toString();
            if (textPostDeletion.matches("\\s*")) {
                textPostDeletion = "[\u0938\u0926\u094d\u092f\u0903 \u092a\u0942\u0930\u092f\u093f\u0937\u094d\u092f\u0924\u0947]";
            }
            $this.editArticle(article, textPostDeletion, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"\u0905\u0938\u094d\u092f \u092d\u093e\u0917\u0938\u094d\u092f \u0928\u093f\u0937\u094d\u0915\u093e\u0938\u0928\u092e\u094d - ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{sectionPath})), $this.editArticle$default$4(), $this.editArticle$default$5());
        }
    }

    public static void testEditSection(wikiBot $this) {
        $this.replaceSectionText($this.getArticle(new StringBuilder().append((Object)$this.getSandboxPage()).append((Object)"2").toString(), $this.getArticle$default$2()), "/\u092a\u0930\u0940\u0915\u094d\u0937\u093e\u0935\u093f\u092d\u093e\u0917\u0903", "\u0928\u0942\u0924\u0928\u092a\u093e\u0920\u09032", "\u092a\u0930\u0940\u0915\u094d\u0937\u093e\u0935\u093f\u092d\u093e\u0917\u092f\u094b\u0917\u0903", $this.replaceSectionText$default$5(), $this.replaceSectionText$default$6());
    }

    public static void test(wikiBot $this) {
        SimpleArticle article = $this.bot().readData($this.getSandboxPage());
        $this.log().info(new StringBuilder().append((Object)"|").append((Object)article.getText()).append((Object)"|").toString());
    }

    public static void $init$(wikiBot $this) {
        $this.sanskritnlp$wiki$bot$wikiBot$_setter_$log_$eq(LoggerFactory.getLogger($this.getClass()));
        $this.sanskritnlp$wiki$bot$wikiBot$_setter_$languageCode_$eq(null);
        $this.sanskritnlp$wiki$bot$wikiBot$_setter_$wikiSiteName_$eq(null);
        $this.bot_$eq(null);
        $this.sanskritnlp$wiki$bot$wikiBot$_setter_$userName_$eq(sanskritNlp$.MODULE$.props().getProperty("WIKI_USER_NAME"));
        $this.passwd_$eq("");
        $this.sanskritnlp$wiki$bot$wikiBot$_setter_$minGapBetweenEditsSec_$eq((int)package$.MODULE$.ceil(0.0));
        $this.prevEditTime_$eq(System.currentTimeMillis() / 1000L);
    }
}

