/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.CRAIEntry;
import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.AlignmentSpan;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.cram.structure.block.Block;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class Container {
    private final ReferenceContext referenceContext;
    public int containerBlocksByteSize = 0;
    public int alignmentStart = -1;
    public int alignmentSpan = 0;
    public int nofRecords = 0;
    public long globalRecordCounter = 0L;
    public long bases = 0L;
    public int blockCount = -1;
    public int[] landmarks;
    public int checksum = 0;
    public Block[] blocks;
    public CompressionHeader compressionHeader;
    private Slice[] slices;
    public long byteOffset;

    public Slice[] getSlices() {
        return this.slices;
    }

    void setSlicesAndByteOffset(List<Slice> slices, long byteOffset) {
        for (Slice slice : slices) {
            slice.containerByteOffset = byteOffset;
        }
        this.slices = slices.toArray(new Slice[0]);
        this.byteOffset = byteOffset;
    }

    public Container(ReferenceContext refContext) {
        this.referenceContext = refContext;
    }

    public ReferenceContext getReferenceContext() {
        return this.referenceContext;
    }

    public static Container initializeFromSlices(List<Slice> containerSlices, CompressionHeader compressionHeader, long containerByteOffset) {
        Set sliceRefContexts = containerSlices.stream().map(Slice::getReferenceContext).collect(Collectors.toSet());
        if (sliceRefContexts.isEmpty()) {
            throw new CRAMException("Cannot construct a Container without any Slices");
        }
        if (sliceRefContexts.size() > 1) {
            throw new CRAMException("Cannot construct a Container from Slices with conflicting types or sequence IDs");
        }
        ReferenceContext commonRefContext = (ReferenceContext)sliceRefContexts.iterator().next();
        Container container = new Container(commonRefContext);
        container.setSlicesAndByteOffset(containerSlices, containerByteOffset);
        container.compressionHeader = compressionHeader;
        if (commonRefContext.isMappedSingleRef()) {
            int start = Integer.MAX_VALUE;
            int endPlusOne = Integer.MIN_VALUE;
            for (Slice slice : containerSlices) {
                start = Math.min(start, slice.alignmentStart);
                endPlusOne = Math.max(endPlusOne, slice.alignmentStart + slice.alignmentSpan);
            }
            container.alignmentStart = start;
            container.alignmentSpan = endPlusOne - start;
        } else {
            container.alignmentStart = -1;
            container.alignmentSpan = 0;
        }
        return container;
    }

    public void distributeIndexingParametersToSlices() {
        if (this.slices.length == 0) {
            return;
        }
        if (this.landmarks == null) {
            throw new CRAMException("Cannot set Slice indexing parameters if this Container does not have landmarks");
        }
        if (this.landmarks.length != this.slices.length) {
            String format = "This Container's landmark and slice counts do not match: %d landmarks and %d slices";
            throw new CRAMException(String.format("This Container's landmark and slice counts do not match: %d landmarks and %d slices", this.landmarks.length, this.slices.length));
        }
        if (this.containerBlocksByteSize == 0) {
            throw new CRAMException("Cannot set Slice indexing parameters if the byte size of this Container's blocks is unknown");
        }
        int lastSliceIndex = this.slices.length - 1;
        for (int i = 0; i < lastSliceIndex; ++i) {
            Slice slice = this.slices[i];
            slice.index = i;
            slice.byteOffsetFromCompressionHeaderStart = this.landmarks[i];
            slice.byteSize = this.landmarks[i + 1] - slice.byteOffsetFromCompressionHeaderStart;
        }
        Slice lastSlice = this.slices[lastSliceIndex];
        lastSlice.index = lastSliceIndex;
        lastSlice.byteOffsetFromCompressionHeaderStart = this.landmarks[lastSliceIndex];
        lastSlice.byteSize = this.containerBlocksByteSize - lastSlice.byteOffsetFromCompressionHeaderStart;
    }

    public List<CRAIEntry> getCRAIEntries() {
        if (this.isEOF()) {
            return Collections.emptyList();
        }
        return Arrays.stream(this.getSlices()).map(s -> s.getCRAIEntries(this.compressionHeader)).flatMap(Collection::stream).sorted().collect(Collectors.toList());
    }

    public String toString() {
        return String.format("seqID=%s, start=%d, span=%d, records=%d, slices=%d, blocks=%d.", this.referenceContext, this.alignmentStart, this.alignmentSpan, this.nofRecords, this.getSlices() == null ? -1 : this.getSlices().length, this.blockCount);
    }

    public boolean isEOF() {
        boolean v3 = this.containerBlocksByteSize == 15 && this.referenceContext.isUnmappedUnplaced() && this.alignmentStart == 4542278 && this.blockCount == 1 && this.nofRecords == 0 && (this.getSlices() == null || this.getSlices().length == 0);
        boolean v2 = this.containerBlocksByteSize == 11 && this.referenceContext.isUnmappedUnplaced() && this.alignmentStart == 4542278 && this.blockCount == 1 && this.nofRecords == 0 && (this.getSlices() == null || this.getSlices().length == 0);
        return v3 || v2;
    }

    public Map<ReferenceContext, AlignmentSpan> getSpans(ValidationStringency validationStringency) {
        HashMap<ReferenceContext, AlignmentSpan> containerSpanMap = new HashMap<ReferenceContext, AlignmentSpan>();
        block4: for (Slice slice : this.getSlices()) {
            switch (slice.getReferenceContext().getType()) {
                case UNMAPPED_UNPLACED_TYPE: {
                    containerSpanMap.put(ReferenceContext.UNMAPPED_UNPLACED_CONTEXT, AlignmentSpan.UNPLACED_SPAN);
                    continue block4;
                }
                case MULTIPLE_REFERENCE_TYPE: {
                    Map<ReferenceContext, AlignmentSpan> spans = slice.getMultiRefAlignmentSpans(this.compressionHeader, validationStringency);
                    for (Map.Entry<ReferenceContext, AlignmentSpan> entry : spans.entrySet()) {
                        containerSpanMap.merge(entry.getKey(), entry.getValue(), AlignmentSpan::combine);
                    }
                    continue block4;
                }
                default: {
                    AlignmentSpan alignmentSpan = new AlignmentSpan(slice.alignmentStart, slice.alignmentSpan, slice.mappedReadsCount, slice.unmappedReadsCount);
                    containerSpanMap.merge(slice.getReferenceContext(), alignmentSpan, AlignmentSpan::combine);
                }
            }
        }
        return containerSpanMap;
    }
}

