/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.external;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalByteArrayCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;

public class ExternalByteArrayEncoding
extends CRAMEncoding<byte[]> {
    private final int externalBlockContentId;

    public ExternalByteArrayEncoding(int externalBlockContentId) {
        super(EncodingID.EXTERNAL);
        this.externalBlockContentId = externalBlockContentId;
    }

    public static ExternalByteArrayEncoding fromParams(byte[] params) {
        int contentId = ITF8.readUnsignedITF8(params);
        return new ExternalByteArrayEncoding(contentId);
    }

    @Override
    public byte[] toByteArray() {
        return ITF8.writeUnsignedITF8(this.externalBlockContentId);
    }

    @Override
    public CRAMCodec<byte[]> buildCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, Map<Integer, ByteArrayInputStream> externalBlockInputMap, Map<Integer, ByteArrayOutputStream> externalBlockOutputMap) {
        ByteArrayInputStream inputStream = externalBlockInputMap == null ? null : externalBlockInputMap.get(this.externalBlockContentId);
        ByteArrayOutputStream outputStream = externalBlockOutputMap == null ? null : externalBlockOutputMap.get(this.externalBlockContentId);
        return new ExternalByteArrayCodec(inputStream, outputStream);
    }
}

