/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.core;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.core.GammaIntegerCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class GammaIntegerEncoding
extends CRAMEncoding<Integer> {
    private final int offset;

    GammaIntegerEncoding(int offset) {
        super(EncodingID.GAMMA);
        this.offset = offset;
    }

    public static GammaIntegerEncoding fromParams(byte[] data) {
        int offset = ITF8.readUnsignedITF8(data);
        return new GammaIntegerEncoding(offset);
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(5);
        ITF8.writeUnsignedITF8(this.offset, buffer);
        buffer.flip();
        byte[] array = new byte[buffer.limit()];
        buffer.get(array);
        return array;
    }

    @Override
    public CRAMCodec<Integer> buildCodec(BitInputStream coreBlockInputStream, BitOutputStream coreBlockOutputStream, Map<Integer, ByteArrayInputStream> externalBlockInputMap, Map<Integer, ByteArrayOutputStream> externalBlockOutputMap) {
        return new GammaIntegerCodec(coreBlockInputStream, coreBlockOutputStream, this.offset);
    }
}

