/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.digest;

import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.cram.digest.AbstractSerialDigest;
import htsjdk.samtools.cram.digest.ByteSumCombine;
import htsjdk.samtools.cram.digest.Crc32Hasher;
import htsjdk.samtools.cram.digest.IntegerSumCombine;
import htsjdk.samtools.cram.digest.MessageDigestHasher;
import htsjdk.samtools.cram.digest.SERIES;
import htsjdk.samtools.cram.structure.CramCompressionRecord;
import htsjdk.samtools.util.Log;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;

public class ContentDigests {
    public static final EnumSet<KNOWN_DIGESTS> ALL = EnumSet.allOf(KNOWN_DIGESTS.class);
    public static final EnumSet<KNOWN_DIGESTS> CRC32 = EnumSet.of(KNOWN_DIGESTS.BD, KNOWN_DIGESTS.SD);
    private static final Log log = Log.getInstance(ContentDigests.class);
    private List<Digester> digesters = new LinkedList<Digester>();

    public static ContentDigests create(EnumSet<KNOWN_DIGESTS> requestedDigests) {
        LinkedList<Digester> digesters = new LinkedList<Digester>();
        for (KNOWN_DIGESTS digest : requestedDigests) {
            digesters.add(digest.createDigester());
        }
        return new ContentDigests(digesters);
    }

    public static ContentDigests create(SAMBinaryTagAndValue binaryTags) {
        LinkedList<Digester> digesters = new LinkedList<Digester>();
        for (SAMBinaryTagAndValue binaryTag = binaryTags; binaryTag != null; binaryTag = binaryTag.getNext()) {
            String tagID = SAMTag.makeStringTag(binaryTag.tag);
            try {
                KNOWN_DIGESTS hash = KNOWN_DIGESTS.valueOf(tagID);
                digesters.add(hash.createDigester());
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return new ContentDigests(digesters);
    }

    private ContentDigests(List<Digester> hashers) {
        this.digesters = hashers;
    }

    void add(SAMRecord record) {
        for (Digester digester : this.digesters) {
            digester.add(record);
        }
    }

    public void add(CramCompressionRecord record) {
        for (Digester digester : this.digesters) {
            digester.addCramRecord(record);
        }
    }

    public void addSAMRecords(Iterable<SAMRecord> records) {
        for (SAMRecord record : records) {
            this.add(record);
        }
    }

    public void addCramRecords(Iterable<CramCompressionRecord> records) {
        for (CramCompressionRecord record : records) {
            this.add(record);
        }
    }

    public SAMBinaryTagAndValue getAsTags() {
        SAMBinaryTagAndValue tag = null;
        for (Digester digester : this.digesters) {
            if (tag == null) {
                tag = digester.toTag();
                continue;
            }
            tag = tag.insert(digester.toTag());
        }
        return tag;
    }

    public boolean test(SAMBinaryTagAndValue tags) {
        for (Digester digester : this.digesters) {
            SAMBinaryTagAndValue foundTag = tags.find(digester.tagCode);
            if (foundTag == null) continue;
            if (!(foundTag.value instanceof byte[])) {
                throw new RuntimeException("Expecting a byte array but got: " + foundTag.value.getClass().getName());
            }
            byte[] expected = (byte[])foundTag.value;
            byte[] actual = digester.digest.asByteArray();
            if (!Arrays.equals(expected, actual)) {
                String expectedString = ContentDigests.toHexString(expected);
                String actualString = ContentDigests.toHexString(actual);
                log.error(String.format("Content hash mismatch for tag %s, actual: %s; expected: %s", digester.tagID, actualString, expectedString));
                return false;
            }
            log.debug("Content digest ok: " + digester.tagID);
        }
        return true;
    }

    private static String toHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte t : bytes) {
            sb.append(String.format("%02x", 0xFF & t).toUpperCase()).append(' ');
        }
        return sb.toString();
    }

    private static String toHexString(byte[] bytes) {
        return ContentDigests.toHex(bytes).replace(" ", "");
    }

    public static enum KNOWN_DIGESTS {
        BD{

            @Override
            Digester createDigester() {
                return new Digester(new Crc32Hasher(new IntegerSumCombine()), SERIES.BASES, this.name());
            }
        }
        ,
        SD{

            @Override
            Digester createDigester() {
                return new Digester(new Crc32Hasher(new IntegerSumCombine()), SERIES.SCORES, this.name());
            }
        }
        ,
        B5{

            @Override
            Digester createDigester() {
                try {
                    return new Digester(new MessageDigestHasher(MessageDigest.getInstance("SHA-512"), new ByteSumCombine(), null), SERIES.BASES, this.name());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ,
        S5{

            @Override
            Digester createDigester() {
                try {
                    return new Digester(new MessageDigestHasher(MessageDigest.getInstance("SHA-512"), new ByteSumCombine(), null), SERIES.SCORES, this.name());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ,
        B1{

            @Override
            Digester createDigester() {
                try {
                    return new Digester(new MessageDigestHasher(MessageDigest.getInstance("SHA-1"), new ByteSumCombine(), null), SERIES.BASES, this.name());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        ,
        S1{

            @Override
            Digester createDigester() {
                try {
                    return new Digester(new MessageDigestHasher(MessageDigest.getInstance("SHA-1"), new ByteSumCombine(), null), SERIES.SCORES, this.name());
                }
                catch (NoSuchAlgorithmException e) {
                    throw new RuntimeException(e);
                }
            }
        };


        abstract Digester createDigester();
    }

    private static class Digester {
        final AbstractSerialDigest<?> digest;
        final SERIES series;
        final String tagID;
        final short tagCode;

        Digester(AbstractSerialDigest<?> digest, SERIES series, String tagID) {
            this.digest = digest;
            this.series = series;
            this.tagID = tagID;
            this.tagCode = SAMTag.makeBinaryTag(tagID);
        }

        void add(SAMRecord record) {
            this.digest.add(this.series.getBytes(record));
        }

        void addCramRecord(CramCompressionRecord record) {
            this.digest.add(this.series.getBytes(record));
        }

        SAMBinaryTagAndValue toTag() {
            return new SAMBinaryTagAndValue(this.tagCode, this.digest.asByteArray());
        }
    }
}

