/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import htsjdk.samtools.cram.compression.rans.Encoding;
import htsjdk.samtools.cram.compression.rans.Utils;
import java.nio.ByteBuffer;

class E04 {
    E04() {
    }

    static int compress(ByteBuffer in, Encoding.RansEncSymbol[] syms, ByteBuffer cp) {
        int in_size = in.remaining();
        ByteBuffer ptr = cp.slice();
        int rans0 = 0x800000;
        int rans1 = 0x800000;
        int rans2 = 0x800000;
        int rans3 = 0x800000;
        int i = in_size & 3;
        switch (i) {
            case 3: {
                rans2 = Encoding.RansEncPutSymbol(rans2, ptr, syms[0xFF & in.get(in_size - (i - 2))]);
            }
            case 2: {
                rans1 = Encoding.RansEncPutSymbol(rans1, ptr, syms[0xFF & in.get(in_size - (i - 1))]);
            }
            case 1: {
                rans0 = Encoding.RansEncPutSymbol(rans0, ptr, syms[0xFF & in.get(in_size - i)]);
            }
        }
        for (i = in_size & 0xFFFFFFFC; i > 0; i -= 4) {
            int c3 = 0xFF & in.get(i - 1);
            int c2 = 0xFF & in.get(i - 2);
            int c1 = 0xFF & in.get(i - 3);
            int c0 = 0xFF & in.get(i - 4);
            rans3 = Encoding.RansEncPutSymbol(rans3, ptr, syms[c3]);
            rans2 = Encoding.RansEncPutSymbol(rans2, ptr, syms[c2]);
            rans1 = Encoding.RansEncPutSymbol(rans1, ptr, syms[c1]);
            rans0 = Encoding.RansEncPutSymbol(rans0, ptr, syms[c0]);
        }
        ptr.putInt(rans3);
        ptr.putInt(rans2);
        ptr.putInt(rans1);
        ptr.putInt(rans0);
        ptr.flip();
        int cdata_size = ptr.limit();
        Utils.reverse(ptr);
        in.position(in.limit());
        return cdata_size;
    }
}

