/*
 * Decompiled with CFR 0.152.
 */
package saman.zamani.persiandate;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import saman.zamani.persiandate.PersianDateFormat;

public class PersianDate {
    private Long timeInMilliSecond;
    public static final int FARVARDIN = 1;
    public static final int ORDIBEHEST = 2;
    public static final int KHORDAD = 3;
    public static final int TIR = 4;
    public static final int MORDAD = 5;
    public static final int SHAHRIVAR = 6;
    public static final int MEHR = 7;
    public static final int ABAN = 8;
    public static final int AZAR = 9;
    public static final int DAY = 10;
    public static final int BAHMAN = 11;
    public static final int ESFAND = 12;
    public static final int AM = 1;
    public static final int PM = 2;
    public static final String AM_SHORT_NAME = "\u0642.\u0638";
    public static final String PM_SHORT_NAME = "\u0628.\u0638";
    public static final String AM_NAME = "\u0642\u0628\u0644 \u0627\u0632 \u0638\u0647\u0631";
    public static final String PM_NAME = "\u0628\u0639\u062f \u0627\u0632 \u0638\u0647\u0631";
    private int shYear;
    private int shMonth;
    private int shDay;
    private int grgYear;
    private int grgMonth;
    private int grgDay;
    private int hour;
    private int minute;
    private int second;
    private Locale locale = Locale.getDefault();
    private Dialect dialect = Dialect.IRANIAN;
    private final String[] dayNames = new String[]{"\u0634\u0646\u0628\u0647", "\u06cc\u06a9\u200c\u0634\u0646\u0628\u0647", "\u062f\u0648\u0634\u0646\u0628\u0647", "\u0633\u0647\u200c\u0634\u0646\u0628\u0647", "\u0686\u0647\u0627\u0631\u0634\u0646\u0628\u0647", "\u067e\u0646\u062c\u200c\u0634\u0646\u0628\u0647", "\u062c\u0645\u0639\u0647"};
    private final String[] dayFinglishNames = new String[]{"Shanbe", "Yekshanbe", "Doshanbe", "Seshanbe", "Chaharshanbe", "Panjshanbe", "Jom'e"};
    private final String[] dayEnglishNames = new String[]{"Saturday", "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday"};
    private final String[] monthNames = new String[]{"\u0641\u0631\u0648\u0631\u062f\u06cc\u0646", "\u0627\u0631\u062f\u06cc\u0628\u0647\u0634\u062a", "\u062e\u0631\u062f\u0627\u062f", "\u062a\u06cc\u0631", "\u0645\u0631\u062f\u0627\u062f", "\u0634\u0647\u0631\u06cc\u0648\u0631", "\u0645\u0647\u0631", "\u0622\u0628\u0627\u0646", "\u0622\u0630\u0631", "\u062f\u06cc", "\u0628\u0647\u0645\u0646", "\u0627\u0633\u0641\u0646\u062f"};
    private final String[] FinglishMonthNames = new String[]{"Farvardin", "Ordibehesht", "Khordad", "Tir", "Mordad", "Shahrivar", "Mehr", "Aban", "Azar", "Day", "Bahman", "Esfand"};
    private final String[] AfghanMonthNames = new String[]{"\u062d\u0645\u0644", "\u062b\u0648\u0631", "\u062c\u0648\u0632\u0627", "\u0633\u0631\u0637\u0627\u0646", "\u0627\u0633\u062f", "\u0633\u0646\u0628\u0644\u0647", "\u0645\u06cc\u0632\u0627\u0646", "\u0639\u0642\u0631\u0628", "\u0642\u0648\u0633", "\u062c\u062f\u06cc", "\u062f\u0644\u0648", "\u062d\u0648\u062a"};
    private final String[] KurdishMonthNames = new String[]{"\u062c\u06cc\u0698\u0646\u0627\u0646", "\u06af\u0648\u0644\u0627\u0646", "\u0632\u0647 \u0631\u062f\u0627\u0646", "\u067e\u0647 \u0631\u067e\u0647 \u0631", "\u06af\u0647 \u0644\u0627\u0648\u06cc\u0698", "\u0646\u0648\u062e\u0634\u0627\u0646", "\u0628\u0647 \u0631\u0627\u0646", "\u062e\u0647 \u0632\u0627\u0646", "\u0633\u0627\u0631\u0627\u0646", "\u0628\u0641\u0631\u0627\u0646", "\u0628\u0647 \u0646\u062f\u0627\u0646", "\u0631\u0645\u0634\u0627\u0646"};
    private final String[] PashtoMonthNames = new String[]{"\u0648\u0631\u06cc", "\u063a\u0648\u064a\u06cc", "\u063a\u0628\u0631\u06ab\u0648\u0644\u06cc", "\u0686\u0646\u06ab\u0627\u069a", "\u0632\u0645\u0631\u06cc", "\u0648\u0696\u06cc", "\u062a\u0644\u0647", "\u0644\u0693\u0645", "\u0644\u064a\u0646\u062f\u06cd", "\u0645\u0631\u063a\u0648\u0645\u06cc", "\u0633\u0644\u0648\u0627\u063a\u0647", "\u0643\u0628"};
    private final String[] GrgMonthNames = new String[]{"January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December"};

    public PersianDate() {
        this.timeInMilliSecond = new Date().getTime();
        this.init();
    }

    public PersianDate(Long timeInMilliSecond) {
        this.timeInMilliSecond = timeInMilliSecond;
        this.init();
    }

    public PersianDate(Date date) {
        this.timeInMilliSecond = date.getTime();
        this.init();
    }

    public String toString() {
        return PersianDateFormat.format(this, null);
    }

    public Locale getLocale() {
        return this.locale;
    }

    public PersianDate setLocal(Locale locale) {
        this.locale = locale;
        return this;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public PersianDate setDialect(Dialect dialect) {
        this.dialect = dialect;
        return this;
    }

    public int getShYear() {
        return this.shYear;
    }

    public PersianDate setShYear(int shYear) throws IllegalArgumentException {
        if (shYear < 1) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Year must be greater than 0");
        }
        this.shYear = shYear;
        this.changeTime(true);
        return this;
    }

    public int getShMonth() {
        return this.shMonth;
    }

    public PersianDate setShMonth(int shMonth) throws IllegalArgumentException {
        if (shMonth < 1 || shMonth > 12) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Month must be between 1 and 12");
        }
        this.shMonth = shMonth;
        this.changeTime(true);
        return this;
    }

    public int getShDay() {
        return this.shDay;
    }

    public PersianDate setShDay(int shDay) throws IllegalArgumentException {
        if (shDay < 1 || shDay > 31) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Day must be between 1 and 29~31");
        }
        if (shDay > this.getMonthLength()) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Day in the " + this.getMonthName() + " must be between 1 and " + this.getMonthLength());
        }
        this.shDay = shDay;
        this.changeTime(true);
        return this;
    }

    public int getGrgYear() {
        return this.grgYear;
    }

    public PersianDate setGrgYear(int grgYear) throws IllegalArgumentException {
        if (grgYear < 1) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Year must be greater than 0");
        }
        this.grgYear = grgYear;
        this.changeTime(false);
        return this;
    }

    public int getGrgMonth() {
        return this.grgMonth;
    }

    public PersianDate setGrgMonth(int grgMonth) throws IllegalArgumentException {
        if (grgMonth < 1 || grgMonth > 12) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Month must be between 1 and 12");
        }
        this.grgMonth = grgMonth;
        this.changeTime(false);
        return this;
    }

    public int getGrgDay() {
        return this.grgDay;
    }

    public PersianDate setGrgDay(int grgDay) throws IllegalArgumentException {
        if (grgDay < 1 || grgDay > 31) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Day must be between 1 and 28~31");
        }
        if (grgDay > this.getGrgMonthLength()) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Day in the " + this.getGrgMonthName() + " must be between 1 and " + this.getGrgMonthLength());
        }
        this.grgDay = grgDay;
        this.changeTime(false);
        return this;
    }

    public int getHour() {
        return this.hour;
    }

    public int get12FormatHour(int hour) {
        return hour <= 12 ? hour : hour - 12;
    }

    public int get12FormatHour() {
        return this.get12FormatHour(this.hour);
    }

    public PersianDate setHour(int hour) throws IllegalArgumentException {
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Hour must be between 0 and 23");
        }
        this.hour = hour;
        this.changeTime(false);
        return this;
    }

    public int getMinute() {
        return this.minute;
    }

    public PersianDate setMinute(int minute) throws IllegalArgumentException {
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Minute must be between 0 and 59");
        }
        this.minute = minute;
        this.changeTime(false);
        return this;
    }

    public int getSecond() {
        return this.second;
    }

    public PersianDate setSecond(int second) throws IllegalArgumentException {
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Second must be between 0 and 59");
        }
        this.second = second;
        this.changeTime(false);
        return this;
    }

    public PersianDate initGrgDate(int year, int month, int day) throws IllegalArgumentException {
        return this.initGrgDate(year, month, day, 0, 0, 0);
    }

    public PersianDate initGrgDate(int year, int month, int day, int hour, int minute, int second) throws IllegalArgumentException {
        if (year < 1) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Year must be greater than 0");
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Month must be between 1 and 12");
        }
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Day must be between 1 and 28~31");
        }
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Hour must be between 0 and 23");
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Minute must be between 0 and 59");
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Second must be between 0 and 59");
        }
        if (day > this.getGrgMonthLength(year, month)) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Day in the " + this.getGrgMonthName(month) + " must be between 1 and " + this.getGrgMonthLength(year, month));
        }
        this.grgYear = year;
        this.grgMonth = month;
        this.grgDay = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.changeTime(false);
        return this;
    }

    public PersianDate initJalaliDate(int year, int month, int day) throws IllegalArgumentException {
        return this.initJalaliDate(year, month, day, 0, 0, 0);
    }

    public PersianDate initJalaliDate(int year, int month, int day, int hour, int minute, int second) throws IllegalArgumentException {
        if (year < 1) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Year must be greater than 0");
        }
        if (month < 1 || month > 12) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Month must be between 1 and 12");
        }
        if (day < 1 || day > 31) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Day must be between 1 and 28~31");
        }
        if (hour < 0 || hour > 23) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Hour must be between 0 and 23");
        }
        if (minute < 0 || minute > 59) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Minute must be between 0 and 59");
        }
        if (second < 0 || second > 59) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Second must be between 0 and 59");
        }
        if (day > this.getMonthLength(year, month)) {
            throw new IllegalArgumentException("PersianDate Error: ##=> Day in the " + this.monthName(month) + " must be between 1 and " + this.getMonthLength(year, month));
        }
        this.shYear = year;
        this.shMonth = month;
        this.shDay = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.changeTime(true);
        return this;
    }

    public Long getTime() {
        return this.timeInMilliSecond;
    }

    public boolean grgIsLeap(int Year) {
        if (Year % 4 == 0) {
            if (Year % 100 == 0) {
                return Year % 400 == 0;
            }
            return true;
        }
        return false;
    }

    public boolean grgIsLeap() {
        return this.grgIsLeap(this.grgYear);
    }

    public boolean isLeap() {
        return this.isLeap(this.shYear);
    }

    public boolean isLeap(int year) {
        double[] leapYears;
        double numb;
        double referenceYear = 1375.0;
        double startYear = 1375.0;
        double yearRes = (double)year - referenceYear;
        if (yearRes == 0.0 || yearRes % 33.0 == 0.0) {
            return true;
        }
        if (yearRes > 0.0) {
            if (yearRes > 33.0) {
                numb = yearRes / 33.0;
                startYear = referenceYear + Math.floor(numb) * 33.0;
            }
        } else if (yearRes > -33.0) {
            startYear = referenceYear - 33.0;
        } else {
            numb = Math.abs(yearRes / 33.0);
            startYear = referenceYear - Math.ceil(numb) * 33.0;
        }
        return Arrays.binarySearch(leapYears = new double[]{startYear, startYear + 4.0, startYear + 8.0, startYear + 12.0, startYear + 16.0, startYear + 20.0, startYear + 24.0, startYear + 28.0, startYear + 33.0}, (double)year) >= 0;
    }

    public static boolean isJalaliLeap(int year) {
        return new PersianDate().isLeap(year);
    }

    public static boolean isGrgLeap(int year) {
        return new PersianDate().grgIsLeap(year);
    }

    public int[] gregorian_to_jalali(int gy, int gm, int gd) {
        int[] out = new int[]{gm > 2 ? gy + 1 : gy, 0, 0};
        int[] g_d_m = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
        out[2] = 355666 + 365 * gy + (out[0] + 3) / 4 - (out[0] + 99) / 100 + (out[0] + 399) / 400 + gd + g_d_m[gm - 1];
        out[0] = -1595 + 33 * (out[2] / 12053);
        out[2] = out[2] % 12053;
        out[0] = out[0] + 4 * (out[2] / 1461);
        out[2] = out[2] % 1461;
        if (out[2] > 365) {
            out[0] = out[0] + (out[2] - 1) / 365;
            out[2] = (out[2] - 1) % 365;
        }
        if (out[2] < 186) {
            out[1] = 1 + out[2] / 31;
            out[2] = 1 + out[2] % 31;
        } else {
            out[1] = 7 + (out[2] - 186) / 30;
            out[2] = 1 + (out[2] - 186) % 30;
        }
        return out;
    }

    public int[] jalali_to_gregorian(int jy, int jm, int jd) {
        int[] out = new int[]{0, 0, -355668 + 365 * (jy += 1595) + jy / 33 * 8 + (jy % 33 + 3) / 4 + jd + (jm < 7 ? (jm - 1) * 31 : (jm - 7) * 30 + 186)};
        out[0] = 400 * (out[2] / 146097);
        out[2] = out[2] % 146097;
        if (out[2] > 36524) {
            out[2] = out[2] - 1;
            out[0] = out[0] + 100 * (out[2] / 36524);
            out[2] = out[2] % 36524;
            if (out[2] >= 365) {
                out[2] = out[2] + 1;
            }
        }
        out[0] = out[0] + 4 * (out[2] / 1461);
        out[2] = out[2] % 1461;
        if (out[2] > 365) {
            out[0] = out[0] + (out[2] - 1) / 365;
            out[2] = (out[2] - 1) % 365;
        }
        int[] sal_a = new int[]{0, 31, out[0] % 4 == 0 && out[0] % 100 != 0 || out[0] % 400 == 0 ? 29 : 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        out[2] = out[2] + 1;
        while (out[1] < 13 && out[2] > sal_a[out[1]]) {
            out[2] = out[2] - sal_a[out[1]];
            out[1] = out[1] + 1;
        }
        return out;
    }

    public int dayOfWeek() {
        return this.dayOfWeek(this);
    }

    public int dayOfWeek(PersianDate date) {
        return this.dayOfWeek(date.toDate());
    }

    public int dayOfWeek(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (cal.get(7) == 7) {
            return 0;
        }
        return cal.get(7);
    }

    public ArrayList<PersianDate> getWeek(PersianDate date) {
        ArrayList<PersianDate> currentWeek = new ArrayList<PersianDate>();
        for (int i = 0; i < date.dayOfWeek(); ++i) {
            PersianDate dateTmp = new PersianDate(date.timeInMilliSecond);
            currentWeek.add(dateTmp.subDays(date.dayOfWeek() - i));
        }
        currentWeek.add(date);
        int threshold = 7 - currentWeek.size();
        for (int j = 1; j <= threshold; ++j) {
            PersianDate dateTmp = new PersianDate(date.timeInMilliSecond);
            currentWeek.add(dateTmp.addDays(j));
        }
        return currentWeek;
    }

    public PersianDate[] getWeek() {
        return this.getWeek(this).toArray(new PersianDate[0]);
    }

    public String[] monthList(Dialect dialect) {
        switch (dialect) {
            case FINGLISH: {
                return this.FinglishMonthNames;
            }
            case AFGHAN: {
                return this.AfghanMonthNames;
            }
            case KURDISH: {
                return this.KurdishMonthNames;
            }
            case PASHTO: {
                return this.PashtoMonthNames;
            }
        }
        return this.monthNames;
    }

    public String[] monthList() {
        return this.monthList(Dialect.IRANIAN);
    }

    public String monthName(int month, Dialect dialect) {
        switch (dialect) {
            case FINGLISH: {
                return this.FinglishMonthNames[month - 1];
            }
            case AFGHAN: {
                return this.AfghanMonthNames[month - 1];
            }
            case KURDISH: {
                return this.KurdishMonthNames[month - 1];
            }
            case PASHTO: {
                return this.PashtoMonthNames[month - 1];
            }
        }
        return this.monthNames[month - 1];
    }

    public String monthName(Dialect dialect) {
        return this.monthName(this.getShMonth(), dialect);
    }

    public String monthName(int shMonth) {
        return this.monthName(shMonth, this.getDialect());
    }

    public String monthName() {
        return this.monthName(Dialect.IRANIAN);
    }

    public String FinglishMonthName(int month) {
        return this.FinglishMonthNames[month - 1];
    }

    public String FinglishMonthName() {
        return this.FinglishMonthName(this.getShMonth());
    }

    public String AfghanMonthName(int month) {
        return this.AfghanMonthNames[month - 1];
    }

    public String AfghanMonthName() {
        return this.AfghanMonthName(this.getShMonth());
    }

    public String KurdishMonthName(int month) {
        return this.KurdishMonthNames[month - 1];
    }

    public String KurdishMonthName() {
        return this.KurdishMonthName(this.getShMonth());
    }

    public String PashtoMonthName(int month) {
        return this.PashtoMonthNames[month - 1];
    }

    public String PashtoMonthName() {
        return this.PashtoMonthName(this.getShMonth());
    }

    public String dayName() {
        return this.dayName(this);
    }

    public String dayName(PersianDate date) {
        return this.dayNames[this.dayOfWeek(date)];
    }

    public String dayFinglishName() {
        return this.dayFinglishName(this);
    }

    public String dayFinglishName(PersianDate date) {
        return this.dayFinglishNames[this.dayOfWeek(date)];
    }

    public String dayEnglishName() {
        return this.dayEnglishName(this);
    }

    public String dayEnglishName(PersianDate date) {
        return this.dayEnglishNames[this.dayOfWeek(date)];
    }

    public int getMonthDays() {
        return this.getMonthDays(this.getShYear(), this.getShMonth());
    }

    public int getMonthDays(int Year, int month) {
        if (month == 12 && !this.isLeap(Year)) {
            return 29;
        }
        if (month <= 6) {
            return 31;
        }
        return 30;
    }

    public int getDayInYear() {
        return this.getDayInYear(this.getShMonth(), this.getShDay());
    }

    public int getDayInYear(int month, int day) {
        for (int i = 1; i < month; ++i) {
            if (i <= 6) {
                day += 31;
                continue;
            }
            day += 30;
        }
        return day;
    }

    public PersianDate subDate(long SubYear, long SubMonth, long SubDay, long SubHour, long SubMinute, long SubSecond) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.toDate());
        if (SubYear >= 1L) {
            cal.add(1, (int)(-SubYear));
        }
        if (SubMonth >= 1L) {
            cal.add(2, (int)(-SubMonth));
        }
        if (SubDay >= 1L) {
            cal.add(5, (int)(-SubDay));
        }
        if (SubHour >= 1L) {
            cal.add(11, (int)(-SubHour));
        }
        if (SubMinute >= 1L) {
            cal.add(12, (int)(-SubMinute));
        }
        if (SubSecond >= 1L) {
            cal.add(13, (int)(-SubSecond));
        }
        this.timeInMilliSecond = cal.getTimeInMillis();
        this.init();
        return this;
    }

    public PersianDate subDate(long SubYear, long SubMonth, long SubDay) {
        return this.subDate(SubYear, SubMonth, SubDay, 0L, 0L, 0L);
    }

    public PersianDate subYears(int years) {
        return this.subDate(years, 0L, 0L);
    }

    public PersianDate subYear() {
        return this.subYears(1);
    }

    public PersianDate subMonths(int months) {
        return this.subDate(0L, months, 0L);
    }

    public PersianDate subMonth() {
        return this.subMonths(1);
    }

    public PersianDate subDays(int days) {
        return this.subDate(0L, 0L, days);
    }

    public PersianDate subDay() {
        return this.subDays(1);
    }

    public PersianDate subHours(int hours) {
        return this.subDate(0L, 0L, 0L, hours, 0L, 0L);
    }

    public PersianDate subHour() {
        return this.subHours(1);
    }

    public PersianDate subMinutes(int minutes) {
        return this.subDate(0L, 0L, 0L, 0L, minutes, 0L);
    }

    public PersianDate subMinute() {
        return this.subMinutes(1);
    }

    public PersianDate subSeconds(int seconds) {
        return this.subDate(0L, 0L, 0L, 0L, 0L, seconds);
    }

    public PersianDate subSecond() {
        return this.subSeconds(1);
    }

    public PersianDate subWeeks(int weeks) {
        return this.subDays(7 * weeks);
    }

    public PersianDate subWeek() {
        return this.subWeeks(1);
    }

    public PersianDate addDate(long AddYear, long AddMonth, long AddDay, long AddHour, long AddMinute, long AddSecond) throws IllegalArgumentException {
        Calendar cal = Calendar.getInstance();
        cal.setTime(this.toDate());
        if (AddYear >= 1L) {
            cal.add(1, (int)AddYear);
        }
        if (AddMonth >= 1L) {
            cal.add(2, (int)AddMonth);
        }
        if (AddDay >= 1L) {
            cal.add(5, (int)AddDay);
        }
        if (AddHour >= 1L) {
            cal.add(11, (int)AddHour);
        }
        if (AddMinute >= 1L) {
            cal.add(12, (int)AddMinute);
        }
        if (AddSecond >= 1L) {
            cal.add(13, (int)AddSecond);
        }
        this.timeInMilliSecond = cal.getTimeInMillis();
        this.init();
        return this;
    }

    public PersianDate addDate(long year, long month, long day) {
        return this.addDate(year, month, day, 0L, 0L, 0L);
    }

    public PersianDate addYear() {
        return this.addYears(1);
    }

    public PersianDate addYears(int year) {
        return this.addDate(year, 0L, 0L);
    }

    public PersianDate addMonth() {
        return this.addMonths(1);
    }

    public PersianDate addMonths(int month) {
        return this.addDate(0L, month, 0L);
    }

    public PersianDate addWeek() {
        return this.addWeeks(1);
    }

    public PersianDate addWeeks(int week) {
        return this.addDays(7 * week);
    }

    public PersianDate addDay() {
        return this.addDays(1);
    }

    public PersianDate addDays(int day) {
        return this.addDate(0L, 0L, day);
    }

    public PersianDate addHour() {
        return this.addHours(1);
    }

    public PersianDate addHours(int hour) {
        return this.addDate(0L, 0L, 0L, hour, 0L, 0L);
    }

    public PersianDate addMinute() {
        return this.addMinutes(1);
    }

    public PersianDate addMinutes(int minute) {
        return this.addDate(0L, 0L, 0L, 0L, minute, 0L);
    }

    public PersianDate addSecond() {
        return this.addSeconds(1);
    }

    public PersianDate addSeconds(int second) {
        return this.addDate(0L, 0L, 0L, 0L, 0L, second);
    }

    public Boolean after(PersianDate dateInput) {
        return this.timeInMilliSecond < dateInput.getTime();
    }

    public Boolean before(PersianDate dateInput) {
        return this.after(dateInput) == false;
    }

    public Boolean equals(PersianDate dateInput) {
        return this.timeInMilliSecond.equals(dateInput.getTime());
    }

    public int compareTo(PersianDate anotherDate) {
        return this.timeInMilliSecond.compareTo(anotherDate.getTime());
    }

    public boolean isToday() {
        return this.isToday(this);
    }

    public boolean isToday(PersianDate date) {
        return date.getDayUntilToday() == 0L;
    }

    public long getDayUntilToday() {
        return this.getDayUntilToday(new PersianDate());
    }

    public long getDayUntilToday(PersianDate date) {
        long[] ret = this.untilToday(date);
        return ret[0];
    }

    public long[] untilToday() {
        return this.untilToday(new PersianDate());
    }

    public long[] untilToday(PersianDate date) {
        long secondsInMilli = 1000L;
        long minutesInMilli = secondsInMilli * 60L;
        long hoursInMilli = minutesInMilli * 60L;
        long daysInMilli = hoursInMilli * 24L;
        long different = Math.abs(this.timeInMilliSecond - date.getTime());
        long elapsedDays = different / daysInMilli;
        long elapsedHours = (different %= daysInMilli) / hoursInMilli;
        long elapsedMinutes = (different %= hoursInMilli) / minutesInMilli;
        long elapsedSeconds = (different %= minutesInMilli) / secondsInMilli;
        return new long[]{elapsedDays, elapsedHours, elapsedMinutes, elapsedSeconds};
    }

    public Date toDate() {
        return new Date(this.timeInMilliSecond);
    }

    public static PersianDate today() {
        PersianDate persianDate = new PersianDate();
        persianDate.setHour(0).setMinute(0).setSecond(0);
        return persianDate;
    }

    public static PersianDate tomorrow() {
        PersianDate persianDate = new PersianDate();
        persianDate.addDay();
        persianDate.setHour(0).setMinute(0).setSecond(0);
        return persianDate;
    }

    public PersianDate startOfDay(PersianDate persianDate) {
        persianDate.setHour(0).setMinute(0).setSecond(0);
        return persianDate;
    }

    public PersianDate startOfDay() {
        return this.startOfDay(this);
    }

    public PersianDate endOfDay(PersianDate persianDate) {
        persianDate.setHour(23).setMinute(59).setSecond(59);
        return persianDate;
    }

    public PersianDate endOfDay() {
        return this.endOfDay(this);
    }

    public Boolean isMidNight(PersianDate persianDate) {
        return persianDate.isMidNight();
    }

    public Boolean isMidNight() {
        return this.hour < 12;
    }

    public String getShortTimeOfTheDay() {
        return this.isMidNight() != false ? AM_SHORT_NAME : PM_SHORT_NAME;
    }

    public String getShortTimeOfTheDay(PersianDate persianDate) {
        return persianDate.isMidNight() != false ? AM_SHORT_NAME : PM_SHORT_NAME;
    }

    public String getTimeOfTheDay() {
        return this.isMidNight() != false ? AM_NAME : PM_NAME;
    }

    public String getTimeOfTheDay(PersianDate persianDate) {
        return persianDate.isMidNight() != false ? AM_NAME : PM_NAME;
    }

    public int getGrgMonthLength(int grgYear, int grgMonth) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, grgYear);
        cal.set(2, grgMonth - 1);
        return cal.getActualMaximum(5);
    }

    public int getGrgMonthLength(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal.getActualMaximum(5);
    }

    public int getGrgMonthLength() {
        return this.getGrgMonthLength(this.toDate());
    }

    public String getGrgMonthName(int grgMonth) {
        if (grgMonth < 1 || grgMonth > 12) {
            return "";
        }
        return this.GrgMonthNames[grgMonth - 1];
    }

    public String getGrgMonthName() {
        return this.getGrgMonthName(this.getGrgMonth());
    }

    public int getMonthLength(Integer year, Integer month) {
        if (month <= 6) {
            return 31;
        }
        if (month <= 11) {
            return 30;
        }
        if (this.isLeap(year)) {
            return 30;
        }
        return 29;
    }

    public int getMonthLength(PersianDate persianDate) {
        return this.getMonthLength(persianDate.getShYear(), persianDate.getShMonth());
    }

    public int getMonthLength() {
        return this.getMonthLength(this);
    }

    public String getMonthName() {
        return this.getMonthName(this);
    }

    public String getMonthName(PersianDate pDate, Dialect dialect) {
        if (pDate.getShMonth() > pDate.monthList(dialect).length) {
            return "";
        }
        return pDate.monthList(dialect)[pDate.getShMonth() - 1];
    }

    public String getMonthName(Dialect dialect) {
        if (this.getShMonth() > this.monthList(dialect).length) {
            return "";
        }
        return this.monthList(dialect)[this.getShMonth() - 1];
    }

    public String getMonthName(PersianDate pDate) {
        if (pDate.getShMonth() > pDate.monthList().length) {
            return "";
        }
        return pDate.monthList()[pDate.getShMonth() - 1];
    }

    private String textNumberFilter(String date) {
        if (date.length() < 2) {
            return "0" + date;
        }
        return date;
    }

    private void init() {
        this.grgYear = Integer.parseInt(new SimpleDateFormat("yyyy", this.locale).format(this.timeInMilliSecond));
        this.grgMonth = Integer.parseInt(new SimpleDateFormat("MM", this.locale).format(this.timeInMilliSecond));
        this.grgDay = Integer.parseInt(new SimpleDateFormat("dd", this.locale).format(this.timeInMilliSecond));
        this.hour = Integer.parseInt(new SimpleDateFormat("HH", this.locale).format(this.timeInMilliSecond));
        this.minute = Integer.parseInt(new SimpleDateFormat("mm", this.locale).format(this.timeInMilliSecond));
        this.second = Integer.parseInt(new SimpleDateFormat("ss", this.locale).format(this.timeInMilliSecond));
        this.changeTime(false);
    }

    private void changeTime(boolean isJalaliChanged) {
        if (isJalaliChanged) {
            this.TimeCalcFromJalali(this.shYear, this.shMonth, this.shDay, this.hour, this.minute, this.second);
        } else {
            this.TimeCalcFromGrg(this.grgYear, this.grgMonth, this.grgDay, this.hour, this.minute, this.second);
        }
    }

    private void TimeCalcFromJalali(int year, int month, int day, int hr, int min, int sec) {
        int[] grgTimes = new int[]{0, 0, 0, 0, 0, 0};
        int[] jalaliTimes = new int[]{year, month, day, hr, min, sec};
        int[] convertedTime = this.jalali_to_gregorian(year, month, day);
        grgTimes[0] = convertedTime[0];
        grgTimes[1] = convertedTime[1];
        grgTimes[2] = convertedTime[2];
        grgTimes[3] = hr;
        grgTimes[4] = min;
        grgTimes[5] = sec;
        this.notify(grgTimes, jalaliTimes);
    }

    private void TimeCalcFromGrg(int year, int month, int day, int hr, int min, int sec) {
        int[] grgTimes = new int[]{year, month, day, hr, min, sec};
        int[] jalaliTimes = new int[]{0, 0, 0, 0, 0, 0};
        int[] convertedTime = this.gregorian_to_jalali(year, month, day);
        jalaliTimes[0] = convertedTime[0];
        jalaliTimes[1] = convertedTime[1];
        jalaliTimes[2] = convertedTime[2];
        jalaliTimes[3] = hr;
        jalaliTimes[4] = min;
        jalaliTimes[5] = sec;
        this.notify(grgTimes, jalaliTimes);
    }

    private void updateTimeStamp() {
        try {
            this.timeInMilliSecond = Objects.requireNonNull(new SimpleDateFormat("dd/MM/yyyy HH:mm:ss", this.locale).parse("" + this.grgDay + "/" + this.grgMonth + "/" + this.getGrgYear() + " " + this.hour + ":" + this.minute + ":" + this.second)).getTime();
        }
        catch (ParseException e) {
            this.timeInMilliSecond = new Date().getTime();
        }
    }

    private void notify(int[] grg, int[] jalali) {
        this.grgYear = grg[0];
        this.grgMonth = grg[1];
        this.grgDay = grg[2];
        this.shYear = jalali[0];
        this.shMonth = jalali[1];
        this.shDay = jalali[2];
        this.hour = jalali[3];
        this.minute = jalali[4];
        this.second = jalali[5];
        this.updateTimeStamp();
    }

    public static enum Dialect {
        FINGLISH,
        AFGHAN,
        IRANIAN,
        KURDISH,
        PASHTO;

    }
}

