/*
 * Decompiled with CFR 0.152.
 */
package ir.androidexception.datatable.utility;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Color;
import android.graphics.Typeface;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import ir.androidexception.datatable.adapter.RowItemAdapter;
import ir.androidexception.datatable.enums.Gravity;

public class ViewGenerator {
    @SuppressLint(value={"RtlHardcoded"})
    public static TextView generateTextView(Context context, String text, int weight, @ColorInt Integer backgroundColor, @ColorInt Integer textColor, float leftPadding, float topPadding, float rightPadding, float bottomPadding, float leftMargin, float topMargin, float rightMargin, float bottomMargin, float textSize, Typeface typeface, Integer style, Gravity gravity) {
        TextView tv = new TextView(context);
        tv.setText((CharSequence)text);
        tv.setId(View.generateViewId());
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(0, -2);
        layoutParams.weight = weight;
        layoutParams.leftMargin = (int)leftMargin;
        layoutParams.topMargin = (int)topMargin;
        layoutParams.rightMargin = (int)rightMargin;
        layoutParams.bottomMargin = (int)bottomMargin;
        tv.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        tv.setBackgroundColor(backgroundColor != null ? backgroundColor : 0);
        tv.setTextColor(textColor != null ? textColor : -16777216);
        switch (gravity) {
            case RIGHT: {
                tv.setGravity(5);
                break;
            }
            case CENTER: {
                tv.setGravity(17);
                break;
            }
            case LEFT: {
                tv.setGravity(3);
            }
        }
        tv.setPadding((int)leftPadding, (int)topPadding, (int)rightPadding, (int)bottomPadding);
        tv.setTextSize(textSize);
        if (typeface != null) {
            tv.setTypeface(typeface, style != null ? style : 0);
        } else {
            tv.setTypeface(null, style != null ? style : 0);
        }
        return tv;
    }

    public static RecyclerView generateRecyclerView(Context context, RowItemAdapter rowItemAdapter) {
        RecyclerView recyclerView = new RecyclerView(context);
        RecyclerView.LayoutParams layoutParams = new RecyclerView.LayoutParams(-1, -2);
        recyclerView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        recyclerView.setId(View.generateViewId());
        recyclerView.setAdapter((RecyclerView.Adapter)rowItemAdapter);
        recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context, 1, false));
        return recyclerView;
    }

    public static LinearLayout generateVerticalLinearLayout(Context context) {
        LinearLayout verticalLinearLayout = new LinearLayout(context);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        verticalLinearLayout.setOrientation(1);
        verticalLinearLayout.setId(View.generateViewId());
        verticalLinearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        return verticalLinearLayout;
    }

    public static LinearLayout generateHorizontalLinearLayout(Context context) {
        LinearLayout horizontalLinearLayout = new LinearLayout(context);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, -2);
        horizontalLinearLayout.setOrientation(0);
        horizontalLinearLayout.setId(View.generateViewId());
        horizontalLinearLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        horizontalLinearLayout.setGravity(16);
        return horizontalLinearLayout;
    }

    public static View generateDivider(Context context, Integer height, @ColorInt Integer color) {
        View view = new View(context);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, height != null ? height : 1);
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        view.setBackgroundColor(color != null ? color : Color.parseColor((String)"#e0e2e5"));
        view.setId(View.generateViewId());
        return view;
    }
}

