/*
 * Decompiled with CFR 0.152.
 */
package safety.com.br.android_shake_detector.core;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.hardware.Sensor;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import java.util.List;
import safety.com.br.android_shake_detector.core.AppPreferences;
import safety.com.br.android_shake_detector.core.ShakeBroadCastReceiver;
import safety.com.br.android_shake_detector.core.ShakeCallback;
import safety.com.br.android_shake_detector.core.ShakeListener;
import safety.com.br.android_shake_detector.core.ShakeOptions;
import safety.com.br.android_shake_detector.core.ShakeService;

public class ShakeDetector {
    private SensorManager sensorManager;
    private Context context;
    private ShakeCallback shakeCallback;
    private Sensor sensor;
    private boolean isRunning;
    private ShakeOptions shakeOptions;
    private AppPreferences appPreferences;
    private ShakeBroadCastReceiver shakeBroadCastReceiver;

    public ShakeDetector() {
    }

    public ShakeDetector(ShakeOptions shakeOptions) {
        this.shakeOptions = shakeOptions;
    }

    public ShakeDetector start(Context context, ShakeCallback shakeCallback) {
        this.shakeCallback = shakeCallback;
        this.shakeBroadCastReceiver = new ShakeBroadCastReceiver(shakeCallback);
        if (this.shakeOptions.isBackground() && !(!this.shakeBroadCastReceiver.isOrderedBroadcast())) {
            this.registerPrivateBroadCast(context);
        }
        this.saveOptionsInStorage(context);
        this.startShakeService(context);
        return this;
    }

    public void stop(Context context) {
        if (this.shakeBroadCastReceiver.isOrderedBroadcast()) {
            context.unregisterReceiver((BroadcastReceiver)this.shakeBroadCastReceiver);
        }
    }

    private void startShakeService(Context context) {
        Intent serviceIntent = new Intent(context, ShakeService.class);
        context.startService(serviceIntent);
    }

    public ShakeDetector startService(Context context) {
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
        List sensors = this.sensorManager.getSensorList(1);
        if (sensors.size() > 0) {
            this.sensor = (Sensor)sensors.get(0);
            this.isRunning = this.sensorManager.registerListener((SensorEventListener)new ShakeListener(this.shakeOptions, context), this.sensor, 1);
        }
        return this;
    }

    public void saveOptionsInStorage(Context context) {
        this.appPreferences = new AppPreferences(context);
        this.appPreferences.putBoolean("BACKGROUND", this.shakeOptions.isBackground());
        this.appPreferences.putInt("SHAKE_COUNT", this.shakeOptions.getShakeCounts());
        this.appPreferences.putInt("INTERVAL", this.shakeOptions.getInterval());
        this.appPreferences.putFloat("SENSIBILITY", Float.valueOf(this.shakeOptions.getSensibility()));
    }

    private void registerPrivateBroadCast(Context context) {
        IntentFilter filter = new IntentFilter();
        filter.addAction("shake.detector");
        context.registerReceiver((BroadcastReceiver)this.shakeBroadCastReceiver, filter);
    }

    public Boolean isRunning() {
        return this.isRunning;
    }
}

